/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.ui.custom.out.common.properties.ControlFactory;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Externalize;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.diagram.custom.properties.Messages;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class ExternalizePropertySection
extends AbstractModelerPropertySection {
    public static Image warningImage = null;
    Composite parent;
    Configuration currentConf;
    Map<String, ExternalizeProperties> composites = new HashMap<String, ExternalizeProperties>();

    static {
        try {
            warningImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/obj16/warn_tsk.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    ExternalizePropertySection() {
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(part, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        ArrayList<Object> transformedSelection = new ArrayList<Object>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (r == null) continue;
            transformedSelection.add(r);
        }
        super.setInput(part, (ISelection)new StructuredSelection(transformedSelection));
        this.initializeControls();
    }

    protected Object transformSelection(Object selected) {
        View view;
        if (selected instanceof EditPart) {
            Object model = ((EditPart)selected).getModel();
            return model instanceof View ? ((View)model).getElement() : null;
        }
        if (selected instanceof View) {
            return ((View)selected).getElement();
        }
        if (selected instanceof IAdaptable && (view = (View)((IAdaptable)selected).getAdapter(View.class)) != null) {
            return view.getElement();
        }
        return selected;
    }

    protected void initializeControls() {
        this.currentConf = (Configuration)this.getEObject();
        if (this.currentConf != null) {
            if (this.parent.getChildren() != null) {
                Control[] controlArray = this.parent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control ctrl = controlArray[n2];
                    ctrl.dispose();
                    ++n2;
                }
            }
            ExternalizeProperties properties = new ExternalizeProperties(this.currentConf.getLevel());
            this.parent.layout();
            this.parent.pack();
            properties.refresh();
        }
    }

    class ExternalizeProperties {
        Composite topComposite;
        Level level;
        List<ExternalizeProperty> lists;

        private boolean[] externalizationAllowed(Property prop) {
            if (prop != null && !prop.isUnbounded() && prop.getType() != PropertyType.REFERENCE) {
                if (prop.getXpathCondition() != null && !prop.getXpathCondition().isEmpty()) {
                    try {
                        if (!ExternalizePropertySection.this.currentConf.evaluateMdBoolean(prop.getXpathCondition())) {
                            return new boolean[1];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (prop.isSetExternalizable()) {
                    if (prop.isExternalizable()) {
                        boolean[] blArray = new boolean[2];
                        blArray[0] = true;
                        return blArray;
                    }
                    Externalize e = ExternalizePropertySection.this.currentConf.getExternalize(prop);
                    if (e != null) {
                        return new boolean[]{true, true};
                    }
                    return new boolean[1];
                }
                boolean[] blArray = new boolean[2];
                blArray[0] = true;
                return blArray;
            }
            return new boolean[1];
        }

        private ExternalizeProperties(Level level) {
            block3: {
                block2: {
                    this.lists = new ArrayList<ExternalizeProperty>();
                    this.topComposite = ExternalizePropertySection.this.getWidgetFactory().createComposite(ExternalizePropertySection.this.parent);
                    GridData gridData = new GridData(768);
                    this.topComposite.setLayoutData((Object)gridData);
                    this.topComposite.setLayout((Layout)new GridLayout(2, false));
                    gridData = new GridData();
                    if (!(ExternalizePropertySection.this.currentConf instanceof MdNode)) break block2;
                    if (level == null) break block3;
                    for (Property prop : level.getAttribute()) {
                        boolean[] b = this.externalizationAllowed(prop);
                        if (!b[0]) continue;
                        this.lists.add(new ExternalizeProperty(this, prop, b[1]));
                    }
                    break block3;
                }
                for (Attribute attr : ExternalizePropertySection.this.currentConf.getAttribute()) {
                    Property prop;
                    boolean[] b;
                    if (attr.getValue() == null || attr.getValue().isEmpty() || !(b = this.externalizationAllowed(prop = attr.getTechProperty()))[0]) continue;
                    this.lists.add(new ExternalizeProperty(this, attr.getTechProperty(), b[1]));
                }
            }
        }

        void refresh() {
            for (ExternalizeProperty ep : this.lists) {
                ep.refresh();
            }
        }
    }

    class ExternalizeProperty {
        Button b;
        Hyperlink hp;
        Externalize ext;
        Property prop;
        ExternalizeProperties properties;
        ControlDecoration decoration;

        private void refresh() {
            if (ExternalizePropertySection.this.currentConf instanceof MdNode) {
                Externalize _ext = ExternalizePropertySection.this.currentConf.getExternalize(this.prop);
                if (_ext != null) {
                    this.b.setSelection(_ext.isEnable());
                } else {
                    this.b.setEnabled(false);
                    if (this.prop.isExternalize()) {
                        this.b.setSelection(true);
                    }
                }
                this.ext = _ext != null ? _ext : MdFactory.eINSTANCE.createExternalize();
            } else {
                this.ext = ExternalizePropertySection.this.currentConf.getExternalize(this.prop);
                if (this.ext != null) {
                    this.b.setSelection(false);
                } else {
                    this.b.setSelection(true);
                    this.ext = MdFactory.eINSTANCE.createExternalize();
                    this.ext.setDefType(this.prop.getFullCode());
                    this.ext.setEnable(false);
                }
            }
        }

        private ExternalizeProperty(ExternalizeProperties properties, Property prop, final boolean shouldNotExist) {
            this.properties = properties;
            this.prop = prop;
            this.b = ExternalizePropertySection.this.getWidgetFactory().createButton(properties.topComposite, "", 32);
            this.b.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    CompoundCommand cc = new CompoundCommand();
                    TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf);
                    for (Object o : ExternalizePropertySection.this.getInput()) {
                        if (!(o instanceof Configuration)) continue;
                        Externalize ee = ((Configuration)o).getExternalize(ExternalizeProperty.this.prop);
                        if (o instanceof MdNode) {
                            if (ee == null) {
                                Externalize _ext = MdFactory.eINSTANCE.createExternalize();
                                _ext.setDefType(ExternalizeProperty.this.ext.getDefType());
                                _ext.setEnable(ExternalizeProperty.this.b.getSelection());
                                cc.append((Command)new AddCommand((EditingDomain)ed, (EObject)((MdNode)o), (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)_ext));
                                continue;
                            }
                            cc.append((Command)new SetCommand((EditingDomain)ed, (EObject)ee, (EStructuralFeature)MdPackage.eINSTANCE.getExternalize_Enable(), (Object)ExternalizeProperty.this.b.getSelection()));
                            continue;
                        }
                        if (!(o instanceof Configuration)) continue;
                        if (ExternalizeProperty.this.b.getSelection()) {
                            cc.append((Command)new RemoveCommand((EditingDomain)ed, (EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)ExternalizeProperty.this.ext));
                            break;
                        }
                        cc.append((Command)new AddCommand((EditingDomain)ed, (EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)ExternalizeProperty.this.ext));
                        break;
                    }
                    ed.getCommandStack().execute((Command)cc);
                    ExternalizeProperty.this.refresh();
                }
            });
            Label toDecorate = null;
            if (ExternalizePropertySection.this.currentConf instanceof MdNode) {
                String cat = prop.getCategory();
                String name = cat != null && !cat.isEmpty() ? String.valueOf(cat.replace(":", "/")) + "/" : "";
                name = String.valueOf(name) + prop.getDisplayName();
                Hyperlink hp = ExternalizePropertySection.this.getWidgetFactory().createHyperlink(properties.topComposite, name, 0);
                if (prop.getToolTip() != null && !prop.getToolTip().isEmpty()) {
                    hp.setToolTipText(prop.getToolTip());
                }
                hp.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        Externalize ee;
                        CompoundCommand cc;
                        TransactionalEditingDomain ed;
                        if (shouldNotExist) {
                            ed = TransactionUtil.getEditingDomain((EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf);
                            cc = new CompoundCommand();
                            for (Object o : ExternalizePropertySection.this.getInput()) {
                                if (!(o instanceof Configuration) || (ee = ((Configuration)o).getExternalize(ExternalizeProperty.this.prop)) == null) continue;
                                cc.append((Command)new RemoveCommand((EditingDomain)ed, (EObject)((MdNode)o), (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)ee));
                            }
                            ed.getCommandStack().execute((Command)cc);
                            ExternalizePropertySection.this.initializeControls();
                        }
                        ExternalizeProperty.this.b.setEnabled(!ExternalizeProperty.this.b.isEnabled());
                        if (ExternalizeProperty.this.b.isEnabled()) {
                            ExternalizeProperty.this.b.setSelection(!ExternalizeProperty.this.prop.isExternalize());
                            ExternalizeProperty.this.ext.setEnable(ExternalizeProperty.this.b.getSelection());
                            ExternalizeProperty.this.ext.setDefType(ExternalizeProperty.this.prop.getFullCode());
                            ed = TransactionUtil.getEditingDomain((EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf);
                            cc = new CompoundCommand();
                            for (Object o : ExternalizePropertySection.this.getInput()) {
                                if (!(o instanceof Configuration) || (ee = ((Configuration)o).getExternalize(ExternalizeProperty.this.prop)) != null) continue;
                                Externalize _ext = MdFactory.eINSTANCE.createExternalize();
                                _ext.setDefType(ExternalizeProperty.this.ext.getDefType());
                                _ext.setEnable(ExternalizeProperty.this.b.getSelection());
                                cc.append((Command)new AddCommand((EditingDomain)ed, (EObject)((MdNode)o), (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)_ext));
                            }
                            ed.getCommandStack().execute((Command)cc);
                            if (ExternalizeProperty.this.decoration != null) {
                                ExternalizeProperty.this.decoration.show();
                            }
                        } else {
                            if (((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf instanceof MdNode) {
                                ExternalizeProperty.this.b.setSelection(ExternalizeProperty.this.prop.isExternalize());
                            } else {
                                ExternalizeProperty.this.b.setSelection(true);
                            }
                            ed = TransactionUtil.getEditingDomain((EObject)((ExternalizeProperty)ExternalizeProperty.this).ExternalizePropertySection.this.currentConf);
                            cc = new CompoundCommand();
                            for (Object o : ExternalizePropertySection.this.getInput()) {
                                if (!(o instanceof Configuration) || (ee = ((Configuration)o).getExternalize(ExternalizeProperty.this.prop)) == null) continue;
                                cc.append((Command)new RemoveCommand((EditingDomain)ed, (EObject)((MdNode)o), (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Externalize(), (Object)ee));
                            }
                            ed.getCommandStack().execute((Command)cc);
                            if (ExternalizeProperty.this.decoration != null) {
                                ExternalizeProperty.this.decoration.hide();
                                ExternalizeProperty.this.decoration.getControl().getParent().layout(true);
                            }
                        }
                        ExternalizeProperty.this.refresh();
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
                toDecorate = hp;
            } else {
                toDecorate = ExternalizePropertySection.this.getWidgetFactory().createLabel(properties.topComposite, prop.getDisplayName(), 0);
            }
            if (shouldNotExist) {
                this.decoration = new ControlDecoration((Control)toDecorate, 131072);
                this.decoration.setDescriptionText(Messages.ExternalizePropertySection_0);
                this.decoration.setImage(warningImage);
                this.decoration.setShowOnlyOnFocus(false);
                toDecorate.addPaintListener((PaintListener)new ControlFactory.DeprecatedPaintListener());
                this.b.setEnabled(false);
            }
        }
    }
}

