/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.diagram.custom.properties.IMdSectionHelper;
import com.stambia.md.diagram.part.MdDiagramEditorPlugin;
import java.lang.ref.WeakReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

class MdValueSetter {
    private IMdSectionHelper helper;

    MdValueSetter(IMdSectionHelper helper) {
        this.helper = helper;
    }

    Command createChangeNameCommand(Configuration conf, Object value) {
        boolean valueChanged = false;
        SetCommand cmd = null;
        if (value == null || value.equals("")) {
            valueChanged = conf.getName() != null && !conf.getName().isEmpty();
        } else {
            boolean bl = valueChanged = !value.equals(conf.getName());
        }
        if (valueChanged) {
            cmd = new SetCommand(this.helper.getEditingDomain(), (EObject)conf, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Name(), value);
        }
        return cmd;
    }

    Object adapt(Object object) {
        if (object instanceof WeakReference) {
            object = ((WeakReference)object).get();
        }
        if (!(object instanceof EObject) && object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(MdNode.class);
        }
        return object;
    }

    protected void setValue(Object value, String code) {
        if (code == null) {
            return;
        }
        CompoundCommand command = new CompoundCommand();
        for (Object object : this.helper.getInput()) {
            object = this.adapt(object);
            Command cmd = null;
            if (!(object instanceof Configuration)) continue;
            if (value instanceof Boolean) {
                value = value.toString();
            }
            Configuration conf = (Configuration)object;
            cmd = code.equals("tech:name") ? this.createChangeNameCommand(conf, value) : this.createSetCommand(conf, code, value);
            if (cmd == null || cmd == IdentityCommand.INSTANCE) continue;
            command.append(cmd);
        }
        if (command != null && !command.isEmpty()) {
            this.helper.getEditingDomain().getCommandStack().execute((Command)command);
        }
    }

    private Command createSetCommand(Configuration conf, String code, Object value) {
        Command cmd = conf.setAttributeCommand(code, value);
        Attribute att = conf.getAttributeByShortCode(code);
        if (att != null) {
            MdDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory().adapt((Notifier)att, ITreeItemContentProvider.class);
        }
        return cmd;
    }
}

