/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HeaderParser {
    private String header;
    private String authenticationScheme;
    private Map<String, String> parameters = new HashMap<String, String>();

    public HeaderParser(String header) {
        this.header = header;
        this.parse();
    }

    public void setData(String headerString) {
        this.header = headerString;
        this.parse();
    }

    private void parse() {
        if (this.header == null) {
            return;
        }
        int i = this.header.indexOf(" ");
        if (i != -1) {
            this.authenticationScheme = this.header.substring(0, i);
        } else {
            i = 0;
        }
        String paramString = this.header.substring(i).trim();
        String[] stringArray = paramString.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] p = s.split("=");
            if (p.length > 1) {
                String key = p[0].trim();
                String value = p[1].trim();
                if (value.startsWith("\"")) {
                    value = value.endsWith("\"") ? (value.length() > 2 ? value.substring(1, value.length() - 1) : "") : value.substring(1);
                }
                int k = 2;
                while (k < p.length) {
                    value = p[k].endsWith("\"") ? String.valueOf(value) + "=" + p[k].substring(0, p[k].length() - 1) : String.valueOf(value) + "=" + p[k];
                    ++k;
                }
                this.parameters.put(key, value);
            }
            ++n2;
        }
    }

    public String getScheme() {
        return this.authenticationScheme;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Collection<String> getParameters() {
        return this.parameters.keySet();
    }
}

