/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class OAuth {
    private static String encode(String decode) throws UnsupportedEncodingException {
        return URLEncoder.encode(decode, "UTF-8").replace("+", "%20");
    }

    public static String generateHeader(String surl, String httpMethod, OAuthMetadata md, Map<String, String> parameters) throws UnsupportedEncodingException {
        TreeMap<String, String> tmpParameters = new TreeMap<String, String>();
        String signature = "";
        String encodedSignature = "";
        HashMap<String, String> urlParamters = new HashMap<String, String>();
        if (surl.contains("?")) {
            String surlTemp = surl.substring(surl.indexOf("?") + 1);
            surl = surl.substring(0, surl.indexOf("?"));
            boolean bool = true;
            while (bool) {
                Object param;
                if (surlTemp.contains("&")) {
                    param = surlTemp.substring(0, surlTemp.indexOf("&"));
                    surlTemp = surlTemp.substring(surlTemp.indexOf("&") + 1);
                    urlParamters.put(((String)param).substring(0, ((String)param).indexOf("=")), ((String)param).substring(((String)param).indexOf("=") + 1));
                    continue;
                }
                param = surlTemp;
                urlParamters.put(((String)param).substring(0, ((String)param).indexOf("=")), ((String)param).substring(((String)param).indexOf("=") + 1));
                bool = false;
            }
        }
        TreeMap<String, String> map = new TreeMap<String, String>(md.getParameters());
        map.put("oauth_nonce", OAuth.generateNonce());
        map.put("oauth_timestamp", OAuth.timestamp());
        tmpParameters.putAll(map);
        tmpParameters.putAll(md.getParameters());
        tmpParameters.putAll(parameters);
        for (String key : tmpParameters.keySet()) {
            String value = (String)tmpParameters.get(key);
            if (value != null) {
                tmpParameters.put(key, OAuth.encode(value));
                continue;
            }
            tmpParameters.put(key, "");
        }
        String concatParameters = "";
        tmpParameters.putAll(urlParamters);
        int i = 0;
        for (String key : tmpParameters.keySet()) {
            String value = (String)tmpParameters.get(key);
            if (i++ > 0) {
                concatParameters = String.valueOf(concatParameters) + "&";
            }
            concatParameters = String.valueOf(concatParameters) + key + "=" + value;
        }
        String signature_base_string = String.valueOf(httpMethod) + "&" + OAuth.encode(surl) + "&" + OAuth.encode(concatParameters);
        String signKey = String.valueOf(OAuth.encode(md.consumerSecret)) + "&" + OAuth.encode(md.tokenSecret);
        byte[] result = OAuth.hashHmacSHA1(signKey, signature_base_string);
        signature = DatatypeConverter.printBase64Binary((byte[])result);
        encodedSignature = OAuth.encode(signature);
        String header = "OAuth ";
        map.put("oauth_signature", encodedSignature);
        i = 0;
        for (String paramName : map.keySet()) {
            String paramValue = (String)map.get(paramName);
            if (i++ > 0) {
                header = String.valueOf(header) + ", ";
            }
            header = String.valueOf(header) + paramName + "=\"" + paramValue + '\"';
        }
        return header;
    }

    public static String generateNonce() {
        Random gen = new Random(System.currentTimeMillis());
        StringBuilder nonceBuilder = new StringBuilder("");
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int baseLength = base.length();
        int i = 0;
        while (i < 32) {
            int position = gen.nextInt(baseLength);
            nonceBuilder.append(base.charAt(position));
            ++i;
        }
        return nonceBuilder.toString();
    }

    public static String timestamp() {
        Long time = System.currentTimeMillis();
        return String.valueOf(time / 1000L);
    }

    public static byte[] hashHmacSHA1(String signKey, String signature_base_string) {
        SecretKeySpec keySpec = new SecretKeySpec(signKey.getBytes(), "HmacSHA1");
        byte[] result = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            result = mac.doFinal(signature_base_string.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return result;
    }
}

