/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2TokenKey;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class OAuth2 {
    public static final String GRANT_STRING_REFRESH_TOKEN = "refresh_token";
    public static final String GRANT_STRING_4_3 = "password";
    public static final String GRANT_STRING_4_4 = "client_credentials";
    private static final Lock lock = new ReentrantLock();
    static Map<OAuth2TokenKey, Token> map = new HashMap<OAuth2TokenKey, Token>();

    private OAuth2() {
        throw new IllegalStateException("Utility class");
    }

    static Map<String, String> parseResponse(InputStream is) throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        JsonNode node = JsonNode.parse((InputStream)is, (String)"UTF-8");
        if (node.isObject()) {
            for (String key : node.keys()) {
                JsonNode o = node.get(key);
                if (!o.isString() && !o.isNumber()) continue;
                prop.put(key, o.getString());
            }
        }
        return prop;
    }

    public static String getAuthEndPointUrl(OAuth2Metadata md) throws MalformedURLException, UnsupportedEncodingException {
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("client_id", md.clientId);
        urlWrapper.parameters.put("redirect_uri", md.redirectEndpoint);
        if (md.scope != null) {
            urlWrapper.parameters.put("scope", md.scope);
        }
        urlWrapper.parameters.put("response_type", "code");
        return urlWrapper.getQuery(true, md.authEndpoint);
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, String> getToken(final OAuth2Metadata md, String grant_type) throws Exception {
        block56: {
            urlWrapper = new URLBuilder();
            sendClientAndSecretAsAuthenticationHeader = false;
            if (md.flowType != null && (md.flowType.equals("Resource Owner Password Credentials Grant") || md.flowType.equals("Client Credentials Grant"))) {
                if (md.clientCredentialPolicy == CredentialMode.PARAMETER_CLIENT_ID) {
                    if (md.clientId == null) {
                        throw new EngineExceptionI("Error while building OAuth2 request: Client Id must not be null when it is required to send Client Id");
                    }
                    urlWrapper.parameters.put("client_id", md.clientId);
                } else if (md.clientCredentialPolicy == CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET) {
                    if (md.clientId == null) {
                        throw new EngineExceptionI("Error while building OAuth2 request: Client Id must not be null when it is required to send Client Id");
                    }
                    urlWrapper.parameters.put("client_id", md.clientId);
                    if (md.clientSecret == null) {
                        throw new EngineExceptionI("Error while building OAuth2 request: Client Secret must not be null when it is required to send Client Secret");
                    }
                    urlWrapper.parameters.put("client_secret", md.clientSecret);
                } else if (md.clientCredentialPolicy == CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET) {
                    sendClientAndSecretAsAuthenticationHeader = true;
                }
            } else {
                if (md.clientSecret != null) {
                    urlWrapper.parameters.put("client_secret", md.clientSecret);
                }
                if (md.clientId != null) {
                    urlWrapper.parameters.put("client_id", md.clientId);
                }
            }
            if (md.state != null) {
                urlWrapper.parameters.put("state", md.state);
            }
            if (!(md.scope == null || md.flowType == null || md.flowType.equals("Authorization Code Grant") && "refresh_token".equals(grant_type))) {
                urlWrapper.parameters.put("scope", md.scope);
            }
            if (md.refreshToken != null) {
                urlWrapper.parameters.put("refresh_token", md.refreshToken);
            }
            if (md.redirectEndpoint != null) {
                urlWrapper.parameters.put("redirect_uri", md.redirectEndpoint);
            }
            if (md.login != null) {
                urlWrapper.parameters.put("username", md.login);
            }
            if (md.password != null) {
                if (md.securityToken != null && !md.password.contains(md.securityToken)) {
                    urlWrapper.parameters.put("password", String.valueOf(md.password) + md.securityToken);
                } else {
                    urlWrapper.parameters.put("password", md.password);
                }
            }
            if (md.additionnalParameters != null) {
                urlWrapper.parameters.putAll(md.additionnalParameters);
            }
            urlWrapper.parameters.put("grant_type", grant_type);
            query2 = urlWrapper.getQuery(true, null);
            if (sendClientAndSecretAsAuthenticationHeader) {
                if (md.clientId == null) {
                    throw new EngineExceptionI("Error while building OAuth2 request: Client Id must not be null when it is required to send Client Id");
                }
                if (md.clientSecret == null) {
                    throw new EngineExceptionI("Error while building OAuth2 request: Client Secret must not be null when it is required to send Client Secret");
                }
            }
            oldProperty = null;
            try {
                OAuth2.lock.lock();
                oldProperty = System.getProperty("jdk.http.auth.tunneling.disabledSchemes");
                if (md.tokenEndpointHttpMethod != null && md.tokenEndpointHttpMethod.equals("GET")) {
                    url = new URL(String.valueOf(md.tokenEndpoint) + "?" + query2);
                    if (md.getProxy() != null) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            public PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(md.proxyUser, md.proxyPassword.toCharArray());
                            }
                        });
                        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                        conn = (HttpURLConnection)url.openConnection(md.getProxy());
                        OAuth2.setProxyHeader(conn, md.proxyUser, md.proxyPassword);
                    } else {
                        conn = (HttpURLConnection)url.openConnection();
                    }
                    if (conn instanceof HttpsURLConnection) {
                        if (md.enableCertificateVerification != null && !md.enableCertificateVerification.booleanValue()) {
                            OAuth2.disableCertificateVerification((HttpsURLConnection)conn);
                        }
                        if (md.enableHostnameVerification != null && !md.enableHostnameVerification.booleanValue()) {
                            OAuth2.disableHostnameVerification((HttpsURLConnection)conn);
                        }
                    }
                    if (sendClientAndSecretAsAuthenticationHeader) {
                        b = new BasicAuthentication(md.clientId, md.clientSecret);
                        conn.setRequestProperty("Authorization", b.getAuthenticationHeaderValue(null));
                    }
                    if (md.connectionTimeout > -1) {
                        conn.setConnectTimeout(md.connectionTimeout);
                    }
                    if (md.additionnalHttpHeaders != null) {
                        for (Map.Entry<String, String> entry : md.additionnalHttpHeaders.entrySet()) {
                            conn.setRequestProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setRequestMethod("GET");
                } else {
                    url = new URL(md.tokenEndpoint);
                    if (md.getProxy() != null) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            public PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(md.proxyUser, md.proxyPassword.toCharArray());
                            }
                        });
                        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                        conn = (HttpURLConnection)url.openConnection(md.getProxy());
                        OAuth2.setProxyHeader(conn, md.proxyUser, md.proxyPassword);
                    } else {
                        conn = (HttpURLConnection)url.openConnection();
                    }
                    if (conn instanceof HttpsURLConnection) {
                        if (md.enableCertificateVerification != null && !md.enableCertificateVerification.booleanValue()) {
                            OAuth2.disableCertificateVerification((HttpsURLConnection)conn);
                        }
                        if (md.enableHostnameVerification != null && !md.enableHostnameVerification.booleanValue()) {
                            OAuth2.disableHostnameVerification((HttpsURLConnection)conn);
                        }
                    }
                    if (sendClientAndSecretAsAuthenticationHeader) {
                        b = new BasicAuthentication(md.clientId, md.clientSecret);
                        conn.setRequestProperty("Authorization", b.getAuthenticationHeaderValue(null));
                    }
                    if (md.connectionTimeout > -1) {
                        conn.setConnectTimeout(md.connectionTimeout);
                    }
                    if (md.additionnalHttpHeaders != null) {
                        for (Map.Entry<String, String> entry : md.additionnalHttpHeaders.entrySet()) {
                            conn.setRequestProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestMethod("POST");
                    osw = new OutputStreamWriter(conn.getOutputStream());
                    osw.write(query2);
                    osw.close();
                }
            }
            finally {
                if (md.getProxy() != null) {
                    Authenticator.setDefault(null);
                }
                if (oldProperty != null) {
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", oldProperty);
                }
                OAuth2.lock.unlock();
            }
            ret = null;
            try {
                try {
                    ret = OAuth2.parseResponse(conn.getInputStream());
                    break block56;
                }
                catch (IOException e) {
                    isr = new InputStreamReader(conn.getErrorStream());
                    in = new BufferedReader(isr);
                    line = null;
                    sb = new StringBuilder();
                    ** while ((line = in.readLine()) != null)
                }
lbl-1000:
                // 1 sources

                {
                    System.out.println(line);
                    sb.append(line);
                    continue;
                }
lbl148:
                // 1 sources

                output = sb.toString();
                throw new Exception("An error occured while generating OAuth2 token. " + output, e);
            }
            finally {
                conn.disconnect();
            }
        }
        return ret;
    }

    private static void disableHostnameVerification(HttpsURLConnection conn) {
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    private static void disableCertificateVerification(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustMgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustMgr}, null);
        conn.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    public static Map<String, String> getNewToken(OAuth2Metadata md) throws Exception {
        HttpURLConnection conn;
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("code", md.code);
        if (md.clientSecret != null) {
            urlWrapper.parameters.put("client_secret", md.clientSecret);
        }
        urlWrapper.parameters.put("client_id", md.clientId);
        urlWrapper.parameters.put("redirect_uri", md.redirectEndpoint);
        urlWrapper.parameters.put("grant_type", "authorization_code");
        String query2 = urlWrapper.getQuery(true, null);
        URL url = new URL(md.tokenEndpoint);
        if (md.getProxy() != null) {
            conn = (HttpURLConnection)url.openConnection(md.getProxy());
            OAuth2.setProxyHeader(conn, md.proxyUser, md.proxyPassword);
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        if (md.connectionTimeout > -1) {
            conn.setConnectTimeout(md.connectionTimeout);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestMethod("POST");
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
        osw.write(query2);
        osw.close();
        return OAuth2.parseResponse(conn.getInputStream());
    }

    public static void addAccessToken(HttpURLConnection conn, String tokenType, String accessToken) throws Exception {
        conn.setRequestProperty("Authorization", String.valueOf(tokenType) + " " + accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(OAuth2Metadata _new) throws IOException, Exception {
        if (_new.flowType == null ? _new.refreshToken == null : _new.flowType.equals("Authorization Code Grant") && _new.refreshToken == null || _new.flowType.equals("Implicit Grant")) {
            return _new.accessToken;
        }
        Map<OAuth2TokenKey, Token> map = OAuth2.map;
        synchronized (map) {
            long currentTime;
            OAuth2TokenKey tokenKey = new OAuth2TokenKey(_new);
            OAuth2Metadata.Logger logger = _new.getLogger();
            Token token = OAuth2.map.get(tokenKey);
            if (token == null) {
                token = new Token();
                OAuth2.map.put(tokenKey, token);
            }
            if (token.expireTime < (currentTime = System.currentTimeMillis())) {
                String accessToken;
                if (logger != null) {
                    logger.debug("OAuth2, getting token: " + _new.toString());
                }
                Map<String, String> ret = null;
                int i = 0;
                do {
                    try {
                        if (_new.flowType == null || _new.flowType.equals("Authorization Code Grant") || _new.flowType.equals("Implicit Grant")) {
                            ret = OAuth2.getToken(_new, GRANT_STRING_REFRESH_TOKEN);
                            continue;
                        }
                        if (_new.flowType.equals("Resource Owner Password Credentials Grant")) {
                            ret = OAuth2.getToken(_new, GRANT_STRING_4_3);
                            continue;
                        }
                        if (_new.flowType.equals("Client Credentials Grant")) {
                            ret = OAuth2.getToken(_new, GRANT_STRING_4_4);
                            continue;
                        }
                        throw new RuntimeException("Could not find a suitable token grant flow.");
                    }
                    catch (Exception e) {
                        ++i;
                        if (logger != null) {
                            logger.warn("OAuth2 token, Error during: " + i + " attempt number", e);
                        }
                        if (i < _new.numberOfAttempts) continue;
                        if (logger != null) {
                            logger.warn("OAuth2 token, too much attempts: " + i);
                        }
                        throw e;
                    }
                } while (ret == null);
                token.accessToken = accessToken = ret.get("access_token");
                if (_new.expiresIn > 0L) {
                    token.expireTime = currentTime + _new.expiresIn * 1000L;
                } else {
                    String str = ret.get("expires_in");
                    if (str != null) {
                        try {
                            token.expireTime = currentTime + Long.parseLong(str) * 1000L;
                        }
                        catch (NumberFormatException e) {
                            token.expireTime = currentTime;
                        }
                    } else {
                        token.expireTime = currentTime;
                    }
                }
                return token.accessToken;
            }
            return token.accessToken;
        }
    }

    public static void setProxyHeader(URLConnection conn, String proxyUser, String proxyPassword) {
        if (proxyUser != null && proxyPassword != null) {
            String encoded = DatatypeConverter.printBase64Binary((byte[])new String(String.valueOf(proxyUser) + ":" + proxyPassword).getBytes());
            conn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
    }

    public static enum CredentialMode {
        NONE("None"),
        PARAMETER_CLIENT_ID("Send Client Id as parameter"),
        PARAMETER_CLIENT_ID_AND_SECRET("Send Client Id and Client Secret as parameters"),
        AUTH_HEADER_CLIENT_ID_AND_SECRET("Send Client Id and Client Secret as Basic Auth header");

        String label;

        private CredentialMode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static CredentialMode fromLabel(String label) {
            CredentialMode[] credentialModeArray = CredentialMode.values();
            int n = credentialModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CredentialMode m = credentialModeArray[n2];
                if (m.getLabel().equals(label)) {
                    return m;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class Token {
        String accessToken;
        long expireTime;

        private Token() {
        }
    }

    private static class URLBuilder {
        Map<String, String> parameters = new HashMap<String, String>();

        private URLBuilder() {
        }

        String getQuery(boolean encode, String url) throws MalformedURLException, UnsupportedEncodingException {
            int i = 0;
            String _url = "";
            if (url != null) {
                _url = url;
            }
            for (String key : this.parameters.keySet()) {
                if (i != 0 || !_url.isEmpty()) {
                    _url = i == 0 ? String.valueOf(_url) + "?" : String.valueOf(_url) + "&";
                }
                _url = String.valueOf(_url) + key + "=";
                _url = encode ? String.valueOf(_url) + URLEncoder.encode(this.parameters.get(key), "UTF-8") : String.valueOf(_url) + this.parameters.get(key);
                ++i;
            }
            return _url;
        }
    }
}

