/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class OAuth2TokenKey {
    private final String state;
    private final String login;
    private final String password;
    private final String securityToken;
    private final String flowType;
    private final String refreshToken;
    private final String clientSecret;
    private final String clientId;
    private final Map<String, String> additionnalParameters;
    private final Map<String, String> additionnalHttpHeaders;
    private final OAuth2.CredentialMode clientCredentialPolicy;
    private final String tokenEndpoint;
    private final String tokenEndpointHttpMethod;
    private final String scope;
    private final String authEndpoint;
    private final String redirectEndpoint;
    private final String code;
    private final int numberOfAttempts;
    private final int connectionTimeout;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPassword;
    private final Boolean enableHostnameVerification;
    private final Boolean enableCertificateVerification;

    public OAuth2TokenKey(OAuth2Metadata oAuth2Metadata) {
        this.state = oAuth2Metadata.state;
        this.login = oAuth2Metadata.login;
        this.password = oAuth2Metadata.password;
        this.securityToken = oAuth2Metadata.securityToken;
        this.flowType = oAuth2Metadata.flowType;
        this.refreshToken = oAuth2Metadata.refreshToken;
        this.clientSecret = oAuth2Metadata.clientSecret;
        this.clientId = oAuth2Metadata.clientId;
        this.additionnalParameters = oAuth2Metadata.additionnalParameters;
        this.additionnalHttpHeaders = oAuth2Metadata.additionnalHttpHeaders;
        this.clientCredentialPolicy = oAuth2Metadata.clientCredentialPolicy;
        this.tokenEndpoint = oAuth2Metadata.tokenEndpoint;
        this.tokenEndpointHttpMethod = oAuth2Metadata.tokenEndpointHttpMethod;
        this.scope = oAuth2Metadata.scope;
        this.authEndpoint = oAuth2Metadata.authEndpoint;
        this.redirectEndpoint = oAuth2Metadata.redirectEndpoint;
        this.code = oAuth2Metadata.code;
        this.numberOfAttempts = oAuth2Metadata.numberOfAttempts;
        this.connectionTimeout = oAuth2Metadata.connectionTimeout;
        this.proxyHost = oAuth2Metadata.proxyHost;
        this.proxyPort = oAuth2Metadata.proxyPort;
        this.proxyUser = oAuth2Metadata.proxyUser;
        this.proxyPassword = oAuth2Metadata.proxyPassword;
        this.enableHostnameVerification = oAuth2Metadata.enableHostnameVerification;
        this.enableCertificateVerification = oAuth2Metadata.enableCertificateVerification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hashCode(this.additionnalHttpHeaders), this.hashCode(this.additionnalParameters), this.authEndpoint, this.clientCredentialPolicy, this.clientId, this.clientSecret, this.code, this.connectionTimeout, this.enableCertificateVerification, this.enableHostnameVerification, this.flowType, this.login, this.numberOfAttempts, this.password, this.proxyHost, this.proxyPassword, this.proxyPort, this.proxyUser, this.redirectEndpoint, this.refreshToken, this.scope, this.securityToken, this.state, this.tokenEndpoint, this.tokenEndpointHttpMethod});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2TokenKey other = (OAuth2TokenKey)obj;
        return Objects.equals(this.hashCode(this.additionnalHttpHeaders), this.hashCode(other.additionnalHttpHeaders)) && Objects.equals(this.hashCode(this.additionnalParameters), this.hashCode(other.additionnalParameters)) && Objects.equals(this.authEndpoint, other.authEndpoint) && this.clientCredentialPolicy == other.clientCredentialPolicy && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.code, other.code) && this.connectionTimeout == other.connectionTimeout && Objects.equals(this.enableCertificateVerification, other.enableCertificateVerification) && Objects.equals(this.enableHostnameVerification, other.enableHostnameVerification) && Objects.equals(this.flowType, other.flowType) && Objects.equals(this.login, other.login) && this.numberOfAttempts == other.numberOfAttempts && Objects.equals(this.password, other.password) && Objects.equals(this.proxyHost, other.proxyHost) && Objects.equals(this.proxyPassword, other.proxyPassword) && this.proxyPort == other.proxyPort && Objects.equals(this.proxyUser, other.proxyUser) && Objects.equals(this.redirectEndpoint, other.redirectEndpoint) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.scope, other.scope) && Objects.equals(this.securityToken, other.securityToken) && Objects.equals(this.state, other.state) && Objects.equals(this.tokenEndpoint, other.tokenEndpoint) && Objects.equals(this.tokenEndpointHttpMethod, other.tokenEndpointHttpMethod);
    }

    private int hashCode(Map<String, String> map) {
        if (map != null && map.entrySet() != null) {
            return Arrays.hashCode(map.entrySet().stream().sorted((e1, e2) -> this.format((Map.Entry<String, String>)e1).compareTo(this.format((Map.Entry<String, String>)e2))).map(o -> Objects.hash(o.getKey(), o.getValue())).toArray());
        }
        return 0;
    }

    private String format(Map.Entry<String, String> entry) {
        return String.format("%s:%s", entry.getKey(), entry.getValue());
    }
}

