/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.composite;

import com.indy.quartz.cron.editor.composite.CronUnitConstante;
import com.indy.quartz.cron.editor.composite.Messages;
import com.indy.ui.utils.FormMessageWrapper;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.Month;
import com.stambia.quartz.cron.MonthCronTypeMode;
import com.stambia.ui.tools.binding.BindingEnumeration;
import com.stambia.ui.tools.binding.BindingRadioButtons;
import com.stambia.ui.tools.binding.BindingText;
import com.stambia.ui.tools.binding.BindingUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MonthCronComposite {
    private FormToolkit toolkit;
    private EObject cronEObject;
    private EditingDomain domain;
    private StackLayout detailsStackLayout;
    private Composite masterComposite;
    private SashForm sashForm;
    private Composite details;
    private Composite everyComposite;
    private Control selectedComposite;
    private BindingRadioButtons modeBinding;
    private DataBindingContext ctx;
    private FormMessageWrapper mmng;
    private BindingText everyBindedText;
    private BindingEnumeration monthBinding;

    public MonthCronComposite(Composite parent, FormToolkit toolkit, EObject cronEObject, EditingDomain domain, DataBindingContext ctx, FormMessageWrapper mmng) {
        this.toolkit = toolkit;
        this.cronEObject = cronEObject;
        this.domain = domain;
        this.ctx = ctx;
        this.mmng = mmng;
        this.detailsStackLayout = new StackLayout();
        this.createMasterSection(parent);
    }

    public Composite getComposite() {
        return this.masterComposite;
    }

    private void createMasterSection(Composite parent) {
        this.masterComposite = this.toolkit.createComposite(parent);
        this.masterComposite.setLayout((Layout)new GridLayout());
        this.masterComposite.setLayoutData((Object)new GridData());
        this.sashForm = new SashForm(this.masterComposite, 256);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createModeComposite((Composite)this.sashForm);
        this.details = this.toolkit.createComposite((Composite)this.sashForm);
        this.details.setLayout((Layout)this.detailsStackLayout);
        this.details.setLayoutData((Object)new GridData());
        this.sashForm.setWeights(new int[]{1, 2});
        this.everyComposite = this.createEveryComposite(this.details);
        this.selectedComposite = this.createSelectedComposite(this.details);
        this.bind();
    }

    public void bind() {
        this.everyBindedText.bind(this.cronEObject);
        this.monthBinding.setEObject(this.cronEObject);
        this.modeBinding.setEObject(this.cronEObject);
    }

    private Composite createModeComposite(Composite parent) {
        Composite modeComposite = this.toolkit.createComposite(parent);
        modeComposite.setLayout((Layout)new GridLayout());
        modeComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.modeBinding = new BindingRadioButtons(modeComposite, this.toolkit, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Mode(), this.domain);
        this.modeBinding.addRadioButton(Messages.MonthCronComposite_0, (Enumerator)MonthCronTypeMode.EVERY_MONTH).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((MonthCronComposite)MonthCronComposite.this).detailsStackLayout.topControl = MonthCronComposite.this.everyComposite;
                MonthCronComposite.this.details.layout();
            }
        });
        this.modeBinding.addRadioButton(Messages.MonthCronComposite_1, (Enumerator)MonthCronTypeMode.SELECTED_MONTH).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((MonthCronComposite)MonthCronComposite.this).detailsStackLayout.topControl = MonthCronComposite.this.selectedComposite;
                MonthCronComposite.this.details.layout();
            }
        });
        return modeComposite;
    }

    private void createEverylabel(Composite parent) {
        this.toolkit.createLabel(parent, Messages.MonthCronComposite_2, 0);
        Text text = this.toolkit.createText(parent, "");
        text.setLayoutData((Object)new GridData(40, -1));
        this.everyBindedText = new BindingText(this.ctx, text, this.cronEObject, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Every(), this.domain, (IConverter)new BindingUtils.StringToNumberConverter(), (IConverter)new BindingUtils.NumberToStringConverter());
        this.createControleDecoration(MonthCronTypeMode.EVERY_MONTH, this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Every(), this.cronEObject, text);
    }

    private Composite createEveryComposite(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.createEverylabel(composite);
        return composite;
    }

    private Composite createSelectedComposite(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(3, true));
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.monthBinding = new BindingEnumeration(composite, this.toolkit, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Month(), this.domain);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_4, (Object)Month.JANUARY);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_5, (Object)Month.FEBRUARY);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_6, (Object)Month.MARCH);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_7, (Object)Month.APRIL);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_8, (Object)Month.MAY);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_9, (Object)Month.JUNE);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_10, (Object)Month.JULY);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_11, (Object)Month.AUGUST);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_12, (Object)Month.SEPTEMBER);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_13, (Object)Month.OCTOBER);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_14, (Object)Month.NOVEMBER);
        this.monthBinding.addBindedCheckButton(Messages.MonthCronComposite_15, (Object)Month.DECEMBER);
        IObservableValue modeObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Mode()).observe((Object)this.cronEObject);
        IObservableList checkedElements = this.monthBinding.getTargetObservableList();
        selectedMonthValidator valProvider = new selectedMonthValidator(modeObservable, checkedElements, Messages.MonthCronComposite_16, composite);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)131200, (Composite)composite);
        return composite;
    }

    public void createControleDecoration(MonthCronTypeMode mode, EditingDomain domain, EStructuralFeature feature, EObject cronEObject, Text text) {
        IObservableValue modeObservable = EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)CronPackage.eINSTANCE.getMonthCronType_Mode()).observe((Object)cronEObject);
        ISWTObservableValue everyTextObservable = WidgetProperties.text((int)24).observeDelayed(300, (Widget)text);
        monthModeValidator valProvider = new monthModeValidator(modeObservable, (IObservableValue)everyTextObservable, mode, feature.getName());
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)16512);
    }

    private class monthModeValidator
    extends MultiValidator {
        private final IObservableValue modeObservable;
        private final IObservableValue targetObservable;
        private final MonthCronTypeMode mode;
        private final String key;

        public monthModeValidator(IObservableValue modeObservable, IObservableValue targetObservable, MonthCronTypeMode mode, String key) {
            this.modeObservable = modeObservable;
            this.targetObservable = targetObservable;
            this.mode = mode;
            this.key = String.valueOf(CronUnitConstante.MONTH_LABEL) + "/" + mode.getName() + "/" + key;
        }

        protected IStatus validate() {
            String value = (String)this.targetObservable.getValue();
            if (this.modeObservable.getValue().equals(this.mode)) {
                if (this.mode.equals((Object)MonthCronTypeMode.EVERY_MONTH)) {
                    if (!value.isEmpty()) {
                        if (Integer.valueOf(value) >= 1 && Integer.valueOf(value) <= CronUnitConstante.MONTH_MAX) {
                            MonthCronComposite.this.mmng.removeMessage((Object)this.key);
                            return ValidationStatus.ok();
                        }
                        MonthCronComposite.this.mmng.addMessage((Object)this.key, "(" + CronUnitConstante.MONTH_LABEL + ") " + Messages.MonthCronComposite_21 + "1" + Messages.MonthCronComposite_23 + CronUnitConstante.MONTH_MAX + Messages.MonthCronComposite_24, null, 3);
                        return ValidationStatus.error((String)(String.valueOf(Messages.MonthCronComposite_25) + "1" + Messages.MonthCronComposite_27 + CronUnitConstante.MONTH_MAX + Messages.MonthCronComposite_28));
                    }
                    MonthCronComposite.this.mmng.removeMessage((Object)this.key);
                    return ValidationStatus.ok();
                }
                if (Integer.valueOf(value) >= CronUnitConstante.MONTH_MIN && Integer.valueOf(value) <= CronUnitConstante.MONTH_MAX) {
                    MonthCronComposite.this.mmng.removeMessage((Object)this.key);
                    return ValidationStatus.ok();
                }
                MonthCronComposite.this.mmng.addMessage((Object)this.key, "(" + CronUnitConstante.MONTH_LABEL + ") " + Messages.MonthCronComposite_31 + CronUnitConstante.MONTH_MIN + Messages.MonthCronComposite_32 + CronUnitConstante.MONTH_MAX + ".", null, 3);
                return ValidationStatus.error((String)(String.valueOf(Messages.MonthCronComposite_34) + CronUnitConstante.MONTH_MIN + Messages.MonthCronComposite_35 + CronUnitConstante.MONTH_MAX + "."));
            }
            MonthCronComposite.this.mmng.removeMessage((Object)this.key);
            return ValidationStatus.ok();
        }
    }

    private class selectedMonthValidator
    extends MultiValidator {
        private final IObservableValue modeObservable;
        private final IObservableList checkedElements;
        private final String key;
        private String message;
        private String errorMessage;
        private ControlDecoration controlDecoration;
        private FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");

        public selectedMonthValidator(IObservableValue modeObservable, IObservableList checkedElements, String key, Composite composite) {
            this.modeObservable = modeObservable;
            this.checkedElements = checkedElements;
            this.key = String.valueOf(CronUnitConstante.MONTH_LABEL) + "/" + MonthCronTypeMode.SELECTED_MONTH.getName() + "/" + key;
            this.message = "(" + CronUnitConstante.MONTH_LABEL + ") " + Messages.MonthCronComposite_41 + ".";
            this.errorMessage = Messages.MonthCronComposite_43;
            this.controlDecoration = new ControlDecoration((Control)composite, 16512);
            this.controlDecoration.setDescriptionText(this.errorMessage);
            this.controlDecoration.setImage(this.fieldDecoration.getImage());
            this.controlDecoration.setMarginWidth(-10);
        }

        protected IStatus validate() {
            if (this.modeObservable.getValue().equals(MonthCronTypeMode.SELECTED_MONTH) && this.checkedElements.isEmpty()) {
                MonthCronComposite.this.mmng.addMessage((Object)this.key, this.message, null, 3);
                this.controlDecoration.show();
                return ValidationStatus.error((String)this.errorMessage);
            }
            MonthCronComposite.this.mmng.removeMessage((Object)this.key);
            this.controlDecoration.hide();
            return ValidationStatus.ok();
        }
    }
}

