/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.composite;

import com.ibm.icu.text.NumberFormat;
import com.indy.quartz.cron.editor.composite.Messages;
import com.indy.ui.utils.FormMessageWrapper;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.RuntimeParameter;
import com.stambia.ui.tools.binding.BindingText;
import java.text.ParsePosition;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RuntimeParameterComposite
extends Composite {
    private DataBindingContext ctx;
    private RuntimeParameter runtimeParameter;
    private EditingDomain domain;
    private FormToolkit toolkit;
    private Text hostTxt;
    private Text portTxt;
    private String currentHost;
    private Integer currentPort;
    private FormMessageWrapper mmng;

    public RuntimeParameterComposite(Composite parent, DataBindingContext ctx, RuntimeParameter runtimeParameter, EditingDomain domain, FormToolkit toolkit, String currentHost, Integer currentPort, FormMessageWrapper mmng) {
        super(parent, 0);
        this.ctx = ctx;
        this.runtimeParameter = runtimeParameter;
        this.domain = domain;
        this.toolkit = toolkit;
        this.currentHost = currentHost;
        this.currentPort = currentPort;
        this.mmng = mmng;
        this.createComposite(parent);
    }

    private void createComposite(Composite parent) {
        GridDataFactory.fillDefaults().applyTo((Control)this);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this);
        Composite customRemoteComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().applyTo((Control)customRemoteComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(customRemoteComposite);
        Hyperlink customHost = this.toolkit.createHyperlink(customRemoteComposite, "Host: ", 0);
        customHost.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                RuntimeParameterComposite.this.hostTxt.setEnabled(!RuntimeParameterComposite.this.hostTxt.getEnabled());
            }
        });
        this.hostTxt = this.toolkit.createText(customRemoteComposite, "");
        this.hostTxt.setData("org.eclipse.rap.rwt.customVariant", (Object)"disableEmpty");
        this.hostTxt.setLayoutData((Object)new GridData(100, -1));
        new BindingText(this.ctx, this.hostTxt, (EObject)this.runtimeParameter, (EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Host(), this.domain);
        Hyperlink customPort = this.toolkit.createHyperlink(customRemoteComposite, "Port: ", 0);
        customPort.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                RuntimeParameterComposite.this.portTxt.setEnabled(!RuntimeParameterComposite.this.portTxt.getEnabled());
            }
        });
        this.portTxt = this.toolkit.createText(customRemoteComposite, "");
        this.portTxt.setData("org.eclipse.rap.rwt.customVariant", (Object)"disableEmpty");
        this.portTxt.setLayoutData((Object)new GridData(100, -1));
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.portTxt, 16512);
        controlDecoration.setDescriptionText(Messages.RuntimeParameterComposite_8);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        IObservableValue hostObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Host()).observe((Object)this.runtimeParameter);
        IObservableValue portObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Port()).observe((Object)this.runtimeParameter);
        PortValidator valProvider = new PortValidator(controlDecoration, hostObservable, portObservable);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)131200, (Composite)customRemoteComposite);
        EMFUpdateValueStrategy portTargetToModel = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value == null) {
                    RuntimeParameterComposite.this.domain.getCommandStack().execute((Command)new SetCommand(RuntimeParameterComposite.this.domain, (EObject)RuntimeParameterComposite.this.runtimeParameter, (EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Port(), SetCommand.UNSET_VALUE));
                    return Status.OK_STATUS;
                }
                IStatus status = super.doSet(observableValue, value);
                return status;
            }

            public Object convert(Object value) {
                if (value instanceof String) {
                    if (((String)value).isEmpty()) {
                        return 0;
                    }
                    if (!RuntimeParameterComposite.isNumeric((String)value)) {
                        return -1;
                    }
                }
                return super.convert(value);
            }
        };
        EMFUpdateValueStrategy portModelToTarget = new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value instanceof Integer && (Integer)value == 0) {
                    return "";
                }
                return String.valueOf(value);
            }
        };
        IWidgetValueProperty prop = WidgetProperties.text((int)24);
        this.ctx.bindValue((IObservableValue)prop.observeDelayed(300, (Widget)this.portTxt), EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Port()).observe((Object)this.runtimeParameter), (UpdateValueStrategy)portTargetToModel, (UpdateValueStrategy)portModelToTarget);
        if (this.runtimeParameter != null) {
            this.hostTxt.setEnabled(this.runtimeParameter.getHost() != null && !this.runtimeParameter.getHost().isEmpty());
            this.portTxt.setEnabled(this.runtimeParameter.getPort() != 0);
        }
    }

    public static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    public class PortValidator
    extends MultiValidator {
        private String key_invalid_port = "advanced_port_invalid";
        String message_invalid_port = Messages.RuntimeParameterComposite_11;
        private final IObservableValue hostObservable;
        private final IObservableValue portObservable;
        private final ControlDecoration controlDecoration;

        public PortValidator(ControlDecoration controlDecoration, IObservableValue hostObservable, IObservableValue portObservable) {
            this.hostObservable = hostObservable;
            this.portObservable = portObservable;
            this.controlDecoration = controlDecoration;
        }

        protected IStatus validate() {
            if (this.hostObservable.getValue() != null && !((String)this.hostObservable.getValue()).isEmpty() && this.portObservable.getValue() != null && (Integer)this.portObservable.getValue() == -1) {
                this.controlDecoration.setDescriptionText(this.message_invalid_port);
                this.controlDecoration.show();
                return ValidationStatus.error((String)this.message_invalid_port);
            }
            this.controlDecoration.hide();
            RuntimeParameterComposite.this.mmng.removeMessage((Object)this.key_invalid_port);
            return Status.OK_STATUS;
        }
    }
}

