/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.designer.wizard;

import com.indy.md.ui.editor.reverse.MdDiffBuilder;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.AzureBean;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.AzureWizardDiffPage;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.AzureWizardPage;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.AzureWizardTableSelectionPage;
import com.semarchy.xdi.component.azure.table.storage.designer.wizard.BeanMdLinker;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class AzureTableStorageWizard
extends MdWizard {
    private BeanMdLinker mdLinker;
    private AzureWizardDiffPage diffPage;
    private AzureWizardTableSelectionPage tableSelectionpage;

    public AzureTableStorageWizard(boolean isCreation) {
        super(isCreation);
    }

    public AzureTableStorageWizard() {
    }

    public void setNode(MdNode node) {
        super.setNode(node);
        this.mdLinker = new BeanMdLinker();
        this.mdLinker.setNode(node);
    }

    public boolean performFinish() {
        try {
            if (this.getContainer().getCurrentPage() instanceof AzureWizardDiffPage) {
                MdNode newNode = null;
                HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
                VisitHandler handler = new VisitHandler();
                handler.newToOldMap = reversedMap;
                MdDiffNodeUI.DiffState diffState = this.diffPage.getDiffNodeUI().computeDiffState((MdDiffNodeUI.IVisitorHandler)handler, Collections.emptyList());
                diffState.getResultingMdNode().setSubstituteContainer(null);
                newNode = diffState.getResultingMdNode();
                this.mdLinker.reverseFromMdNode(newNode, reversedMap);
            } else {
                this.mdLinker.updateMdNode();
            }
            return true;
        }
        catch (Exception ex) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.semarchy.xdi.component.azure.table.storage.designer", ex.getMessage(), (Throwable)ex), 3);
            return false;
        }
    }

    public void addPages() {
        IWizardContainer c;
        AzureBean bean = this.mdLinker.getBean();
        if (bean instanceof AzureBean) {
            this.addPage((IWizardPage)new AzureWizardPage(this.mdLinker));
            this.tableSelectionpage = new AzureWizardTableSelectionPage(this.mdLinker);
            this.addPage((IWizardPage)this.tableSelectionpage);
            this.diffPage = new AzureWizardDiffPage();
            this.addPage((IWizardPage)this.diffPage);
        }
        if ((c = this.getContainer()) instanceof WizardDialog) {
            ((WizardDialog)c).setMinimumPageSize(0, 300);
            ((WizardDialog)c).addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(final PageChangingEvent event) {
                    if (event.getTargetPage() == AzureTableStorageWizard.this.diffPage || event.getTargetPage() == AzureTableStorageWizard.this.tableSelectionpage) {
                        try {
                            AzureTableStorageWizard.this.getContainer().run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) {
                                    monitor.beginTask("reverse", -1);
                                    try {
                                        if (event.getTargetPage() == (this).AzureTableStorageWizard.this.diffPage) {
                                            AzureTableStorageWizard.this.runTablePropertiesReverse();
                                        } else {
                                            AzureTableStorageWizard.this.runTableReverse();
                                        }
                                    }
                                    catch (Exception ex) {
                                        StatusManager.getManager().handle((IStatus)new Status(4, "com.semarchy.xdi.component.azure.table.storage.designer", "", (Throwable)ex), 5);
                                        event.doit = false;
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.semarchy.xdi.component.azure.table.storage.designer", "", (Throwable)ex), 5);
                            event.doit = false;
                        }
                    }
                }
            });
        }
    }

    private MdDiffNode createDiffNode() {
        MdNode newNode = this.mdLinker.getNewNode();
        MdDiffNode diffNode = new MdDiffNode(null, this.isCreation() ? null : this.getNode(), newNode, Collections.emptySet(), false);
        HashMap<String, Object> strategyMap = new HashMap<String, Object>();
        strategyMap.put("com.stambia.azure.table.timestamp", IncrementalReverser.DefaulteverseMatchingStrategy.ByNaturalOrder);
        strategyMap.put("com.stambia.azure.table.partitionkey", IncrementalReverser.DefaulteverseMatchingStrategy.ByNaturalOrder);
        strategyMap.put("com.stambia.azure.table.rowkey", IncrementalReverser.DefaulteverseMatchingStrategy.ByNaturalOrder);
        strategyMap.put("com.stambia.azure.table.account", () -> (n1, n2) -> Objects.equals(n1.getDefType(), n2.getDefType()));
        MdDiffBuilder.buildTree((IncrementalReverser.DefaulteverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, (MdDiffNode)diffNode, Collections.emptySet(), Collections.emptySet(), strategyMap);
        return diffNode;
    }

    private void runTableReverse() {
        this.mdLinker.reverseTables();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AzureTableStorageWizard.this.tableSelectionpage.setInput(new ArrayList<String>(AzureTableStorageWizard.this.mdLinker.getBean().getTables().keySet()));
            }
        });
    }

    private void runTablePropertiesReverse() {
        this.mdLinker.reverseTableProperties();
        final MdDiffNode diffNode = this.createDiffNode();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AzureTableStorageWizard.this.diffPage.getDiffNodeUI().getViewerHelper().setInput((Object)new Object[]{diffNode});
            }
        });
    }

    private class VisitHandler
    implements MdDiffNodeUI.IVisitorHandler {
        Map<MdNode, MdNode> newToOldMap;

        private VisitHandler() {
        }

        public void handleVisited(MdDiffNode diff, MdNode createdNode) {
            MdNode n;
            MdNode mdNode = n = diff.getState() == MdDiffNode.State.NEW ? diff.getNewNode() : diff.getOldNode();
            if (n.getDefType().equals("com.stambia.azure.table.account")) {
                this.newToOldMap.put(createdNode, diff.getOldNode());
            }
        }
    }
}

