/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.services.IConfigurationAuthenticator;
import com.indy.ui.custom.out.services.IEngineConnection;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IRuntimeService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildMenuOperationDispatcher {
    private static final DocumentationHelper docHelper = new DocumentationHelper();

    public static boolean performOperation(OperationKey operation, Collection<URI> modelURI) {
        if (operation.runtimeConnectionRequired() && Boolean.TRUE.equals(E4InjectorHelper.consumeServiceWithResult(IEngineConnection.class, e -> e == null && !MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.BuildMenuOperationDispatcher_notConnectedToRuntimePopupTitle, (String)Messages.BuildMenuOperationDispatcher_notConnectedToRuntimePopupQuestion)))) {
            return false;
        }
        AtomicReference dir = new AtomicReference();
        if (operation == OperationKey.DOCUMENTATION) {
            Display.getDefault().syncExec(() -> {
                String string = docHelper.promptForDocumentationLocation(dir);
            });
        }
        boolean res = false;
        for (URI processURI : modelURI) {
            switch (operation) {
                case DELIVERY_TO_TEXT: {
                    ((IGenerationService)E4InjectorHelper.getService(IGenerationService.class)).convertDeliveryToText(processURI);
                    res = true;
                    break;
                }
                case DOCUMENTATION: {
                    if (dir.get() == null) break;
                    String modelName = processURI.trimFileExtension().toPlatformString(true);
                    ((IGenerationService)E4InjectorHelper.getService(IGenerationService.class)).buildDocumentation(processURI, (s, outputFolderName) -> BuildMenuOperationDispatcher.handleDocumentationGeneration(s, () -> modelName.substring(modelName.lastIndexOf("/") + 1), outputFolderName, (String)dir.get()));
                    res = true;
                    break;
                }
                case RUN_LAST: {
                    if (!((IConfigurationAuthenticator)E4InjectorHelper.getService(IConfigurationAuthenticator.class)).validateCurrentConfigurationCredentials(IConfigurationAuthenticator.Mode.GENERATION)) break;
                    EngineVariable.INSTANCE.setSessionId("-1");
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).runSessionLast(processURI, BuildMenuOperationDispatcher::setSessionId);
                    res = true;
                    break;
                }
                case RUN: {
                    if (!((IConfigurationAuthenticator)E4InjectorHelper.getService(IConfigurationAuthenticator.class)).validateCurrentConfigurationCredentials(IConfigurationAuthenticator.Mode.GENERATION)) break;
                    EngineVariable.INSTANCE.setSessionId("-1");
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).runSession(processURI, BuildMenuOperationDispatcher::setSessionId);
                    res = true;
                    break;
                }
                case DELIVERY: {
                    ((IGenerationService)E4InjectorHelper.getService(IGenerationService.class)).buildDelivery(processURI);
                    res = true;
                    break;
                }
                case PACKAGE: {
                    ((IGenerationService)E4InjectorHelper.getService(IGenerationService.class)).buildPackage(processURI, false);
                    res = true;
                    break;
                }
                case PACKAGE_WITH_DOC: {
                    ((IGenerationService)E4InjectorHelper.getService(IGenerationService.class)).buildPackage(processURI, true);
                    res = true;
                    break;
                }
                case PREPARE: {
                    EngineVariable.INSTANCE.setSessionId("-1");
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).prepareSession(processURI, BuildMenuOperationDispatcher::setSessionId);
                    res = true;
                    break;
                }
                case PREPARE_LAST: {
                    EngineVariable.INSTANCE.setSessionId("-1");
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).prepareSessionLast(processURI, BuildMenuOperationDispatcher::setSessionId);
                    res = true;
                    break;
                }
                case PUBLISH: {
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).publish(processURI, false);
                    res = true;
                    break;
                }
                case PUBLISH_WS: {
                    ((IRuntimeService)E4InjectorHelper.getService(IRuntimeService.class)).publish(processURI, true);
                    res = true;
                }
            }
        }
        return res;
    }

    private static void handleDocumentationGeneration(IStatus s, Supplier<String> processName, String generatedDocLocation, String targetDocLocationFolder) {
        Stream<Comparable<File>> stream;
        Object var7_12;
        if (!s.isOK()) {
            StatusManager.getManager().handle(s, 3);
            return;
        }
        Path src = Paths.get(generatedDocLocation.replace("\\", "/"), new String[0]);
        Path dest = Paths.get(targetDocLocationFolder, processName.get());
        try {
            Throwable throwable = null;
            var7_12 = null;
            try {
                stream = Files.walk(dest, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile);
                try {
                    stream.forEach(File::delete);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().error("Failed to delete folder " + dest, (Throwable)e);
        }
        try {
            Throwable e = null;
            var7_12 = null;
            try {
                stream = Files.walk(src, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]));
                try {
                    stream.forEach(source -> {
                        Path srcRelative = src.relativize((Path)source);
                        Path trg = dest.resolve(srcRelative);
                        try {
                            Files.createDirectories(trg.getParent(), new FileAttribute[0]);
                            Files.copy(source, trg, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            Activator.getDefault().getLog().error("Failed to copy documentation file", (Throwable)e);
                        }
                    });
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().error("Failed to generate documentation", (Throwable)e);
        }
        try {
            URL url = Paths.get(dest.toString(), "index.html").toUri().toURL();
            Display.getDefault().asyncExec(() -> docHelper.openWebBrowser(url));
        }
        catch (MalformedURLException e) {
            Activator.getDefault().getLog().error("Failed to generate documentation", (Throwable)e);
        }
    }

    private static void setSessionId(IStatus status, String sessionId) {
        if (status.isOK()) {
            EngineVariable.INSTANCE.setSessionId(sessionId);
        }
    }

    private static class DocumentationHelper {
        String lastDocumentainPath;

        private DocumentationHelper() {
        }

        String promptForDocumentationLocation(AtomicReference<String> dirRef) {
            DirectoryDialog dd = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            if (this.lastDocumentainPath != null) {
                dd.setFilterPath(this.lastDocumentainPath);
            }
            dirRef.set(dd.open());
            if (dirRef.get() != null) {
                this.lastDocumentainPath = dirRef.get();
            }
            return dirRef.get();
        }

        void openWebBrowser(URL url) {
            try {
                IWebBrowser wb = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(6, null, null, null);
                wb.openURL(url);
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().error("Failed to open documentation", (Throwable)e);
            }
        }
    }

    public static enum OperationKey {
        PREPARE(new String[]{"OpenPrepareProc", "PrepareProc", "prepareProcess", "delivery.prepareProcess"}, true, true),
        DELIVERY(new String[]{"delivery.procToDeliv"}, false, false),
        RUN(new String[]{"ExecuteProc", "OpenExecuteProc"}, true, true),
        OPEN(new String[]{"OpenProc"}, true, false),
        REBUILD_REF(new String[]{"RebuildRef"}, false, false),
        PACKAGE(new String[]{"package.full.create"}, false, false),
        PACKAGE_WITH_DOC(new String[]{"package.full.create.doc"}, false, false),
        DELIVERY_TO_TEXT(new String[]{"compare.delivery.to.text"}, false, false),
        PUBLISH(new String[]{"publication.publishDelivery"}, false, true),
        PUBLISH_WS(new String[]{"publication.publishAsAService"}, false, true),
        RUN_LAST(new String[]{"delivery.executeD"}, true, true),
        PREPARE_LAST(new String[]{"delivery.prepareD"}, true, true),
        DOCUMENTATION(new String[]{"documentation.procToHtml"}, false, false);

        String[] keys;
        boolean applyOpenProcessPolicy;
        boolean runtimeConnectionRequired;

        private OperationKey(String[] keys, boolean applyOpenProcessPolicy, boolean runtimeConnectionRequired) {
            this.keys = keys;
            this.applyOpenProcessPolicy = applyOpenProcessPolicy;
            this.runtimeConnectionRequired = runtimeConnectionRequired;
        }

        public boolean runtimeConnectionRequired() {
            return this.runtimeConnectionRequired;
        }

        public boolean applyOpenProcessPolicy() {
            return this.applyOpenProcessPolicy;
        }

        public static OperationKey of(String key) {
            return Arrays.stream(OperationKey.values()).filter(op -> Arrays.stream(op.keys).anyMatch(k -> k.equals(key))).findFirst().orElse(null);
        }
    }
}

