/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CustomControlDecoration {
    private static boolean MAC = Util.isMac();
    private Control control;
    private Composite composite;
    private Image image;
    private String descriptionTxt;
    private Image hoverContentImage;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private Hover hover;
    private Rectangle previousDecorationRectangle;
    private Rectangle decorationRectangle;
    private Control moveListeningTarget = null;
    private MouseTrackListener mouseTrackListener;
    private MouseMoveListener mouseMoveListener;
    private int position = 16384;

    public CustomControlDecoration(Control control, int position) {
        this.control = control;
        this.composite = control.getParent();
        this.position = position;
        this.addControlListeners();
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        if (this.hover != null) {
            this.hover.dispose();
            this.hover = null;
        }
        this.removeControlListeners();
        this.update();
        this.control = null;
    }

    private void removeControlListeners() {
        if (this.control != null) {
            this.control.removeDisposeListener(this.disposeListener);
        }
        if (this.composite != null) {
            this.composite.removePaintListener(this.paintListener);
            this.composite.removeMouseTrackListener(this.mouseTrackListener);
        }
    }

    private void addControlListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CustomControlDecoration.this.dispose();
            }
        };
        this.control.addDisposeListener(this.disposeListener);
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CustomControlDecoration.this.getImage() != null) {
                    int w = ((CustomControlDecoration)CustomControlDecoration.this).getImage().getImageData().width;
                    Control control = (Control)event.widget;
                    Rectangle rect = CustomControlDecoration.this.getDecorationRectangle(control);
                    event.gc.drawImage(CustomControlDecoration.this.getImage(), rect.x + rect.width - w, rect.y);
                }
            }
        };
        this.composite.addPaintListener(this.paintListener);
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (!CustomControlDecoration.this.decorationRectangle.contains(event.x, event.y)) {
                    CustomControlDecoration.this.hideHover();
                    ((Control)event.widget).removeMouseMoveListener(CustomControlDecoration.this.mouseMoveListener);
                    CustomControlDecoration.this.moveListeningTarget = null;
                }
            }
        };
        this.mouseTrackListener = new MouseTrackListener(){

            public void mouseExit(MouseEvent event) {
                Control target = (Control)event.widget;
                if (target == CustomControlDecoration.this.moveListeningTarget) {
                    target.removeMouseMoveListener(CustomControlDecoration.this.mouseMoveListener);
                    CustomControlDecoration.this.moveListeningTarget = null;
                }
                CustomControlDecoration.this.hideHover();
            }

            public void mouseHover(MouseEvent event) {
                CustomControlDecoration.this.decorationRectangle = CustomControlDecoration.this.getDecorationRectangle((Control)event.widget);
                if (CustomControlDecoration.this.decorationRectangle.contains(event.x, event.y)) {
                    CustomControlDecoration.this.showHoverText(CustomControlDecoration.this.getDescriptionText(), CustomControlDecoration.this.control);
                    Control target = (Control)event.widget;
                    if (CustomControlDecoration.this.moveListeningTarget == null) {
                        target.addMouseMoveListener(CustomControlDecoration.this.mouseMoveListener);
                        CustomControlDecoration.this.moveListeningTarget = target;
                    } else if (target != CustomControlDecoration.this.moveListeningTarget) {
                        CustomControlDecoration.this.moveListeningTarget.removeMouseMoveListener(CustomControlDecoration.this.mouseMoveListener);
                        target.addMouseMoveListener(CustomControlDecoration.this.mouseMoveListener);
                        CustomControlDecoration.this.moveListeningTarget = target;
                    }
                }
            }

            public void mouseEnter(MouseEvent event) {
            }
        };
        this.composite.addMouseTrackListener(this.mouseTrackListener);
    }

    public void hideHover() {
        if (this.hover != null) {
            this.hover.setVisible(false);
        }
    }

    private void showHoverText(String text, Control hoverNear) {
        if (this.control.isDisposed() || !this.control.isVisible()) {
            return;
        }
        if (text == null || text.length() == 0) {
            this.hideHover();
            return;
        }
        if (this.hover == null) {
            this.hover = new Hover(hoverNear.getShell());
        }
        this.hover.setText(text, this.getDecorationRectangle((Control)this.control.getParent()), this.control);
        this.hover.setVisible(true);
    }

    protected void update() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        Rectangle rect = this.getDecorationRectangle((Control)this.control.getShell());
        if (this.previousDecorationRectangle != null) {
            rect = rect.union(this.previousDecorationRectangle);
        }
        this.control.getShell().redraw(rect.x, rect.y, rect.width, rect.height, true);
        this.control.getShell().update();
        if (this.hover != null && this.getDescriptionText() != null) {
            this.hover.setText(this.getDescriptionText(), this.getDecorationRectangle((Control)this.control.getParent()), this.control);
        }
        this.previousDecorationRectangle = null;
    }

    private String getDescriptionText() {
        return this.descriptionTxt;
    }

    protected Rectangle getDecorationRectangle(Control targetControl) {
        if (this.getImage() == null || this.control == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle imageBounds = this.getImage().getBounds();
        Rectangle controlBounds = this.control.getBounds();
        int x = (this.position & 0x20000) == 131072 ? controlBounds.x + controlBounds.width : controlBounds.x - imageBounds.width + 1;
        int y = (this.position & 0x80) == 128 ? controlBounds.y : ((this.position & 0x400) == 1024 ? controlBounds.y + this.control.getBounds().height - imageBounds.height : controlBounds.y + (this.control.getBounds().height - imageBounds.height) / 2);
        Point globalPoint = this.control.getParent().toDisplay(x, y);
        Point targetPoint = targetControl == null ? globalPoint : targetControl.toControl(globalPoint);
        return new Rectangle(targetPoint.x, targetPoint.y, imageBounds.width, imageBounds.height);
    }

    private Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.update();
    }

    public void setHoverImage(Image image) {
        this.hoverContentImage = image;
    }

    public void setDescriptionText(String descriptionTxt) {
        this.descriptionTxt = descriptionTxt;
    }

    class Hover {
        private static final String EMPTY = "";
        private int hao = 10;
        private int haw = 8;
        private int hah = 10;
        private int hm = 2;
        Shell hoverShell;
        String text = "";
        Region region;
        boolean arrowOnLeft = true;

        Hover(Shell parent) {
            Display display = parent.getDisplay();
            this.hoverShell = new Shell(parent, 540684);
            this.hoverShell.setBackground(display.getSystemColor(29));
            this.hoverShell.setForeground(display.getSystemColor(28));
            this.hoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    int offset = 0;
                    if (CustomControlDecoration.this.hoverContentImage != null) {
                        pe.gc.drawImage(CustomControlDecoration.this.hoverContentImage, Hover.this.hm, Hover.this.hm);
                        offset = ((CustomControlDecoration)((Hover)Hover.this).CustomControlDecoration.this).hoverContentImage.getBounds().width;
                    }
                    pe.gc.drawText(Hover.this.text, Hover.this.hm + offset, Hover.this.hm);
                    if (!MAC) {
                        pe.gc.drawPolygon(Hover.this.getPolygon(true));
                    }
                }
            });
            this.hoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                }
            });
        }

        int[] getPolygon(boolean border) {
            int b;
            Point e = this.getExtent();
            int n = b = border ? 1 : 0;
            if (this.arrowOnLeft) {
                int[] nArray = new int[16];
                nArray[2] = e.x - b;
                nArray[4] = e.x - b;
                nArray[5] = e.y - b;
                nArray[6] = this.hao + this.haw;
                nArray[7] = e.y - b;
                nArray[8] = this.hao + this.haw / 2;
                nArray[9] = e.y + this.hah - b;
                nArray[10] = this.hao;
                nArray[11] = e.y - b;
                nArray[13] = e.y - b;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = e.x - b;
            nArray[4] = e.x - b;
            nArray[5] = e.y - b;
            nArray[6] = e.x - this.hao - b;
            nArray[7] = e.y - b;
            nArray[8] = e.x - this.hao - this.haw / 2;
            nArray[9] = e.y + this.hah - b;
            nArray[10] = e.x - this.hao - this.haw;
            nArray[11] = e.y - b;
            nArray[13] = e.y - b;
            return nArray;
        }

        void dispose() {
            if (!this.hoverShell.isDisposed()) {
                this.hoverShell.dispose();
            }
            if (this.region != null) {
                this.region.dispose();
            }
        }

        void setVisible(boolean visible) {
            if (visible) {
                if (!this.hoverShell.isVisible()) {
                    this.hoverShell.setVisible(true);
                }
            } else if (this.hoverShell.isVisible()) {
                this.hoverShell.setVisible(false);
            }
        }

        void setText(String t, Rectangle decorationRectangle, Control targetControl) {
            if (t == null) {
                t = EMPTY;
            }
            if (!t.equals(this.text)) {
                Point oldSize = this.getExtent();
                this.text = t;
                this.hoverShell.redraw();
                Point newSize = this.getExtent();
                if (!oldSize.equals((Object)newSize)) {
                    this.arrowOnLeft = decorationRectangle.x <= targetControl.getLocation().x;
                    this.setNewShape();
                }
            }
            Point extent = this.getExtent();
            int y = -extent.y - this.hah + 1;
            int x = this.arrowOnLeft ? -this.hao + this.haw / 2 : -extent.x + this.hao + this.haw / 2;
            this.hoverShell.setLocation(CustomControlDecoration.this.control.getParent().toDisplay(decorationRectangle.x + x, decorationRectangle.y + y));
        }

        boolean isVisible() {
            return this.hoverShell.isVisible();
        }

        Point getExtent() {
            GC gc = new GC((Drawable)this.hoverShell);
            Point e = gc.textExtent(this.text);
            gc.dispose();
            if (CustomControlDecoration.this.hoverContentImage != null) {
                e.x += ((CustomControlDecoration)CustomControlDecoration.this).hoverContentImage.getBounds().width;
            }
            e.x += this.hm * 2;
            e.y += this.hm * 2;
            return e;
        }

        void setNewShape() {
            Region oldRegion = this.region;
            this.region = new Region();
            this.region.add(this.getPolygon(false));
            this.hoverShell.setRegion(this.region);
            if (oldRegion != null) {
                oldRegion.dispose();
            }
        }
    }
}

