/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class StyledTextLocationManager {
    private WeakReference<StyledText> controlRef;
    private Listener styledTextListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3 && event.button != 1) {
                return;
            }
            StyledTextLocationManager.this.updateInfo();
        }
    };
    private Map<Object, Info> memory = new WeakHashMap<Object, Info>();
    private WeakReference<Object> context = null;
    private IEditorPart currentEditor = null;
    private Map<IEditorPart, Set<Object>> editorContexts = new HashMap<IEditorPart, Set<Object>>();
    private IPartListener editorsListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                Set c;
                if (StyledTextLocationManager.this.currentEditor == part) {
                    StyledTextLocationManager.this.currentEditor = null;
                }
                if ((c = (Set)StyledTextLocationManager.this.editorContexts.remove(part)) != null) {
                    for (Object k : c) {
                        StyledTextLocationManager.this.memory.remove(k);
                    }
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                StyledTextLocationManager.this.currentEditor = (IEditorPart)part;
            }
        }
    };

    public void enable(StyledText widget) {
        if (widget.getVerticalBar() != null) {
            widget.getVerticalBar().addListener(13, this.styledTextListener);
        }
        if (widget.getHorizontalBar() != null) {
            widget.getHorizontalBar().addListener(13, this.styledTextListener);
        }
        widget.addListener(3, this.styledTextListener);
        this.memory.clear();
        this.controlRef = new WeakReference<StyledText>(widget);
        this.currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.editorsListener);
    }

    public void setContext(Object editedObject) {
        if (editedObject == null) {
            this.context = new WeakReference<Object>(null);
        }
        if (this.currentEditor == null || editedObject == null) {
            return;
        }
        this.context = new WeakReference<Object>(editedObject);
        Set<Object> contexts = this.editorContexts.get(this.currentEditor);
        if (contexts == null) {
            contexts = new HashSet<Object>();
            this.editorContexts.put(this.currentEditor, contexts);
        }
        contexts.add(this.context.get());
        StyledText t = (StyledText)this.controlRef.get();
        if (t != null) {
            Info i = this.getContextInfo();
            if (i != null) {
                t.setTopIndex(i.getTopIndex());
                t.setHorizontalIndex(i.gethIndex());
                t.setTopMargin(i.getTopMargin());
                t.setTopPixel(i.getTopPixel());
                if (i.getSelection() != null) {
                    try {
                        t.setSelection(i.getSelection());
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.memory.clear();
        }
    }

    private void updateInfo() {
        StyledText widget = (StyledText)this.controlRef.get();
        if (widget != null && !widget.isDisposed() && this.context.get() != null) {
            this.memory.put(this.context.get(), new Info(widget.getSelection(), widget.getHorizontalIndex(), widget.getTopIndex(), widget.getTopMargin(), widget.getTopPixel()));
        }
    }

    private Info getContextInfo() {
        return this.memory.get(this.context.get());
    }

    public void dispose() {
        this.context = null;
        this.memory.clear();
    }

    public class Info {
        Point selection;
        int hIndex;
        int topIndex;
        int topMargin;
        int topPixel;

        Info(Point selection, int hIndex, int topIndex, int topMargin, int topPixel) {
            this.selection = selection;
            this.hIndex = hIndex;
            this.topIndex = topIndex;
            this.topMargin = topMargin;
            this.topPixel = topPixel;
        }

        public Point getSelection() {
            return this.selection;
        }

        public int gethIndex() {
            return this.hIndex;
        }

        public int getTopIndex() {
            return this.topIndex;
        }

        public int getTopMargin() {
            return this.topMargin;
        }

        public int getTopPixel() {
            return this.topPixel;
        }
    }
}

