/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.CustomControlDecoration;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.common.TooltipHelper;
import com.indy.ui.custom.out.common.properties.HexadecimalPopup;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.indy.ui.custom.out.common.properties.UILinkedControl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ControlFactory {
    public static Image help;
    public static Image mdLink;
    protected TabbedPropertySheetWidgetFactory widgetFactory;

    static {
        try {
            help = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.jface/org/eclipse/jface/dialogs/images/message_info.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            mdLink = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.edit/icons/full/obj16/MetaDataLink.gif")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public ControlFactory(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private Composite createAdditionalComposite(Composite parent) {
        Composite additionalComposite = this.widgetFactory.createComposite(parent, 0);
        GridLayout gl = null;
        gl = new GridLayout();
        additionalComposite.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        GridData gd = new GridData(3, 1, false, false);
        additionalComposite.setLayoutData((Object)gd);
        return additionalComposite;
    }

    private GridData createGridData(UIControlDescriptor desc, boolean isLabel) {
        GridData gd = new GridData();
        if (isLabel) {
            gd.horizontalAlignment = 1;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = desc.getLabelHorizontalSpan();
        } else {
            gd.horizontalAlignment = 4;
            if (desc.getType() != UIControlDescriptor.Type.BOOLEAN) {
                gd.grabExcessHorizontalSpace = true;
            }
            gd.horizontalSpan = desc.getControlHorizontalSpan();
            if (desc.isUnbounded()) {
                gd.heightHint = 70;
                gd.widthHint = 250;
            }
        }
        return gd;
    }

    private Control createHyperlink(Composite parent, UIControlDescriptor desc) {
        Composite main = this.widgetFactory.createComposite(parent);
        GridLayout gl = null;
        gl = new GridLayout(2, false);
        main.setLayout((Layout)gl);
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 17;
        main.setLayoutData((Object)this.createGridData(desc, true));
        Hyperlink r = this.widgetFactory.createHyperlink(main, desc.getControlLabel(), 0);
        r.setUnderlined(true);
        this.createInformationControl(main, desc);
        return r;
    }

    private Control createLabel(Composite parent, UIControlDescriptor desc) {
        Composite main = this.widgetFactory.createComposite(parent);
        GridLayout gl = null;
        gl = new GridLayout(2, false);
        main.setLayout((Layout)gl);
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 17;
        main.setLayoutData((Object)this.createGridData(desc, true));
        CLabel l = this.widgetFactory.createCLabel(main, desc.getControlLabel(), 0);
        this.createInformationControl(main, desc);
        return l;
    }

    private UIControl createTextFieldPwd(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        Text control = this.widgetFactory.createText(parent, desc.getControlLabel(), 0x400000);
        Composite additional = this.widgetFactory.createComposite(parent, 0);
        additional.setLayout((Layout)new GridLayout());
        additional.setLayoutData((Object)new GridData(3, 1, false, false));
        return this.createUIControl(UIControl.Mode.TEXT, desc, label, (Control)control, null, additional);
    }

    private UIControl createBooleanButton(Composite parent, UIControlDescriptor desc) {
        Button control = null;
        Control label = null;
        Composite _c = this.widgetFactory.createComposite(parent);
        GridLayout gl = null;
        gl = new GridLayout(desc.getControlHorizontalSpan() + desc.getLabelHorizontalSpan() + 1, false);
        _c.setLayout((Layout)gl);
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        _c.setLayoutData((Object)this.createGridData(desc, false));
        ((GridData)_c.getLayoutData()).horizontalSpan += 2;
        ((GridData)_c.getLayoutData()).horizontalAlignment = 1;
        if (desc.isHyperlink()) {
            control = this.widgetFactory.createButton(_c, null, 32);
            label = this.createHyperlink(_c, desc);
        } else {
            control = this.widgetFactory.createButton(_c, desc.isHyperlink() ? "" : desc.getControlLabel(), 32);
            this.createInformationControl(_c, desc);
        }
        return this.createUIControl(UIControl.Mode.BOOLEAN, desc, label, (Control)control, null, null);
    }

    private UIControl createListUnbounded(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        org.eclipse.swt.widgets.List control = this.widgetFactory.createList(parent, 2560);
        ListViewer viewer = new ListViewer(control);
        ViewerProvider viewerProvider = new ViewerProvider(desc.getValueProvider());
        viewer.setContentProvider((IContentProvider)viewerProvider);
        viewer.setLabelProvider((IBaseLabelProvider)viewerProvider);
        UIControl res = this.createUIControl(UIControl.Mode.UNBOUNDED, desc, label, (Control)control, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        Button edit = this.widgetFactory.createButton(res.getAdditionalControlComposite(), "...", 0x800000);
        edit.setLayoutData((Object)new GridData(1, 2, false, false));
        res.addControl((Control)edit, true);
        return res;
    }

    private UIControl createListUnboundedReference(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        org.eclipse.swt.widgets.List control = this.widgetFactory.createList(parent, 2560);
        ListViewer viewer = new ListViewer(control);
        ViewerProvider viewerProvider = new ViewerProvider(desc.getValueProvider());
        viewer.setContentProvider((IContentProvider)viewerProvider);
        viewer.setLabelProvider((IBaseLabelProvider)viewerProvider);
        UIControl res = this.createUIControl(UIControl.Mode.UNBOUNDED, desc, label, (Control)control, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        Button edit = this.widgetFactory.createButton(res.getAdditionalControlComposite(), "...", 0x800000);
        edit.setLayoutData((Object)new GridData(1, 1, false, false));
        res.addControl((Control)edit, true);
        return res;
    }

    private UIControl createCombo(Composite parent, UIControlDescriptor desc) {
        int style = 0;
        if (desc.getType() == UIControlDescriptor.Type.LIST) {
            if (!desc.isEditable()) {
                style = 8;
            }
        } else if (desc.getType() == UIControlDescriptor.Type.REFERENCE) {
            style = 8;
        }
        LinkedList<UILinkedControl> controls = new LinkedList<UILinkedControl>();
        UIControl main = null;
        for (UIControlDescriptor.LinkedControlDescriptor d : desc.getLinkedDescriptors()) {
            Composite _c = this.widgetFactory.createComposite(parent);
            GridLayout gl = null;
            gl = new GridLayout(2, false);
            _c.setLayout((Layout)gl);
            gl.horizontalSpacing = 1;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            _c.setLayoutData((Object)this.createGridData(desc, true));
            ++((GridData)_c.getLayoutData()).horizontalSpan;
            CLabel l = this.widgetFactory.createCLabel(_c, d.getControlLabel(), 0);
            this.createInformationControl(_c, desc);
            CCombo c = this.widgetFactory.createCCombo(parent, style);
            c.setLayoutData((Object)this.createGridData(desc, false));
            ComboViewer viewer = this.createComboViewer(d.getValueProvider(), c);
            UILinkedControl linkedControl = new UILinkedControl(d, l, c, (StructuredViewer)viewer);
            UILinkedControl prev = (UILinkedControl)controls.peek();
            linkedControl.setParent(prev);
            d.setControl(linkedControl);
            controls.add(linkedControl);
        }
        if (!controls.isEmpty()) {
            UILinkedControl last = (UILinkedControl)controls.get(controls.size() - 1);
            --((GridData)last.getLabel().getParent().getLayoutData()).horizontalSpan;
            main = this.createUIControl(UIControl.Mode.LIST, desc, last.getLabel(), last.getCombo(), last.getViewer(), this.createAdditionalComposite(parent));
            for (UILinkedControl uILinkedControl : controls) {
                main.addUILinkedControl(uILinkedControl.getDescriptor(), uILinkedControl);
            }
        }
        if (main == null) {
            Control l = null;
            l = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
            l.setLayoutData((Object)this.createGridData(desc, true));
            CCombo cCombo = this.widgetFactory.createCCombo(parent, style);
            cCombo.setLayoutData((Object)this.createGridData(desc, false));
            ComboViewer viewer = this.createComboViewer(desc.getValueProvider(), cCombo);
            main = this.createUIControl(UIControl.Mode.LIST, desc, l, (Control)cCombo, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        }
        final UIControl res = main;
        Iterator<UIControlDescriptor.LinkedControlDescriptor> iterator = desc.getLinkedDescriptors().iterator();
        while (iterator.hasNext()) {
            UIControlDescriptor.LinkedControlDescriptor linkedControlDescriptor;
            final UIControlDescriptor.LinkedControlDescriptor d = linkedControlDescriptor = iterator.next();
            ((CCombo)main.getLinkedControl(d).getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection ss = (IStructuredSelection)res.getLinkedControl(d).getViewer().getSelection();
                    if (d.getChild() != null) {
                        res.getLinkedControl(d.getChild()).getViewer().setInput(ss.getFirstElement());
                    }
                }
            });
        }
        return main;
    }

    private ComboViewer createComboViewer(UIControlDescriptor.ValueProvider provider, CCombo c) {
        ComboViewer v = new ComboViewer(c);
        ViewerProvider viewerProvider = new ViewerProvider(provider);
        v.setContentProvider((IContentProvider)viewerProvider);
        v.setLabelProvider((IBaseLabelProvider)viewerProvider);
        v.setSorter(new ViewerSorter());
        return v;
    }

    protected UIControl createUIControl(UIControl.Mode mode, UIControlDescriptor desc, Control label, Control control, StructuredViewer viewer, Composite additionalCompositeControl) {
        if (desc.getType() != UIControlDescriptor.Type.BOOLEAN) {
            if (label != null) {
                label.setLayoutData((Object)this.createGridData(desc, true));
            }
            if (control != null) {
                control.setLayoutData((Object)this.createGridData(desc, false));
            }
        }
        UIControl res = new UIControl(mode, desc, label, control, viewer, additionalCompositeControl);
        return res;
    }

    public UIControl createControl(Composite parent, UIControlDescriptor desc) {
        UIControlDescriptor.IAddtionalControlBuilder b;
        UIControl uiControl = null;
        switch (desc.getType()) {
            case PASSWORD: {
                uiControl = this.createTextFieldPwd(parent, desc);
                break;
            }
            case BOOLEAN: {
                uiControl = this.createBooleanButton(parent, desc);
                break;
            }
            case LIST: {
                if (desc.isUnbounded()) {
                    uiControl = this.createListUnbounded(parent, desc);
                    break;
                }
                uiControl = this.createCombo(parent, desc);
                break;
            }
            case STRING: 
            case FILE: {
                if (desc.isUnbounded()) {
                    uiControl = this.createListUnbounded(parent, desc);
                    break;
                }
                uiControl = this.createString(parent, desc);
                break;
            }
            case INTEGER: {
                uiControl = this.createString(parent, desc);
                break;
            }
            case REFERENCE: {
                uiControl = desc.isUnbounded() ? this.createListUnboundedReference(parent, desc) : this.createCombo(parent, desc);
            }
        }
        String hint = desc.getHint("com.indy.ui.custom.out.common.properties.hint.dnd.emfMetaInf");
        if (hint != null && !hint.trim().isEmpty()) {
            this.createEMFDndDecoration(hint, desc, uiControl);
        }
        if ((hint = desc.getHint("com.indy.ui.custom.out.common.properties.hint.deprecated.message")) != null) {
            this.createDeprecatedDecoration(hint, desc, uiControl);
        }
        if (desc.hasHexadecimalControl()) {
            this.createHexadecimalEditorControl(desc, uiControl);
        }
        if ((b = desc.getAdditionalControlBuilder()) != null) {
            b.createControl(desc, uiControl);
        }
        return uiControl;
    }

    private void createDeprecatedDecoration(String decorationMessage, UIControlDescriptor desc, UIControl uiControl) {
        int decorationPosition = 131072;
        Control decoratedControl = null;
        if (desc.getType() == UIControlDescriptor.Type.BOOLEAN) {
            if (desc.isHyperlink()) {
                decorationPosition = 131072;
                decoratedControl = uiControl.getLabelControl();
            } else {
                decorationPosition = 131072;
                decoratedControl = uiControl.getMainControl();
            }
        } else {
            decorationPosition = 16384;
            decoratedControl = uiControl.getLabelControl();
        }
        uiControl.getLabelControl().addPaintListener((PaintListener)new DeprecatedPaintListener());
        CustomControlDecoration decoration = new CustomControlDecoration(decoratedControl, decorationPosition);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        decoration.setDescriptionText(decorationMessage);
    }

    private void createEMFDndDecoration(String hint, final UIControlDescriptor desc, UIControl uiControl) {
        StringBuffer tooltip = new StringBuffer();
        if (hint != null && !hint.trim().isEmpty()) {
            StringTokenizer t = new StringTokenizer(hint, "|");
            HashSet<EClass> eClasses = new HashSet<EClass>();
            StringBuffer droppedStr = new StringBuffer();
            while (t.hasMoreTokens()) {
                EPackage emfPacge;
                String s = t.nextToken();
                String[] parts = s.split(";");
                if (parts.length <= 1 || (emfPacge = EPackage.Registry.INSTANCE.getEPackage(parts[0].trim())) == null) continue;
                EClassifier eClassifier = emfPacge.getEClassifier(parts[1]);
                if (eClassifier instanceof EClass) {
                    eClasses.add((EClass)eClassifier);
                }
                if (desc.getControlTooltype() != null && desc.getControlTooltype().trim().isEmpty()) continue;
                if (parts.length > 2 && !parts[1].isEmpty()) {
                    if (droppedStr.length() > 0) {
                        droppedStr.append(", ");
                    }
                    droppedStr.append(parts[2]);
                    continue;
                }
                if (droppedStr.length() > 0) {
                    droppedStr.append(", \n");
                }
                if (((EClass)eClassifier).getName().equals("MdNode")) {
                    droppedStr.append("MetaData Node");
                    continue;
                }
                droppedStr.append(((EClass)eClassifier).getName());
            }
            tooltip.append(Messages.bind((String)Messages.ControlFactory_5, (Object)droppedStr.toString()));
            if (!eClasses.isEmpty()) {
                Composite p = uiControl.getLabelControl().getParent();
                ControlDecoration decoration = new ControlDecoration(uiControl.getLabelControl(), 131072, p);
                decoration.setImage(mdLink);
                decoration.setDescriptionText(tooltip.toString());
                decoration.setMarginWidth(16);
                final UIControl ui = uiControl;
                int operations = 19;
                DropTarget target = new DropTarget(uiControl.getMainControl(), operations);
                target.setTransfer(new Transfer[]{LocalTransfer.getInstance()});
                target.addDropListener(new DropTargetListener(){
                    DndFeedbackDrawer drawer;
                    {
                        this.drawer = new DndFeedbackDrawer(uIControl.getMainControl());
                    }

                    public void dragEnter(DropTargetEvent event) {
                        if (event.detail == 16) {
                            if ((event.operations & 1) != 0) {
                                event.detail = 1;
                                this.border(true);
                            } else {
                                event.detail = 0;
                                event.feedback = 0;
                                this.border(false);
                            }
                        }
                    }

                    public void dragLeave(DropTargetEvent event) {
                        event.detail = 0;
                        event.feedback = 0;
                        this.border(false);
                    }

                    public void dragOperationChanged(DropTargetEvent event) {
                        if (event.detail == 16) {
                            if ((event.operations & 1) != 0) {
                                event.detail = 1;
                            } else {
                                event.detail = 0;
                                event.feedback = 0;
                            }
                        }
                    }

                    private List<EObject> getEObjects(Object o) {
                        ArrayList<EObject> objects = new ArrayList<EObject>();
                        if (o != null) {
                            IStructuredSelection selection = (IStructuredSelection)Platform.getAdapterManager().getAdapter(o, IStructuredSelection.class);
                            if (selection != null) {
                                for (Object oo : selection.toList()) {
                                    Object e = Platform.getAdapterManager().getAdapter(oo, EObject.class);
                                    if (!(e instanceof EObject)) continue;
                                    objects.add((EObject)e);
                                }
                            } else {
                                Object e = Platform.getAdapterManager().getAdapter(o, EObject.class);
                                if (e instanceof EObject) {
                                    objects.add((EObject)e);
                                }
                            }
                        }
                        return objects;
                    }

                    private void border(boolean show) {
                        this.drawer.enabled = show;
                        ui.getMainControl().getParent().redraw();
                    }

                    public void dragOver(DropTargetEvent event) {
                        event.feedback = 9;
                        if (LocalTransfer.getInstance().isSupportedType(event.currentDataType)) {
                            Object o = LocalTransfer.getInstance().nativeToJava(event.currentDataType);
                            if (this.getEObjects(o).isEmpty() && !"macosx".equals(Platform.getOS())) {
                                event.detail = 0;
                                event.feedback = 0;
                                this.border(false);
                            } else {
                                this.border(true);
                            }
                        }
                    }

                    public void drop(DropTargetEvent event) {
                        if (LocalTransfer.getInstance().isSupportedType(event.currentDataType)) {
                            Object o = LocalTransfer.getInstance().nativeToJava(event.currentDataType);
                            for (EObject _eoBj : this.getEObjects(o)) {
                                if (!(_eoBj instanceof EObject)) continue;
                                EObject eoBj = _eoBj;
                                URI uri = null;
                                uri = eoBj.eIsProxy() ? ((InternalEObject)eoBj).eProxyURI() : EcoreUtil.getURI((EObject)eoBj);
                                if (desc.getType() == UIControlDescriptor.Type.STRING) {
                                    String val = String.valueOf(eoBj.eClass().getInstanceTypeName()) + "#" + uri.fragment();
                                    desc.getPropertySetter().changeValue(val);
                                    ui.setValue(val);
                                    continue;
                                }
                                if (desc.getType() != UIControlDescriptor.Type.REFERENCE) continue;
                                Object newValue = null;
                                AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
                                ((InternalEObject)proxy).eSetProxyURI(uri);
                                if (desc.isUnbounded()) {
                                    Object curValues = desc.getValueProvider().getValueFromObject();
                                    newValue = new ArrayList();
                                    if (curValues instanceof Collection) {
                                        ((Collection)newValue).addAll((Collection)curValues);
                                    }
                                    ((Collection)newValue).add(proxy);
                                } else {
                                    newValue = proxy;
                                }
                                desc.getPropertySetter().changeValue(newValue);
                                if (!(desc instanceof UIControlDescriptor.IRefreshable)) continue;
                                ((UIControlDescriptor.IRefreshable)((Object)desc)).refreshUIControl();
                            }
                        }
                        this.border(false);
                    }

                    public void dropAccept(DropTargetEvent event) {
                    }
                });
            }
        }
    }

    private UIControl createString(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        int style = 2048;
        style = desc.isControlMultiline() ? style | 0x40 | 0x200 : (style |= 4);
        StyledText ctrl = new StyledText(parent, style);
        this.widgetFactory.adapt((Composite)ctrl);
        if (desc.isControlMultiline()) {
            ctrl.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    e.doit = false;
                }
            });
        }
        ctrl.setLayoutData((Object)this.createGridData(desc, false));
        UIControl res = this.createUIControl(UIControl.Mode.TEXT, desc, label, (Control)ctrl, null, this.createAdditionalComposite(parent));
        if (desc.isControlMultiline()) {
            GridData gridData = (GridData)ctrl.getLayoutData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.minimumHeight = 60;
            gridData.heightHint = 100;
            gridData.widthHint = 175;
        } else {
            GridData gridData = (GridData)ctrl.getLayoutData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = false;
            gridData.widthHint = 175;
        }
        return res;
    }

    private void createHexadecimalEditorControl(final UIControlDescriptor desc, UIControl ctr) {
        Composite parent = ctr.getAdditionalControlComposite();
        final Button b = this.widgetFactory.createButton(parent, "...", 8);
        b.setLayoutData((Object)new GridData(3, 1, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexadecimalPopup popup = new HexadecimalPopup(b.getShell(), (String)desc.getValueProvider().getValueFromObject());
                if (popup.open() == 0) {
                    desc.getPropertySetter().changeValue(popup.getHexadecimalValue());
                }
            }
        });
        ctr.addControl((Control)b, true);
    }

    protected Control createInformationControl(Composite parent, UIControlDescriptor desc) {
        CLabel d = new CLabel(parent, 0);
        d.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        d.setVisible(desc.getControlTooltype() != null && !desc.getControlTooltype().trim().isEmpty());
        this.widgetFactory.adapt((Control)d, false, false);
        if (desc.getControlTooltype() != null && !desc.getControlTooltype().trim().isEmpty()) {
            TooltipHelper tooltipHelper = new TooltipHelper(desc.getControlTooltype(), (Control)d);
        }
        return d;
    }

    public static class DeprecatedPaintListener
    implements PaintListener {
        public void paintControl(PaintEvent e) {
            Control c = (Control)e.widget;
            Rectangle r = this.getBounds(c);
            Color oldColor = e.gc.getForeground();
            e.gc.setForeground(c.getDisplay().getSystemColor(2));
            int center = r.y + r.height / 2 + 2;
            e.gc.drawLine(r.x, center, r.x + r.width, center);
            e.gc.setForeground(oldColor);
        }

        private Rectangle getBounds(Control c) {
            if (c instanceof Scrollable) {
                return ((Scrollable)c).getClientArea();
            }
            if (c instanceof Button) {
                GC gc = new GC((Drawable)c.getDisplay());
                Point pt = gc.stringExtent(((Button)c).getText());
                gc.dispose();
                Rectangle r = ((Button)c).getBounds();
                return new Rectangle(r.x + 20, r.y - 1, pt.x, pt.y);
            }
            return c.getBounds();
        }
    }

    private class DndFeedbackDrawer
    implements PaintListener {
        private Control control;
        boolean enabled = false;

        DndFeedbackDrawer(Control control) {
            this.control = control;
            control.getParent().addPaintListener((PaintListener)this);
        }

        public void paintControl(PaintEvent e) {
            if (this.enabled) {
                Point p = this.control.getLocation();
                Point sz = this.control.getSize();
                Rectangle rect = new Rectangle(p.x - 1, p.y - 1, sz.x + 1, sz.y + 1);
                e.gc.setAlpha(150);
                e.gc.setForeground(Display.getDefault().getSystemColor(26));
                e.gc.drawRectangle(rect);
            }
        }
    }

    private class ViewerProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        UIControlDescriptor.ValueProvider valueProvider;

        public ViewerProvider(UIControlDescriptor.ValueProvider valueProvider) {
            this.valueProvider = valueProvider;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray(new Object[((Collection)inputElement).size()]);
            }
            List<Object> l = this.valueProvider.getPotentialValues(inputElement);
            if (l != null) {
                return l.toArray(new Object[l.size()]);
            }
            return null;
        }

        public void dispose() {
            this.valueProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            return this.valueProvider.getLabel(element);
        }
    }
}

