/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HexadecimalPopup
extends Dialog {
    private static final HexaConverter converter = new HexaConverter();
    private Text text;
    private Text hexadecimal;
    private String res;
    private ModifyListener listener = e -> this.modifyText(e.widget == this.hexadecimal);

    public HexadecimalPopup(Shell parentShell, String initialHexaValue) {
        super(parentShell);
        this.res = initialHexaValue;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout());
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData());
        l.setText("Text to encode");
        this.text = new Text(main, 2624);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData());
        l.setText("Encoded text in hexadecimal");
        this.hexadecimal = new Text(main, 2624);
        this.hexadecimal.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addModifyListener(this.listener);
        this.hexadecimal.addModifyListener(this.listener);
        this.hexadecimal.setText(this.res);
        return main;
    }

    private void modifyText(boolean isHexaField) {
        if (isHexaField) {
            this.text.removeModifyListener(this.listener);
            this.text.setText(this.fromHexa(this.hexadecimal.getText()));
            this.text.addModifyListener(this.listener);
        } else {
            this.hexadecimal.removeModifyListener(this.listener);
            this.hexadecimal.setText(this.toHexa(this.text.getText()));
            this.hexadecimal.addModifyListener(this.listener);
        }
        this.res = this.hexadecimal.getText();
    }

    public String getHexadecimalValue() {
        return this.res;
    }

    private String toHexa(String s) {
        try {
            return converter.encodeHexString(s, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private String fromHexa(String s) {
        try {
            return converter.decodeHexString(s, true);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    static class HexaConverter {
        HexaConverter() {
        }

        public String decodeHexString(String hexa, boolean replaceSpecialChar) throws UnsupportedEncodingException {
            if (hexa.length() % 2 == 0) {
                String txtInHex = hexa;
                byte[] txtInByte = new byte[txtInHex.length() / 2];
                int j = 0;
                int i = 0;
                while (i < txtInHex.length()) {
                    txtInByte[j++] = (byte)Integer.parseInt(txtInHex.substring(i, i + 2), 16);
                    i += 2;
                }
                String txt = new String(txtInByte, "UTF8");
                if (replaceSpecialChar) {
                    String result = "";
                    int i2 = 0;
                    while (i2 < txt.length()) {
                        result = txt.charAt(i2) == '\n' ? String.valueOf(result) + "\\n" : (txt.charAt(i2) == '\t' ? String.valueOf(result) + "\\t" : (txt.charAt(i2) == '\r' ? String.valueOf(result) + "\\r" : (txt.charAt(i2) == '\f' ? String.valueOf(result) + "\\f" : String.valueOf(result) + txt.charAt(i2))));
                        ++i2;
                    }
                    return result;
                }
                return txt;
            }
            return "";
        }

        public String encodeHexString(String sourceText, boolean replaceSpecialChar) throws UnsupportedEncodingException {
            String tmp = null;
            if (replaceSpecialChar) {
                tmp = sourceText.replaceAll("\\\\n", "\n");
                tmp = tmp.replaceAll("\\\\t", "\t");
                tmp = tmp.replaceAll("\\\\r", "\r");
                tmp = tmp.replaceAll("\\\\f", "\f");
            } else {
                tmp = sourceText;
            }
            byte[] rawData = tmp.getBytes("UTF8");
            StringBuffer hexText = new StringBuffer();
            String initialHex = null;
            int initHexLength = 0;
            int i = 0;
            while (i < rawData.length) {
                int positiveValue = rawData[i] & 0xFF;
                initialHex = Integer.toHexString(positiveValue);
                initHexLength = initialHex.length();
                while (initHexLength++ < 2) {
                    hexText.append("0");
                }
                hexText.append(initialHex);
                ++i;
            }
            return hexText.toString().toUpperCase();
        }
    }
}

