/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class ListUnboundedControl
extends AbstractUnboundedControl {
    private Collection<Object> possibleValues;
    private ListViewer viewer;
    private List<Object> entries = new ArrayList<Object>();
    private boolean hasFilter;
    private WorkbenchJob filterJob = new WorkbenchJob(Display.getCurrent(), Messages.ListUnboundedControl_0){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ListUnboundedControl.this.viewer.refresh();
            return Status.OK_STATUS;
        }
    };
    private boolean isResettingFiler = false;
    private String filter = null;
    private Text filterText;

    public ListUnboundedControl(ILabelProvider labelProvider, Collection possibleValues, boolean showUpAndDown, boolean hasFilter) {
        super(labelProvider, Messages.ListUnboundedControl_1, showUpAndDown);
        this.possibleValues = possibleValues;
        this.filterJob.setSystem(true);
        this.hasFilter = hasFilter;
    }

    public ListUnboundedControl(ILabelProvider labelProvider, Collection possibleValues) {
        this(labelProvider, possibleValues, true, true);
    }

    @Override
    protected void clearValueComposite() {
    }

    @Override
    protected Composite createValueComposite(Composite parent) {
        Composite main = this.getWidgetFactory().createComposite(parent);
        main.setLayout((Layout)new GridLayout());
        if (this.hasFilter) {
            this.filterText = this.getWidgetFactory().createText(main, "", 2048);
            this.filterText.setToolTipText(Messages.ListUnboundedControl_3);
            this.filterText.setLayoutData((Object)new GridData(4, 1, true, false));
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ListUnboundedControl.this.filter = ((Text)e.widget).getText();
                    ListUnboundedControl.this.filterJob.cancel();
                    ListUnboundedControl.this.filterJob.schedule(200L);
                }
            });
        }
        this.viewer = new ListViewer(this.getWidgetFactory().createList(main, 2818));
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                TableItem[] tableItemArray = ListUnboundedControl.this.getValuesViewer().getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem it = tableItemArray[n2];
                    if (element != null && element.equals(it.getData())) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!ListUnboundedControl.this.hasFilter) {
                    return true;
                }
                if (ListUnboundedControl.this.filter == null || ListUnboundedControl.this.filter.isEmpty()) {
                    return true;
                }
                String t = ".*" + ListUnboundedControl.this.filter.replace("*", ".*") + ".*";
                return ((ILabelProvider)ListUnboundedControl.this.viewer.getLabelProvider()).getText(element).matches(t);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListUnboundedControl.this.getAddButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListUnboundedControl.this.handleAddItem(ListUnboundedControl.this.getEditedValueFromValueComposite());
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 == null) {
                    if (e2 != null) {
                        return -1;
                    }
                    return 0;
                }
                if (e2 == null) {
                    return 1;
                }
                String s1 = ((ILabelProvider)((ListViewer)viewer).getLabelProvider()).getText(e1);
                String s2 = ((ILabelProvider)((ListViewer)viewer).getLabelProvider()).getText(e2);
                return s1.compareTo(s2);
            }
        });
        return main;
    }

    @Override
    protected Object getEditedValueFromValueComposite() {
        return ((IStructuredSelection)this.viewer.getSelection()).toList();
    }

    @Override
    protected void configureValuesViewer() {
        this.getValuesViewer().setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    @Override
    protected void fillValueComposite(Object valueObject) {
    }

    @Override
    protected void handleDownItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index >= 0 && index < this.entries.size() - 1) {
            Object old = this.entries.get(index + 1);
            this.entries.set(index + 1, o);
            this.entries.set(index, old);
        }
    }

    @Override
    protected void handleUpItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index > 0) {
            Object old = this.entries.get(index - 1);
            this.entries.set(index - 1, o);
            this.entries.set(index, old);
        }
    }

    @Override
    protected void handleRemoveItem(List l) {
        this.entries.removeAll(l);
        this.getValuesViewer().refresh();
        this.viewer.refresh();
        if (this.hasFilter) {
            this.filterText.setText(((ILabelProvider)this.viewer.getLabelProvider()).getText(l.get(0)));
        }
    }

    @Override
    protected void handleAddItem(Object valueObject) {
        for (Object o : (List)valueObject) {
            int i = this.entries.indexOf(o);
            if (i != -1) continue;
            this.entries.add(o);
        }
        this.getValuesViewer().refresh();
        this.viewer.refresh();
    }

    @Override
    public Object initializeInput(Object data) {
        this.entries = new ArrayList<Object>((Collection)data);
        return this.entries;
    }

    @Override
    public EList getResult() {
        return new BasicEList(this.entries);
    }

    @Override
    public void setInput(Object data) {
        super.setInput(data);
        this.viewer.setInput(this.possibleValues);
    }
}

