/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.indy.ui.custom.out.common.properties.UILinkedControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class UIControl {
    private Mode mode;
    private StructuredViewer viewer;
    private Control mainControl;
    private Control labelControl;
    private List<Control> additionalControls = new ArrayList<Control>();
    private HashMap<Control, Boolean> additionalControlsLinkedEnablement = new HashMap();
    private Object currentControlValue;
    private Composite additionalControlComposite;
    private UIControlDescriptor descriptor;
    private Map<UIControlDescriptor.LinkedControlDescriptor, UILinkedControl> linkedControls = new HashMap<UIControlDescriptor.LinkedControlDescriptor, UILinkedControl>();

    public UIControl(Mode mode, UIControlDescriptor descriptor, Control labelControl, Control mainControl, StructuredViewer viewer, Composite additionalControlComposite) {
        this.descriptor = descriptor;
        this.labelControl = labelControl;
        this.mainControl = mainControl;
        this.viewer = viewer;
        this.mode = mode;
        if (additionalControlComposite != null) {
            this.additionalControlComposite = additionalControlComposite;
        }
        if (this.labelControl == null) {
            this.labelControl = mainControl;
        }
    }

    public void addControl(Control control, boolean followMainControlEnablement) {
        this.additionalControls.add(control);
        this.additionalControlsLinkedEnablement.put(control, followMainControlEnablement);
        boolean needLyout = false;
        GridLayout gl = (GridLayout)this.additionalControlComposite.getLayout();
        if (this.additionalControlComposite.getChildren().length != gl.numColumns) {
            ((GridData)this.additionalControlComposite.getLayoutData()).exclude = false;
            gl.numColumns = this.additionalControlComposite.getChildren().length;
            needLyout = true;
        }
        if (needLyout) {
            this.additionalControlComposite.getParent().layout(true, true);
        }
    }

    public void addUILinkedControl(UIControlDescriptor.LinkedControlDescriptor desc, UILinkedControl control) {
        this.linkedControls.put(desc, control);
    }

    public UILinkedControl getLinkedControl(UIControlDescriptor.LinkedControlDescriptor desc) {
        return this.linkedControls.get(desc);
    }

    public void setValue(Object value) {
        switch (this.mode) {
            case UNBOUNDED: {
                if (this.getViewer() != null) {
                    this.getViewer().setInput(value);
                    break;
                }
                ((org.eclipse.swt.widgets.List)this.getMainControl()).setItems((String[])value);
                break;
            }
            case TEXT: {
                if (value == null) {
                    if (this.getMainControl() instanceof Text) {
                        ((Text)this.getMainControl()).setText("");
                        break;
                    }
                    if (this.getMainControl() instanceof StyledText) {
                        ((StyledText)this.getMainControl()).setText("");
                        break;
                    }
                    throw new RuntimeException("Unsupported widget");
                }
                if (this.getMainControl() instanceof Text) {
                    ((Text)this.getMainControl()).setText((String)value);
                    break;
                }
                if (this.getMainControl() instanceof StyledText) {
                    ((StyledText)this.getMainControl()).setText((String)value);
                    break;
                }
                throw new RuntimeException("Unsupported widget");
            }
            case BOOLEAN: {
                if (value == null) {
                    ((Button)this.getMainControl()).setSelection(false);
                    break;
                }
                ((Button)this.getMainControl()).setSelection(((Boolean)value).booleanValue());
                break;
            }
            case LIST: {
                if (value == null) {
                    this.getViewer().setSelection((ISelection)new StructuredSelection());
                    break;
                }
                Object[] values = ((IStructuredContentProvider)this.getViewer().getContentProvider()).getElements(this.getViewer().getInput());
                if (values != null && values.length > 0) {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(value));
                    break;
                }
                String val = this.descriptor.getValueProvider().getLabel(value);
                ((CCombo)this.getMainControl()).setText(val);
            }
        }
    }

    public Object getControlValue() {
        if (this.descriptor.getValueProvider() != null && this.descriptor.getValueProvider().canReadFromControl()) {
            return this.descriptor.getValueProvider().getValueFromControl();
        }
        if (this.getMainControl() instanceof Button) {
            return ((Button)this.getMainControl()).getSelection();
        }
        if (this.getMainControl() instanceof CCombo) {
            Object viewerVal = null;
            if (this.getViewer() != null) {
                viewerVal = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
            }
            return viewerVal;
        }
        if (this.getMainControl() instanceof Text) {
            return ((Text)this.getMainControl()).getText();
        }
        if (this.getMainControl() instanceof StyledText) {
            return ((StyledText)this.getMainControl()).getText();
        }
        return null;
    }

    public void hookListeners() {
        block0 : switch (this.mode) {
            case BOOLEAN: {
                ((Button)this.mainControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Boolean newValue = ((Button)UIControl.this.mainControl).getSelection();
                        UIControl.this.descriptor.getPropertySetter().changeValue(newValue);
                    }
                });
                break;
            }
            case LIST: {
                ((CCombo)this.mainControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Object newValue = UIControl.this.getControlValue();
                        if (newValue != UIControl.this.currentControlValue && (newValue == null || UIControl.this.currentControlValue == null || !newValue.equals(UIControl.this.currentControlValue)) || newValue == null && UIControl.this.currentControlValue != null) {
                            UIControlDescriptor.Setter setter = UIControl.this.descriptor.getPropertySetter();
                            Object object = newValue;
                            UIControl.this.currentControlValue = object;
                            setter.changeValue(object);
                        }
                    }
                });
            }
            case TEXT: {
                if (this.mode == Mode.TEXT || this.mode == Mode.LIST && this.descriptor.isEditable()) {
                    this.mainControl.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            UIControl.this.currentControlValue = UIControl.this.getControlValue();
                        }

                        public void focusLost(FocusEvent e) {
                            Object newValue = UIControl.this.getControlValue();
                            UIControl.this.descriptor.getPropertySetter().changeValue(newValue);
                        }
                    });
                }
                if (this.descriptor.isControlMultiline()) break;
                this.mainControl.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.character == '\r' && UIControl.this.descriptor.isControlMultiline()) {
                            UIControl.this.mainControl.getParent().forceFocus();
                        }
                    }
                });
                break;
            }
            case UNBOUNDED: {
                for (Control c : this.additionalControls) {
                    if (!(c instanceof Button)) continue;
                    ((Button)c).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Object o = UIControl.this.descriptor.getUnboundedEditorProvider().openEditor();
                            if (o != null) {
                                UIControl.this.currentControlValue = o;
                                UIControl.this.descriptor.getPropertySetter().changeValue(UIControl.this.currentControlValue);
                            }
                        }
                    });
                    break block0;
                }
                break;
            }
        }
    }

    public void setEnabled(boolean enabled, boolean hyperlinkEnabled) {
        this.mainControl.setEnabled(enabled);
        if (this.mainControl instanceof StyledText) {
            this.mainControl.setBackground(enabled ? this.mainControl.getDisplay().getSystemColor(37) : this.mainControl.getDisplay().getSystemColor(22));
        }
        if (this.labelControl instanceof Hyperlink) {
            ((Hyperlink)this.labelControl).setEnabled(hyperlinkEnabled);
        }
        for (Control c : this.additionalControls) {
            if (!this.additionalControlsLinkedEnablement.get(c).booleanValue()) continue;
            c.setEnabled(enabled);
        }
        for (UIControlDescriptor.LinkedControlDescriptor d : this.linkedControls.keySet()) {
            this.linkedControls.get(d).setEnabled(enabled);
        }
    }

    public Control getMainControl() {
        return this.mainControl;
    }

    public Composite getAdditionalControlComposite() {
        return this.additionalControlComposite;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Control getLabelControl() {
        return this.labelControl;
    }

    public static enum Mode {
        LIST,
        BOOLEAN,
        TEXT,
        UNBOUNDED;

    }
}

