/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.dialog;

import com.indy.ui.custom.out.Messages;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class NicePopup
extends Window {
    public static Image deleteImage;
    public static Image okImage;
    protected Widget applyToolItem;
    protected TabbedPropertySheetWidgetFactory widgetFactory;
    private String title;
    private Image icon;
    private String okLabel;
    private String cancelLabel;
    private boolean blocking = false;
    private Listener clickListener = new Listener(){

        public void handleEvent(Event event) {
            Rectangle r = NicePopup.this.getShell().getBounds();
            if (!r.contains(NicePopup.this.getShell().toDisplay(new Point(event.x, event.y)))) {
                NicePopup.this.setReturnCode(1);
                NicePopup.this.close();
            }
        }
    };

    static {
        try {
            deleteImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.workbench.texteditor/icons/full/elcl16/delete_template.png")).createImage();
        }
        catch (Exception e) {
            deleteImage = null;
        }
        try {
            okImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj16x16/MappingTableCheck16x16.png")).createImage();
        }
        catch (Exception e) {
            okImage = null;
        }
    }

    public NicePopup(Shell parentShell, String title, Image titleIcon, boolean isBlocking) {
        super(parentShell);
        this.title = title;
        this.icon = titleIcon;
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setShellStyle(20);
        this.blocking = isBlocking;
        this.setBlockOnOpen(this.blocking);
    }

    public NicePopup(Shell parentShell, String title, Image titleIcon, boolean isBlocking, String okLabel, String cancelLabel) {
        this(parentShell, title, titleIcon, isBlocking);
        this.okLabel = okLabel;
        this.cancelLabel = cancelLabel;
    }

    protected final TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected void configureShell(Shell newShell) {
        newShell.setLayout((Layout)new GridLayout());
        newShell.setBackgroundMode(2);
        newShell.setBackground(newShell.getDisplay().getSystemColor(32));
        ((GridLayout)newShell.getLayout()).marginBottom = 0;
        ((GridLayout)newShell.getLayout()).marginHeight = 0;
        ((GridLayout)newShell.getLayout()).marginLeft = 0;
        ((GridLayout)newShell.getLayout()).marginRight = 0;
        ((GridLayout)newShell.getLayout()).marginTop = 0;
        ((GridLayout)newShell.getLayout()).marginWidth = 0;
    }

    protected final Control createContents(Composite parent) {
        this.createTitleBar(parent, this.title, this.icon);
        Composite main = this.widgetFactory.createComposite(parent);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        ((GridLayout)main.getLayout()).horizontalSpacing = 0;
        ((GridLayout)main.getLayout()).verticalSpacing = 0;
        ((GridLayout)main.getLayout()).marginHeight = 0;
        ((GridLayout)main.getLayout()).marginWidth = 0;
        this.createDialogArea(main);
        Composite bar = this.widgetFactory.createComposite(main, 0);
        bar.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)bar.getLayout()).horizontalSpacing = 0;
        ((GridLayout)bar.getLayout()).verticalSpacing = 0;
        ((GridLayout)bar.getLayout()).marginHeight = 0;
        ((GridLayout)bar.getLayout()).marginWidth = 0;
        ((GridLayout)bar.getLayout()).marginBottom = 5;
        bar.setLayoutData((Object)new GridData(3, 2, false, false));
        this.createOkButton(bar);
        this.createCancelButton(bar);
        return main;
    }

    private void createOkButton(Composite parent) {
        Button b = this.widgetFactory.createButton(parent, this.okLabel == null ? Messages.NicePopup_2 : this.okLabel, 8);
        b.setLayoutData((Object)new GridData(3, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NicePopup.this.setReturnCode(0);
                NicePopup.this.close();
            }
        });
        this.applyToolItem = b;
    }

    protected void createCancelButton(Composite parent) {
        Button b = this.widgetFactory.createButton(parent, this.cancelLabel == null ? Messages.NicePopup_3 : this.cancelLabel, 8);
        b.setLayoutData((Object)new GridData(3, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NicePopup.this.setReturnCode(1);
                NicePopup.this.close();
            }
        });
    }

    protected Composite createDialogArea(Composite parent) {
        Composite c = this.widgetFactory.createComposite(parent, 0);
        return c;
    }

    protected Widget getApplyButton() {
        return this.applyToolItem;
    }

    protected void createTitleBar(Composite parent, String title, Image titleIcon) {
        Composite c = this.widgetFactory.createComposite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)c.getLayout()).marginBottom = 0;
        ((GridLayout)c.getLayout()).marginHeight = 0;
        ((GridLayout)c.getLayout()).marginLeft = 0;
        ((GridLayout)c.getLayout()).marginRight = 0;
        ((GridLayout)c.getLayout()).marginTop = 0;
        ((GridLayout)c.getLayout()).marginWidth = 0;
        c.setBackground(this.getShell().getDisplay().getSystemColor(32));
        Label l = this.widgetFactory.createLabel(c, "");
        l.setBackground(this.getShell().getDisplay().getSystemColor(32));
        l.setImage(titleIcon);
        l.setLayoutData((Object)new GridData(1, 4, false, false));
        l = this.widgetFactory.createLabel(c, title);
        l.setBackground(this.getShell().getDisplay().getSystemColor(32));
        l.setLayoutData((Object)new GridData(4, 4, true, false));
        Listener shellListener = new Listener(){
            int startX;
            int startY;

            public void handleEvent(Event e) {
                if (e.type == 1 && e.character == '\u001b') {
                    NicePopup.this.getShell().dispose();
                }
                if (e.type == 3 && e.button == 1) {
                    this.startX = e.x;
                    this.startY = e.y;
                }
                if (e.type == 5 && (e.stateMask & 0x80000) != 0) {
                    Point p = NicePopup.this.getShell().toDisplay(e.x, e.y);
                    p.x -= this.startX;
                    p.y -= this.startY;
                    NicePopup.this.getShell().setLocation(p);
                }
            }
        };
        l.addListener(1, shellListener);
        l.addListener(3, shellListener);
        l.addListener(5, shellListener);
    }

    public int open() {
        if (!this.blocking) {
            this.getShell().getDisplay().addFilter(3, this.clickListener);
        }
        return super.open();
    }

    public boolean close() {
        if (!this.blocking) {
            this.getShell().getDisplay().removeFilter(3, this.clickListener);
        }
        return super.close();
    }
}

