/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.Messages;
import org.eclipse.emf.common.util.URI;

public interface IResourceLocker {
    public void aquireLock(URI var1, String var2) throws AlreadyLockedException, Exception;

    public boolean canLock(URI var1, String var2);

    public boolean hasLock(URI var1, String var2);

    public boolean isLockedByAnotherEditingDomain(URI var1, String var2);

    public void releaseLock(URI var1, String var2);

    public void releaseEditingDomain(String var1);

    public String getLockOwnerEditingDomainId(URI var1);

    public void addListener(IResourceLockerListener var1);

    public void removeListener(IResourceLockerListener var1);

    public static class AlreadyLockedException
    extends Exception {
        private String editingDomainID;
        private URI resourceURI;

        public AlreadyLockedException(String editingDomainID, URI resourceURI) {
            super(Messages.bind((String)Messages.IResourceLocker_0, (Object)resourceURI.toPlatformString(true), (Object)editingDomainID));
            this.editingDomainID = editingDomainID;
            this.resourceURI = resourceURI;
        }

        public String getEditingDomainID() {
            return this.editingDomainID;
        }

        public URI getResourceURI() {
            return this.resourceURI;
        }
    }

    public static interface IResourceLockerListener {
        public void handleLockAcquired(URI var1, String var2);

        public void handleLockReleased(URI var1, String var2);
    }
}

