/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.navigator;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.semarchy.xdi.designer.core.Constants;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;
import org.eclipse.ui.internal.navigator.resources.actions.EditActionGroup;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class EditActionProvider
extends CommonActionProvider {
    private EditActionGroup editGroup;
    private ICommonActionExtensionSite site;

    public void init(ICommonActionExtensionSite anActionSite) {
        this.site = anActionSite;
        this.editGroup = new EditActionGroup(this.site.getViewSite().getShell()){

            protected void makeActions() {
                super.makeActions();
                ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
                CustomDeleteResourceAction deleteAction = new CustomDeleteResourceAction(EditActionProvider.this.site.getViewSite().getShell());
                deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
                deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
                deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
                try {
                    Field f = EditActionGroup.class.getDeclaredField("deleteAction");
                    if (f != null) {
                        boolean oldAccess = f.isAccessible();
                        if (!oldAccess) {
                            f.setAccessible(true);
                        }
                        f.set((Object)this, (Object)deleteAction);
                        if (!oldAccess) {
                            f.setAccessible(oldAccess);
                        }
                    }
                }
                catch (Throwable t) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", String.valueOf(Messages.EditActionProvider_0) + t.getMessage(), t));
                }
            }
        };
    }

    public void dispose() {
        this.editGroup.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.editGroup.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.editGroup.fillContextMenu(menu);
    }

    public void setContext(ActionContext context) {
        this.editGroup.setContext(context);
    }

    public void updateActionBars() {
        this.editGroup.updateActionBars();
    }

    private class CustomDeleteResourceAction
    extends DeleteResourceAction {
        public CustomDeleteResourceAction(IShellProvider provider) {
            super(provider);
        }

        private CustomDeleteResourceAction(Shell shell) {
            super(shell);
        }

        protected List getSelectedResources() {
            ArrayList l = new ArrayList(super.getSelectedResources());
            ArrayList<IResource> diagramToAdd = new ArrayList<IResource>();
            for (Object o : l) {
                IResource diagram;
                if (!(o instanceof IFile)) continue;
                boolean isProc = "proc".equals(((IFile)o).getFileExtension());
                boolean isMap = "map".equals(((IFile)o).getFileExtension());
                if (!isProc && !isMap) continue;
                IPath diagramPath = this.getDiagramPath((IFile)o);
                boolean diagramIncluded = false;
                for (Object _o : l) {
                    IPath p;
                    if (!(_o instanceof IFile) || !(p = ((IFile)_o).getFullPath()).equals((Object)diagramPath)) continue;
                    diagramIncluded = true;
                }
                if (diagramIncluded || (diagram = ResourcesPlugin.getWorkspace().getRoot().findMember(diagramPath)) == null || !diagram.exists()) continue;
                diagramToAdd.add(diagram);
            }
            l.addAll(diagramToAdd);
            return l;
        }

        public void run() {
            List selectedResource;
            if (!this.fTestingMode && LTKLauncher.openDeleteWizard((IStructuredSelection)new StructuredSelection(selectedResource = this.getSelectedResources()))) {
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        IResource r;
                        IEditorInput input = ref.getEditorInput();
                        if (input != null && (r = (IResource)input.getAdapter(IResource.class)) instanceof IFile) {
                            for (Object o : selectedResource) {
                                if (!(o instanceof IResource) || !r.getFullPath().equals((Object)((IResource)o).getFullPath())) continue;
                                toClose.add(ref);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", String.valueOf(Messages.EditActionProvider_2) + ex.getMessage(), (Throwable)ex));
                    }
                    ++n2;
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), false);
                return;
            }
            super.run();
        }

        private IPath getDiagramPath(IFile o) {
            String extension = o.getFileExtension();
            String diagramDirectory = null;
            if (extension.equals("map")) {
                diagramDirectory = Constants.indyMapDiagramDirectory;
            } else if (extension.equals("proc")) {
                diagramDirectory = Constants.indyProcDiagramDirectory;
            }
            IPath p = o.getFullPath().removeLastSegments(1).append("/" + Constants.indyWorkDiagramDirectoryName + "/" + diagramDirectory + "/").append(String.valueOf(o.getName()) + "_diagram");
            return p;
        }
    }
}

