/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperManager;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkCommand
extends AbstractHandler {
    HashMap<LinkHelperDescriptor, ILinkHelper> helpers = new HashMap();

    private IStructuredSelection mergeSelection(IStructuredSelection aBase, IStructuredSelection aSelectionToAppend) {
        if (aBase == null || aBase.isEmpty()) {
            return aSelectionToAppend != null ? aSelectionToAppend : StructuredSelection.EMPTY;
        }
        if (aSelectionToAppend == null || aSelectionToAppend.isEmpty()) {
            return aBase;
        }
        ArrayList newItems = new ArrayList(aBase.toList());
        for (Object o : aSelectionToAppend.toList()) {
            if (newItems.contains(o)) continue;
            newItems.add(o);
        }
        return new StructuredSelection(newItems);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart v = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (v == null) {
            return null;
        }
        INavigatorContentService navigatorContentService = (INavigatorContentService)v.getAdapter(INavigatorContentService.class);
        CommonViewer viewer = (CommonViewer)v.getAdapter(CommonViewer.class);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && viewer != null) {
            LinkHelperDescriptor[] desc = LinkHelperManager.getInstance().getLinkHelpersFor(editor.getEditorInput(), navigatorContentService);
            StructuredSelection selection = StructuredSelection.EMPTY;
            StructuredSelection newSelection = StructuredSelection.EMPTY;
            LinkHelperDescriptor[] linkHelperDescriptorArray = desc;
            int n = desc.length;
            int n2 = 0;
            while (n2 < n) {
                LinkHelperDescriptor d = linkHelperDescriptorArray[n2];
                ILinkHelper helper = this.helpers.get(d);
                if (helper == null) {
                    helper = d.createLinkHelper();
                    this.helpers.put(d, helper);
                }
                if ((selection = helper.findSelection(editor.getEditorInput())) != null && !selection.isEmpty()) {
                    newSelection = this.mergeSelection((IStructuredSelection)newSelection, (IStructuredSelection)selection);
                }
                ++n2;
            }
            if (!newSelection.isEmpty()) {
                HashSet<Object> newExpandedElements = new HashSet<Object>();
                newExpandedElements.addAll(newSelection.toList());
                Object[] objectArray = viewer.getExpandedElements();
                int n3 = objectArray.length;
                n = 0;
                while (n < n3) {
                    Object o = objectArray[n];
                    newExpandedElements.add(o);
                    ++n;
                }
                if (!newExpandedElements.isEmpty()) {
                    List list = newSelection.toList();
                    Collections.sort(list, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 instanceof IResource) {
                                if (o2 instanceof IResource) {
                                    return ((IResource)o1).getFullPath().toString().compareTo(((IResource)o2).getFullPath().toString());
                                }
                                return -1;
                            }
                            if (o2 instanceof IResource) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    Object lastElement = list.get(list.size() - 1);
                    newExpandedElements.remove(lastElement);
                    viewer.setExpandedElements(newExpandedElements.toArray(new Object[newExpandedElements.size()]));
                    viewer.setSelection((ISelection)new StructuredSelection(lastElement), true);
                }
            }
        }
        return null;
    }
}

