/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage()){

                public void run() {
                    for (IResource resource : this.getSelectedResources()) {
                        block5: {
                            if (!(resource instanceof IFile)) continue;
                            try {
                                IMarker[] m = ((IFile)resource).findMarkers("com.stambia.resource.marker.duplicate", false, 0);
                                if (m == null || m.length <= 0) break block5;
                                try {
                                    boolean activate = OpenStrategy.activateOnOpen();
                                    OpenActionProvider.this.viewSite.getPage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), "org.eclipse.ui.DefaultTextEditor", activate);
                                }
                                catch (PartInitException e) {
                                    DialogUtil.openError((Shell)OpenActionProvider.this.viewSite.getPage().getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, (String)e.getMessage(), (PartInitException)e);
                                }
                                return;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        this._openFile((IFile)resource);
                    }
                }

                void _openFile(IFile file) {
                    IEditorRegistry reg = PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor editorDesc = null;
                    IContentType contentType = IDE.getContentType((IFile)file);
                    editorDesc = reg.getDefaultEditor(file.getName(), contentType);
                    if (editorDesc != null) {
                        try {
                            IEditorDescriptor desc;
                            String editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                            if (editorID != null && (desc = reg.findEditor(editorID)) != null && !desc.getId().equals(editorDesc.getId())) {
                                IDE.setDefaultEditor((IFile)file, (String)editorDesc.getId());
                            }
                        }
                        catch (CoreException editorID) {
                            // empty catch block
                        }
                    }
                    if (editorDesc == null) {
                        if (reg.isSystemInPlaceEditorAvailable(file.getName())) {
                            editorDesc = reg.findEditor("org.eclipse.ui.systemInPlaceEditor");
                        }
                        if (editorDesc == null && reg.isSystemExternalEditorAvailable(file.getName())) {
                            editorDesc = reg.findEditor("org.eclipse.ui.systemExternalEditor");
                        }
                    }
                    if (editorDesc == null) {
                        editorDesc = reg.findEditor("org.eclipse.ui.DefaultTextEditor");
                    }
                    try {
                        boolean activate = OpenStrategy.activateOnOpen();
                        OpenActionProvider.this.viewSite.getPage().openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), activate);
                    }
                    catch (PartInitException e) {
                        DialogUtil.openError((Shell)OpenActionProvider.this.viewSite.getPage().getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, (String)e.getMessage(), (PartInitException)e);
                    }
                }
            };
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(selection);
        if (this.openFileAction.isEnabled()) {
            aMenu.insertAfter("group.open", (IAction)this.openFileAction);
        }
        this.addOpenWithMenu(aMenu);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }

    private void addOpenWithMenu(IMenuManager aMenu) {
        IStructuredSelection ss = (IStructuredSelection)this.getContext().getSelection();
        if (ss == null || ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        IAdaptable openable = (IAdaptable)OpenActionProvider.getAdapter(o, IResource.class);
        if (openable == null) {
            openable = (IAdaptable)OpenActionProvider.getAdapter(o, ResourceMapping.class);
        } else if (((IResource)openable).getType() != 1) {
            openable = null;
        }
        try {
            IMarker[] m = ((IResource)openable).findMarkers("com.stambia.resource.marker.duplicate", false, 0);
            if (m != null && m.length > 0) {
                openable = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (openable != null) {
            MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.OpenActionProvider_OpenWithMenu_label, "group.openWith");
            submenu.add((IContributionItem)new GroupMarker("group.top"));
            submenu.add((IContributionItem)new CustomOpenWithMenu(this.viewSite.getPage(), openable));
            submenu.add((IContributionItem)new GroupMarker("additions"));
            if (submenu.getItems().length > 2 && submenu.isEnabled()) {
                aMenu.appendToGroup("group.openWith", (IContributionItem)submenu);
            }
        }
    }

    public static Object getAdapter(Object anElement, Class anAdapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)anAdapterType);
        if (anElement == null) {
            return null;
        }
        if (anAdapterType.isInstance(anElement)) {
            return anElement;
        }
        if (anElement instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)anElement).getAdapter(anAdapterType)) != null) {
            Assert.isTrue((boolean)anAdapterType.isInstance(result2));
            return result2;
        }
        if (!(anElement instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(anElement, anAdapterType)) != null) {
            return result;
        }
        return null;
    }

    class CustomOpenWithMenu
    extends OpenWithMenu {
        private IWorkbenchPage page;
        private IAdaptable file;

        public CustomOpenWithMenu(IWorkbenchPage page, IAdaptable file) {
            super(page, file);
            this.page = page;
            this.file = file;
        }

        private IFile getFileResource() {
            if (this.file instanceof IFile) {
                return (IFile)this.file;
            }
            IResource resource = (IResource)this.file.getAdapter(IResource.class);
            if (resource instanceof IFile) {
                return (IFile)resource;
            }
            return null;
        }

        protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
            IFile file = this.getFileResource();
            if (file == null) {
                return;
            }
            try {
                if (openUsingDescriptor) {
                    ((WorkbenchPage)this.page).openEditorFromDescriptor((IEditorInput)new FileEditorInput(file), editorDescriptor, true, null);
                } else {
                    String editorId = editorDescriptor == null ? "org.eclipse.ui.systemExternalEditor" : editorDescriptor.getId();
                    this.page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"Problems Opening Editor", (String)e.getMessage());
            }
        }
    }
}

