/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.navigator;

import com.indy.ui.custom.out.Messages;
import com.semarchy.xdi.designer.core.Constants;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceSelectionUtil;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RefactorActionProvider
extends CommonActionProvider {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ActionGroup refactorGroup;

    public void init(ICommonActionExtensionSite anActionSite) {
        this.refactorGroup = new CustomRefactorActionGroup(anActionSite.getViewSite().getShell(), (Tree)anActionSite.getStructuredViewer().getControl());
    }

    public void dispose() {
        this.refactorGroup.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.refactorGroup.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.refactorGroup.fillContextMenu(menu);
    }

    public void setContext(ActionContext context) {
        this.refactorGroup.setContext(context);
    }

    public void updateActionBars() {
        this.refactorGroup.updateActionBars();
    }

    private class CustomRefactorActionGroup
    extends ActionGroup {
        Shell shell;
        Tree tree;
        RenameResourceAction renameAction;
        MoveResourceAction moveAction;

        public CustomRefactorActionGroup(Shell aShell, Tree aTree) {
            this.shell = aShell;
            this.tree = aTree;
            this.makeActions();
        }

        public void fillContextMenu(IMenuManager menu) {
            boolean anyResourceSelected;
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
            if (anyResourceSelected) {
                this.moveAction.selectionChanged(selection);
                menu.appendToGroup("group.reorganize", (IAction)this.moveAction);
                this.renameAction.selectionChanged(selection);
                menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
            }
        }

        public void fillActionBars(IActionBars actionBars) {
            this.updateActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        }

        protected void makeActions() {
            IShellProvider sp = () -> this.shell;
            this.moveAction = new MoveResourceAction(sp);
            this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
            this.renameAction = new RenameResourceAction(sp, this.tree){

                public void run() {
                    List resources = this.getSelectedResources();
                    IResource renamingResource = null;
                    if (resources.size() == 1) {
                        renamingResource = (IResource)resources.get(0);
                    }
                    ArrayList<IEditorReference> editorIdToOpen = new ArrayList<IEditorReference>();
                    boolean needSave = false;
                    IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference ref = iEditorReferenceArray[n2];
                        boolean resourceOpened = false;
                        try {
                            IEditorInput input = ref.getEditorInput();
                            IFile _r = (IFile)input.getAdapter(IResource.class);
                            if (_r != null) {
                                if (_r.getFileExtension() != null && _r.getFileExtension().endsWith("_diagram")) {
                                    String diagramType = null;
                                    String extension = _r.getFileExtension();
                                    if (extension.startsWith("map_")) {
                                        diagramType = Constants.indyMapDiagramDirectory;
                                    } else if (extension.startsWith("proc_")) {
                                        diagramType = Constants.indyProcDiagramDirectory;
                                    }
                                    String lastSegment = renamingResource.getFullPath().removeFileExtension().lastSegment();
                                    IPath p = renamingResource.getFullPath().removeLastSegments(1).append("/" + Constants.indyWorkDiagramDirectoryName).append("/" + diagramType).append("/" + lastSegment).addFileExtension(extension);
                                    if (_r.getFullPath().equals((Object)p)) {
                                        resourceOpened = true;
                                    }
                                } else if (_r.equals((Object)renamingResource)) {
                                    resourceOpened = true;
                                }
                            }
                            if (resourceOpened) {
                                editorIdToOpen.add(ref);
                                if (ref.isDirty()) {
                                    needSave = true;
                                }
                            }
                        }
                        catch (PartInitException e) {
                            RefactorActionProvider.this.logger.error("Failed to get editorReference's input", (Throwable)e);
                        }
                        ++n2;
                    }
                    if (needSave) {
                        if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RefactorActionProvider_6, (String)Messages.bind((String)Messages.RefactorActionProvider_7, (Object)renamingResource.getName()))) {
                            return;
                        }
                        String preferedEditrId = IDE.getDefaultEditor((IFile)((IFile)renamingResource), (boolean)true).getId();
                        for (IEditorReference ref : editorIdToOpen) {
                            IEditorPart ep = ref.getEditor(false);
                            if (ep == null) continue;
                            if (editorIdToOpen.size() > 1) {
                                if (!ref.getId().equals(preferedEditrId)) continue;
                                ep.doSave((IProgressMonitor)new NullProgressMonitor());
                                continue;
                            }
                            ep.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editorIdToOpen.toArray(new IEditorReference[editorIdToOpen.size()]), false);
                    super.run();
                }
            };
            this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        }

        public void updateActionBars() {
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            this.moveAction.selectionChanged(selection);
            this.renameAction.selectionChanged(selection);
        }
    }
}

