/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.search;

import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class AbstractSearchBar {
    public static Image IMG_SEARCH = null;
    public static ImageDescriptor DESC_SEARCH = null;
    private Text text;
    private CommonViewer viewer;
    private static final Timer timer;
    private ModifyListener textListener = new ModifyListener(){
        volatile TimerTask task = new TimerTask(){

            @Override
            public void run() {
                AbstractSearchBar.this.viewer.refresh();
            }
        };

        public void modifyText(ModifyEvent e) {
            this.task.cancel();
            this.task = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractSearchBar.this.viewer.refresh();
                        }
                    });
                }
            };
            timer.schedule(this.task, 300L);
        }
    };
    private URIEditorInput editorInput;
    private String navigatorViewerId;
    private String[] extensionIds;

    static {
        try {
            DESC_SEARCH = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/magnifier.png"));
            IMG_SEARCH = DESC_SEARCH.createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        timer = new Timer("SearchBar Timer");
    }

    public AbstractSearchBar(URIEditorInput editorInput, String navigatorViewerId, String[] extensionIds) {
        this.editorInput = editorInput;
        this.navigatorViewerId = navigatorViewerId;
        this.extensionIds = extensionIds;
    }

    protected abstract ViewerFilter createViewerFilter();

    public Control createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).equalWidth(false).create());
        CLabel l = new CLabel(main, 0);
        l.setImage(IMG_SEARCH);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        this.text = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text);
        this.text.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    AbstractSearchBar.this.text.setText("");
                    AbstractSearchBar.this.text.setForeground(null);
                    AbstractSearchBar.this.text.selectAll();
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractSearchBar.this.text.removeModifyListener(AbstractSearchBar.this.textListener);
            }

            public void focusGained(FocusEvent e) {
                AbstractSearchBar.this.text.addModifyListener(AbstractSearchBar.this.textListener);
            }
        });
        Composite modeComposite = new Composite(main, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(modeComposite);
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)modeComposite);
        this.createSearchModeComposite(modeComposite);
        this.viewer = new CommonViewer(this.navigatorViewerId, main, 68096);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.getNavigatorContentService().getActivationService().activateExtensions(this.extensionIds, true);
        this.customizeViewer();
        return main;
    }

    protected abstract void createSearchModeComposite(Composite var1);

    protected abstract void handleSelectionChanged(SelectionChangedEvent var1);

    protected void customizeViewer() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractSearchBar.this.handleSelectionChanged(event);
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String sa = ((ILabelProvider)((CommonViewer)viewer).getLabelProvider()).getText(e1);
                String sb = ((ILabelProvider)((CommonViewer)viewer).getLabelProvider()).getText(e2);
                return sa.compareTo(sb);
            }
        });
        this.viewer.setFilters(new ViewerFilter[]{this.createViewerFilter()});
    }

    protected CommonViewer getViewer() {
        return this.viewer;
    }

    public void init(Object input) {
        URI processURI = this.editorInput.getURI();
        if (this.viewer.getInput() == null || !processURI.equals(this.viewer.getInput())) {
            this.viewer.setInput((Object)processURI);
        }
    }

    public void dispose() {
        if (this.viewer != null) {
            try {
                this.viewer.getNavigatorContentService().getActivationService().deactivateExtensions(this.extensionIds, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.viewer = null;
        }
    }

    protected String getFilterText() {
        return this.text == null || this.text.isDisposed() ? "" : this.text.getText();
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    public void setFocus() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setFocus();
        }
    }

    public void clear() {
        this.viewer.setInput(null);
    }
}

