/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.search;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.search.AbstractSearchBar;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class OutlineWithSearchBar
extends Page
implements IContentOutlinePage {
    protected PageBook pageBook;
    protected IContentOutlinePage currentContentOutlinePage;
    private AbstractSearchBar searchBar;
    private Control searchBarControl;
    private Action search;
    private Action miniature;
    private boolean showingContentPage = true;

    public OutlineWithSearchBar(AbstractSearchBar searchBar) {
        this.searchBar = searchBar;
    }

    protected AbstractSearchBar getSearchBar() {
        return this.searchBar;
    }

    public Control getSearchBarControl() {
        return this.searchBarControl;
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected boolean isShowingContentPage() {
        return this.showingContentPage;
    }

    public void disposeCurrentOutlinePage() {
        if (this.currentContentOutlinePage != null) {
            this.currentContentOutlinePage.dispose();
            this.currentContentOutlinePage = null;
        }
    }

    public void dispose() {
        if (this.searchBar != null) {
            this.searchBar.dispose();
            this.searchBar = null;
        }
        if (this.currentContentOutlinePage != null) {
            this.currentContentOutlinePage.dispose();
            this.currentContentOutlinePage = null;
        }
        super.dispose();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars bars = pageSite.getActionBars();
        this.miniature = new Action(Messages.OutlineWithSearchBar_0){

            public void run() {
                OutlineWithSearchBar.this.pageBook.showPage(OutlineWithSearchBar.this.currentContentOutlinePage.getControl());
                OutlineWithSearchBar.this.showingContentPage = true;
                OutlineWithSearchBar.this.miniature.setChecked(true);
                OutlineWithSearchBar.this.search.setChecked(false);
                OutlineWithSearchBar.this.searchBar.clear();
            }
        };
        this.miniature.setChecked(true);
        this.miniature.setImageDescriptor(DiagramUIPluginImages.DESC_OVERVIEW);
        bars.getToolBarManager().add((IAction)this.miniature);
        this.search = new Action(Messages.OutlineWithSearchBar_1){

            public void run() {
                OutlineWithSearchBar.this.pageBook.showPage(OutlineWithSearchBar.this.searchBarControl);
                OutlineWithSearchBar.this.searchBar.init(OutlineWithSearchBar.this.getViewerInput());
                OutlineWithSearchBar.this.showingContentPage = false;
                OutlineWithSearchBar.this.miniature.setChecked(false);
                OutlineWithSearchBar.this.search.setChecked(true);
            }
        };
        this.search.setChecked(true);
        this.search.setImageDescriptor(AbstractSearchBar.DESC_SEARCH);
        bars.getToolBarManager().add((IAction)this.search);
    }

    public abstract Object getViewerInput();

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.searchBarControl = this.searchBar.createControl((Composite)this.pageBook);
        this.search.setChecked(false);
    }

    protected void setCurrentOutline(IContentOutlinePage page) {
        if (page != null) {
            this.currentContentOutlinePage = page;
            if (this.pageBook == null) {
                return;
            }
            Control control = page.getControl();
            if (control == null || control.isDisposed()) {
                page.createControl((Composite)this.pageBook);
                control = page.getControl();
            }
            if (this.showingContentPage) {
                this.pageBook.showPage(control);
                this.searchBar.clear();
            } else {
                this.pageBook.showPage(this.searchBarControl);
                this.searchBar.init(this.getViewerInput());
            }
        }
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        if (this.showingContentPage) {
            this.currentContentOutlinePage.getControl().setFocus();
        } else {
            this.searchBar.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

