/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.services.internal;

import com.indy.ui.custom.out.services.IStatisticsProvider;
import com.indy.ui.custom.out.services.internal.Messages;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IStatisticsProvider.class}, scope=ServiceScope.SINGLETON)
public class StatisticsProvider
implements IStatisticsProvider {
    public static final String EXTENTION_POINT_ID = "com.indy.ui.custom.out.statisticsContribution";
    private static final String definitionFileURI = "filePath";
    private static final String ENCODING = "UTF-8";
    private Map<String, IStatisticsProvider.StatisticDefinition> statistics = new HashMap<String, IStatisticsProvider.StatisticDefinition>();

    @Override
    public Collection<IStatisticsProvider.StatisticDefinition> getStatistics() {
        return Collections.unmodifiableCollection(this.statistics.values());
    }

    @Activate
    public void activate() {
        this.init();
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENTION_POINT_ID);
        if (extensionPoint == null) {
            try {
                throw new WorkbenchException(String.format(Messages.StatisticsProvider_extension_point_error, EXTENTION_POINT_ID));
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                String contributorId = el.getContributor().getName();
                String bundlePath = el.getAttribute(definitionFileURI);
                Bundle bundle = Platform.getBundle((String)contributorId);
                URL url = bundle.getEntry(bundlePath);
                if (url == null) {
                    throw new Exception(String.format(Messages.StatisticsProvider_extension_point_invalid_bundlepath, bundlePath, contributorId));
                }
                Properties p = new Properties();
                try {
                    Throwable throwable = null;
                    Iterator<Object> iterator = null;
                    try (InputStreamReader isr = new InputStreamReader(url.openStream(), ENCODING);){
                        p.load(isr);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new Exception(String.format(Messages.StatisticsProvider_extension_point_readfile_error, bundlePath, contributorId), ex);
                }
                for (Object o : p.keySet()) {
                    String key = (String)o;
                    String val = p.getProperty(key);
                    IStatisticsProvider.StatisticDefinition def = this.statistics.get(val);
                    if (def != null) {
                        StatusManager.getManager().handle((IStatus)new Status(2, "com.indy.ui.custom.out", String.format(Messages.StatisticsProvider_warning_statistic_already_defined, key, String.valueOf(contributorId) + "/" + bundlePath, def.getContribution())), 1);
                        continue;
                    }
                    String[] s = val.split(",");
                    IStatisticsProvider.Aggregation[] aggregations = new IStatisticsProvider.Aggregation[s.length];
                    IntStream.range(0, s.length).forEach(i -> {
                        IStatisticsProvider.Aggregation aggregation = IStatisticsProvider.Aggregation.valueOf(s[i].trim());
                    });
                    this.statistics.put(key, new IStatisticsProvider.StatisticDefinition(key, String.valueOf(contributorId) + "/" + bundlePath, aggregations));
                }
            }
            catch (Exception ex) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.custom.out", String.format(Messages.StatisticsProvider_error_statistic_creation, EXTENTION_POINT_ID), (Throwable)ex), 1);
            }
            ++n2;
        }
    }
}

