/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.tools;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.MultipleEditorInputProvider;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationHandle;

public class ApplicationHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningWorkbench() {
        try {
            ServiceReference[] ref = Activator.getDefault().getBundle().getBundleContext().getAllServiceReferences(ApplicationHandle.class.getName(), "(application.descriptor=org.eclipse.ui.ide.workbench)");
            if (ref != null && ref.length > 0) {
                return true;
            }
            try {
                PlatformUI.getWorkbench();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IFile getSelectedFile(ExecutionEvent event) {
        if ("org.eclipse.ui.navigator.ProjectExplorer".equals(HandlerUtil.getActivePartId((ExecutionEvent)event))) {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            Object selected = ((IStructuredSelection)activePart.getSite().getSelectionProvider().getSelection()).getFirstElement();
            if (selected instanceof IFile && ("proc".equals(((IFile)selected).getFileExtension()) || "map".equals(((IFile)selected).getFileExtension()))) {
                return (IFile)selected;
            }
        } else {
            EObject o;
            Object epModel;
            Object selected = null;
            IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            MultipleEditorInputProvider multiProvider = (MultipleEditorInputProvider)activePart.getAdapter(MultipleEditorInputProvider.class);
            selected = multiProvider != null ? multiProvider.getMainDiagramEditPart() : ((IStructuredSelection)activePart.getSite().getSelectionProvider().getSelection()).getFirstElement();
            if (selected instanceof EditPart && (epModel = ((EditPart)selected).getModel()) instanceof View && (o = ((View)epModel).getElement()) != null) {
                String fileID = CacheHelper.extractFileID((String)o.eResource().getURI().fragment());
                ICacheService s = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                if (fileID == null) {
                    fileID = s.getSourceId(o.eResource().getURI());
                }
                if (fileID != null && s != null) {
                    return Util.convertEMFURIToFile(s.findResourceURIByFileId(fileID));
                }
            }
        }
        return null;
    }

    public static boolean saveDirtyEditorFor(final IFile r) {
        if (r == null) {
            return false;
        }
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean res = PlatformUI.getWorkbench().saveAll((IShellProvider)w, (IRunnableContext)w, new ISaveableFilter(){

            public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
                IFile file = ResourceUtil.getFile((Object)saveable);
                if (r.equals((Object)file)) {
                    return true;
                }
                int i = 0;
                while (i < containingParts.length) {
                    IWorkbenchPart workbenchPart = containingParts[i];
                    if (workbenchPart instanceof IEditorPart) {
                        IEditorPart editorPart = (IEditorPart)workbenchPart;
                        IFile f = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                        String extension = null;
                        if (f != null) {
                            extension = f.getFileExtension();
                        } else if (editorPart.getEditorInput() instanceof URIEditorInput) {
                            extension = ((URIEditorInput)editorPart.getEditorInput()).getURI().fileExtension();
                        }
                        if (extension == null || !extension.equals("proc") && !extension.equals("map") && !extension.equals("proc_diagram") && !extension.equals("map_diagram")) {
                            return false;
                        }
                        try {
                            file = ResourceUtil.getFile((IEditorInput)editorPart.getEditorInput());
                            if (file == null && editorPart.getEditorInput() instanceof URIEditorInput && ((URIEditorInput)editorPart.getEditorInput()).getURI().isPlatformResource()) {
                                file = Util.convertEMFURIToFile(((URIEditorInput)editorPart.getEditorInput()).getURI().trimFragment());
                            }
                            if (r.equals((Object)file)) {
                                return true;
                            }
                        }
                        catch (Exception ex) {
                            Activator.getDefault().getLog().log((IStatus)new Status(0, "com.indy.ui.custom.out", String.valueOf(Messages.ApplicationHelper_7) + editorPart.getEditorInput(), (Throwable)ex));
                            return false;
                        }
                    }
                    ++i;
                }
                return false;
            }
        }, true);
        if (res) {
            IEditorPart p = ResourceUtil.findEditor((IWorkbenchPage)w.getActivePage(), (IFile)r);
            res = p == null ? true : !p.isDirty();
        }
        return res;
    }
}

