/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.tools;

import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CustomCompositeImageDescriptor
extends CompositeImageDescriptor {
    public static final CustomCompositeImageDescriptor INSTANCE = new CustomCompositeImageDescriptor();
    public static final URL LOCKER_IMAGE_URL;
    private String baseImageKey;
    private String decorationImageKey;
    private Point size;
    private ImageRegistry reg = new ImageRegistry();

    static {
        URL im = null;
        try {
            im = new URL("platform:/plugin/com.indy.environment/icons/full/obj10x10/locker.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOCKER_IMAGE_URL = im;
    }

    private CustomCompositeImageDescriptor() {
    }

    public void setImages(URL baseImageURL, URL decorationImageURL) {
        if (this.reg.get(baseImageURL.toString()) == null) {
            this.reg.put(baseImageURL.toString(), ImageDescriptor.createFromURL((URL)baseImageURL).createImage());
        }
        if (this.reg.get(decorationImageURL.toString()) == null) {
            this.reg.put(decorationImageURL.toString(), ImageDescriptor.createFromURL((URL)decorationImageURL).createImage());
        }
        this.baseImageKey = baseImageURL.toString();
        this.decorationImageKey = decorationImageURL.toString();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.reg.get(this.baseImageKey).getImageData(), 0, 0);
        ImageData overlayImageData = this.reg.get(this.decorationImageKey).getImageData();
        int xValue = 0;
        int yValue = 0;
        this.drawImage(overlayImageData, xValue, yValue);
    }

    protected Point getSize() {
        return this.size;
    }

    public Image createImage() {
        String key = String.valueOf(this.baseImageKey) + "/" + this.decorationImageKey;
        if (this.reg.get(key) != null) {
            return this.reg.get(key);
        }
        Rectangle r = this.reg.get(this.baseImageKey).getBounds();
        this.size = new Point(r.width, r.height);
        Image i = super.createImage();
        this.reg.put(key, i);
        return i;
    }

    public void setImages(IConfigurationElement editorDescriptionConfig, URL decorationImageURL) {
        String s = editorDescriptionConfig.getAttribute("icon");
        try {
            this.setImages(new URL("platform:/plugin/" + editorDescriptionConfig.getContributor().getName() + "/" + s), decorationImageURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

