/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.udf.ui.internal;

import com.indy.ui.custom.out.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.services.registry.UDFParameter;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UDFRegistryUI {
    public static ImageDescriptor udfIconURI;
    public static ImageDescriptor udfLibIconURI;
    private TreeViewer viewer;
    private Hyperlink modelFile;
    private URI selectionResourceURI;
    private List<Listener> listeners = new ArrayList<Listener>();
    FormToolkit toolkit;
    private Text name;
    private Text desc;
    private Text paramDesc;
    private TableViewer parameters;
    private TableViewer products;
    private WeakReference<UDFNode> currentNode;
    private IRegistryService registryService;

    static {
        try {
            udfIconURI = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.edit/icons/full/custom/16x16/UF-Function16x16-1.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            udfLibIconURI = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.edit/icons/full/custom/16x16/UF-Library16x16-1.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public UDFRegistryUI(FormToolkit formToolkit) {
        this.toolkit = formToolkit;
        this.registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    protected void createMasterPart(Composite parent) {
        Section registrySection = this.toolkit.createSection(parent, 4160);
        Composite registryComposite = this.toolkit.createComposite((Composite)registrySection);
        registryComposite.setLayout((Layout)new GridLayout());
        this.viewer = new TreeViewer(registryComposite, 2816);
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object o = ((TreeNode)element).getValue();
                if (o instanceof UDF) {
                    return ((UDF)o).getName();
                }
                return (String)o;
            }

            public Image getImage(Object element) {
                if (element instanceof UDFNode) {
                    return ExtendedImageRegistry.getInstance().getImage((Object)udfIconURI);
                }
                return ExtendedImageRegistry.getInstance().getImage((Object)udfLibIconURI);
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = ((LabelProvider)((TreeViewer)viewer).getLabelProvider()).getText(e1);
                String s2 = ((LabelProvider)((TreeViewer)viewer).getLabelProvider()).getText(e2);
                return s1.compareTo(s2);
            }
        });
        ((GridData)this.viewer.getControl().getLayoutData()).heightHint = 380;
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                    if (!(o instanceof UDFNode)) continue;
                    UDFRegistryUI.this.notifySelectionChanged((UDF)((UDFNode)((Object)o)).getValue());
                    break;
                }
            }
        });
        registrySection.setClient((Control)registryComposite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (o instanceof UDFNode) {
                        UDFRegistryUI.this.fillDetails((UDF)((TreeNode)o).getValue());
                        UDFRegistryUI.this.currentNode = new WeakReference<UDFNode>((UDFNode)((Object)o));
                    } else {
                        UDFRegistryUI.this.fillDetails(null);
                    }
                    Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selected instanceof UDFNode) {
                        selected = ((TreeNode)selected).getValue();
                        String fileID = ((UDF)selected).getRegistrationKey().getProviderFileID();
                        ICacheService cache = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
                        if (cache != null) {
                            UDFRegistryUI.this.selectionResourceURI = cache.findResourceURIByFileId(fileID);
                            if (UDFRegistryUI.this.selectionResourceURI != null) {
                                StringBuffer l = new StringBuffer();
                                int i = 1;
                                while (i < UDFRegistryUI.this.selectionResourceURI.segmentCount()) {
                                    if (l.length() > 0) {
                                        l.append("/");
                                    }
                                    l.append(URI.decode((String)UDFRegistryUI.this.selectionResourceURI.segment(i)));
                                    ++i;
                                }
                                UDFRegistryUI.this.modelFile.setText(l.toString());
                                UDFRegistryUI.this.modelFile.setToolTipText(Messages.UDFRegistryUI_3);
                            } else {
                                UDFRegistryUI.this.modelFile.setText("");
                                UDFRegistryUI.this.modelFile.setToolTipText(null);
                            }
                            UDFRegistryUI.this.modelFile.getParent().layout(true);
                        }
                    }
                }
            }
        });
        this.refresh();
    }

    public void refresh() {
        IRegistryService.IRegistry reg = this.registryService.getRegistry(UDF.class);
        ArrayList udfs = new ArrayList(reg.getAll());
        TreeNode[] input = new TreeNode[udfs.size()];
        HashMap<String, TreeNode> libsNodes = new HashMap<String, TreeNode>();
        int cc = 0;
        for (UDF udf : udfs) {
            UDFNode n = new UDFNode(udf);
            TreeNode parent = (TreeNode)libsNodes.get(((UDF.UDFKey)udf.getRegistrationKey()).getLibraryName());
            if (parent == null) {
                parent = new TreeNode((Object)((UDF.UDFKey)udf.getRegistrationKey()).getLibraryName());
                libsNodes.put(((UDF.UDFKey)udf.getRegistrationKey()).getLibraryName(), parent);
                input[cc++] = n;
            }
            n.setParent(parent);
            if (parent.getChildren() != null) {
                TreeNode[] children = Arrays.copyOf(parent.getChildren(), parent.getChildren().length + 1);
                children[children.length - 1] = n;
                parent.setChildren(children);
                continue;
            }
            parent.setChildren(new TreeNode[]{n});
        }
        input = libsNodes.values().toArray(new TreeNode[libsNodes.size()]);
        this.viewer.setInput((Object)input);
    }

    private void notifySelectionChanged(UDF udf) {
        for (Listener l : this.listeners) {
            l.handleUDFSelected(udf);
        }
    }

    public Control createControl(Composite parent) {
        Composite main = this.toolkit.createComposite(parent);
        main.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (UDFRegistryUI.this.toolkit != null) {
                    UDFRegistryUI.this.toolkit.dispose();
                }
            }
        });
        main.setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm(main, 256);
        this.toolkit.adapt((Composite)sash);
        sash.setLayoutData((Object)new GridData(1808));
        this.createMasterPart((Composite)sash);
        this.createDetailsContents((Composite)sash);
        sash.setWeights(new int[]{1, 2});
        Composite c = this.toolkit.createComposite(main);
        c.setLayoutData((Object)new GridData(4, 1, false, true));
        c.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(c, Messages.UDFRegistryUI_5).setLayoutData((Object)new GridData(4, 1, false, false));
        this.modelFile = this.toolkit.createHyperlink(c, "", 64);
        this.modelFile.setLayoutData((Object)new GridData(4, 1, true, false));
        this.modelFile.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(UDFRegistryUI.this.selectionResourceURI), "com.stambia.md.presentation.MdEditorID");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        return sash;
    }

    protected void createDetailsContents(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        Composite main = this.toolkit.createComposite(parent);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        Label l = this.toolkit.createLabel(main, Messages.UDFRegistryUI_8);
        GridDataFactory.swtDefaults().applyTo((Control)l);
        this.name = this.toolkit.createText(main, "");
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.name);
        l = this.toolkit.createLabel(main, Messages.UDFRegistryUI_10);
        GridDataFactory.swtDefaults().applyTo((Control)l);
        this.desc = this.toolkit.createText(main, "", 2626);
        this.desc.setEditable(false);
        GridDataFactory.fillDefaults().minSize(-1, 100).span(1, 2).align(4, 4).grab(true, true).hint(-1, 100).applyTo((Control)this.desc);
        Composite paramC = this.toolkit.createComposite(main, 0);
        paramC.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 100).span(2, 1).applyTo((Control)paramC);
        l = this.toolkit.createLabel(paramC, Messages.UDFRegistryUI_12);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 1).applyTo((Control)l);
        l = this.toolkit.createLabel(paramC, Messages.UDFRegistryUI_13);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)l);
        this.parameters = new TableViewer(paramC, 68352);
        this.parameters.getControl().setLayoutData((Object)new TableWrapData());
        this.parameters.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.parameters.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((UDFParameter)element).getName();
            }
        });
        this.parameters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String s;
                String string = s = UDFRegistryUI.this.parameters.getSelection().isEmpty() ? null : ((UDFParameter)((IStructuredSelection)UDFRegistryUI.this.parameters.getSelection()).getFirstElement()).getDescription();
                if (s == null) {
                    UDFRegistryUI.this.paramDesc.setText("");
                } else {
                    UDFRegistryUI.this.paramDesc.setText(s);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).hint(new Point(150, -1)).applyTo(this.parameters.getControl());
        this.paramDesc = this.toolkit.createText(paramC, "", 2114);
        this.paramDesc.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.paramDesc);
        Composite implC = this.toolkit.createComposite(main, 0);
        implC.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 100).span(2, 1).applyTo((Control)implC);
        l = this.toolkit.createLabel(implC, Messages.UDFRegistryUI_16);
        GridDataFactory.fillDefaults().grab(false, false).span(2, 1).align(4, 1).applyTo((Control)l);
        this.products = new TableViewer(implC, 68352);
        this.products.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.products.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).align(4, 4).applyTo(this.products.getControl());
    }

    void fillDetails(UDF udf) {
        if (udf == null) {
            this.name.getParent().setVisible(false);
        } else {
            this.name.getParent().setVisible(true);
            this.name.setText(((UDF.UDFKey)udf.getRegistrationKey()).getFunctionFullName());
            this.desc.setText(udf.getDescription() == null ? "" : udf.getDescription());
            this.parameters.setInput((Object)udf.getParameters());
            this.products.setInput((Object)udf.getProductCodes());
            this.paramDesc.setText("");
        }
    }

    public static interface Listener {
        public void handleUDFSelected(UDF var1);
    }

    protected static class UDFNode
    extends TreeNode {
        public UDFNode(UDF value) {
            super((Object)value);
        }
    }
}

