/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.hbase.action;

import com.indy.addons.hadoop.Messages;
import com.indy.jdbc.editor.JDBCHelper;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdFactoryHelper;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public abstract class HBaseAbstractReverseAction
implements IExecute {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        try {
            this.reverse(node, 0, configuration);
        }
        catch (Exception e) {
            if (e instanceof ExecuteException) {
                throw (ExecuteException)e;
            }
            throw new ExecuteException(Messages.HBaseAbstractReverseAction_0, e);
        }
        return null;
    }

    public void reverse(MdNode node, int mode, String configuration) throws XPathExpressionException, Exception {
        this.reverse(node, mode, null, configuration);
    }

    protected void reverse(MdNode currentNode, int mode, String data, String configuration) throws XPathExpressionException, Exception {
        Connection conn = null;
        if (conn == null) {
            try {
                conn = JDBCHelper.INSTANCE.createJDBCConnection(currentNode);
            }
            catch (Exception e) {
                throw new ExecuteException(e);
            }
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(conn.getClass().getClassLoader());
            MdNode reversedParentNode = currentNode;
            if (currentNode.eContainer() instanceof MdNode) {
                reversedParentNode = (MdNode)currentNode.eContainer();
            }
            List<MdNode> nodeToReverse = this.getNodes(conn, currentNode);
            HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
            for (MdNode n : nodeToReverse) {
                TreeIterator it = n.eAllContents();
                while (it.hasNext()) {
                    EObject o = (EObject)it.next();
                    if (!(o instanceof MdNode)) continue;
                    ((MdNode)o).setSubstituteContainer(null);
                }
                reverseNodes.put(n, currentNode.getNodeByName(n.getDefType(), n.getName()));
            }
            IncrementalReverser ir = new IncrementalReverser((EObject)reversedParentNode, reverseNodes, Collections.emptyList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    abstract List<MdNode> getNodes(Connection var1, MdNode var2) throws Exception;

    public MdNode reverseNamespace(Connection conn, ResultSet rs, MdNode server, MdNode current) throws Exception {
        String schema = rs.getString("TABLE_SCHEM");
        MdNode __namespace = MdFactoryHelper.createMdNode((String)"com.stambia.hbase.namespace");
        if (server != null) {
            if (current == null) {
                current = (MdNode)server.evaluateMdNode("namespace[@physicalName='" + schema + "'][1]");
            }
            __namespace.setSubstituteContainer((EObject)server);
        } else {
            __namespace.setSubstituteContainer((EObject)current);
        }
        String tableFilter = null;
        if (current != null) {
            __namespace.setName(current.getName());
            tableFilter = current.evaluate("./@reverseTableFilter");
        } else {
            __namespace.setName(schema);
        }
        __namespace.setAttribute("physicalName", schema, false);
        List<MdNode> tables = this.reverseTables(conn, current != null ? current : __namespace, schema, tableFilter);
        __namespace.getNode().addAll(tables);
        return __namespace;
    }

    public List<MdNode> reverseNamespaces(Connection conn, MdNode server, String filter) throws Exception {
        if (filter != null && filter.trim().isEmpty()) {
            filter = null;
        }
        ResultSet rs = conn.getMetaData().getSchemas(null, filter);
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        while (rs.next()) {
            MdNode node = this.reverseNamespace(conn, rs, server, null);
            nodes.add(node);
        }
        return nodes;
    }

    protected MdNode reverseTable(Connection conn, ResultSet rs, MdNode nameSpaceNode, MdNode current) throws Exception {
        String tableNameWithNamespace = rs.getString("TABLE_SCHEM");
        String tableName = rs.getString("TABLE_NAME");
        MdNode __table = MdFactoryHelper.createMdNode((String)"com.stambia.hbase.datastore");
        if (nameSpaceNode != null) {
            if (current == null) {
                this.logger.fine(tableName);
                try {
                    current = (MdNode)nameSpaceNode.evaluateMdNode("table[@physicalName='" + tableName + "'][1]");
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected exception", e);
                }
            }
            __table.setSubstituteContainer((EObject)nameSpaceNode);
        } else {
            __table.setSubstituteContainer((EObject)current);
        }
        if (current != null) {
            __table.setName(current.getName());
        } else {
            __table.setName(tableName);
        }
        __table.setAttribute("physicalName", tableName, false);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(" ==================== Reverse " + tableNameWithNamespace + "====================");
        }
        this.reverseFamilies(conn, __table, tableNameWithNamespace, tableName);
        return __table;
    }

    protected List<MdNode> reverseTables(Connection conn, MdNode nameSpaceNode, String namespaceName, String filter) throws Exception {
        if (filter != null && filter.trim().isEmpty()) {
            filter = null;
        }
        ResultSet rs = conn.getMetaData().getTables(null, namespaceName, filter, null);
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        while (rs.next()) {
            MdNode node = this.reverseTable(conn, rs, nameSpaceNode, null);
            nodes.add(node);
        }
        return nodes;
    }

    protected void reverseFamilies(Connection connection, MdNode nodeTable, String namespaceName, String tableName) throws Exception {
        ResultSet rs = connection.getMetaData().getColumns(null, namespaceName, tableName, null);
        HashMap<String, MdNode> familiesNodes = new HashMap<String, MdNode>();
        HashMap<String, Integer> familiesPosition = new HashMap<String, Integer>();
        int k = 1;
        int i = 1;
        while (rs.next()) {
            String familyName = rs.getString("HBASE_FAMILY_NAME");
            MdNode __family = (MdNode)familiesNodes.get(familyName);
            if (familyName == null) {
                this.reverseColumns(rs, nodeTable, i);
                continue;
            }
            if (__family == null) {
                __family = MdFactoryHelper.createMdNode((String)"com.stambia.hbase.family");
                __family.setSubstituteContainer((EObject)nodeTable);
                __family.setName(familyName);
                __family.setAttribute("physicalName", familyName, false);
                __family.setPosition(new BigInteger(String.valueOf(k++)));
                nodeTable.getNode().add((Object)__family);
                familiesNodes.put(familyName, __family);
            } else {
                i = (Integer)familiesPosition.get(familyName);
                ++i;
            }
            this.reverseColumns(rs, __family, i);
            familiesPosition.put(familyName, i);
        }
    }

    private void reverseColumns(ResultSet rs, MdNode __family, int i) throws SQLException {
        MdNode columnNode = MdFactoryHelper.createMdNode((String)"com.stambia.hbase.column");
        columnNode.setName(rs.getString("COLUMN_NAME"));
        __family.getNode().add((Object)columnNode);
        String isRowKey = rs.getString("HBASE_IS_ROW_KEY");
        if (isRowKey != null && isRowKey.equals("1")) {
            columnNode.setAttribute("isRowKey", "true", false);
        }
        columnNode.setAttribute("physicalName", columnNode.getName(), false);
        columnNode.setPosition(new BigInteger(String.valueOf(i)));
    }
}

