/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch.client;

import com.indy.engine.common.tools.Authentication;
import com.indy.engine.common.tools.SslStore;
import com.stambia.elasticsearch.client.IClient;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public abstract class HttpRestClient
implements IClient {
    protected RestHighLevelClient client;
    private static final String CREDENTIAL_SEPARATOR = ":";
    private static final String API_KEY_PREFIX = "ApiKey ";
    private static final String CREDENTIAL_HEADER = "Authorization";
    private static final TrustStrategy DISABLED_CERTIFICATE_VALIDATION = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    };

    protected static RestClientBuilder getRestClientBuilder(String httpUrl, Authentication authentication, SslStore sslStore) throws Exception {
        String[] addresses = httpUrl.split(",");
        int addressesNumber = addresses.length;
        HttpHost[] httpHosts = new HttpHost[addressesNumber];
        int addressIndex = 0;
        String path = null;
        String[] stringArray = addresses;
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            HttpHost httpHost;
            String stringHttpUrl = stringArray[n2];
            URL url = new URL(stringHttpUrl);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            httpHosts[addressIndex] = httpHost = new HttpHost(host, port, protocol);
            path = url.getPath();
            ++addressIndex;
            ++n2;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        final HashSet<BasicHeader> defaultHeaders = new HashSet<BasicHeader>();
        final boolean useApiKey = authentication.useApiKey();
        String id = authentication.getId();
        String secret = authentication.getSecret();
        if (useApiKey) {
            String credential = id + CREDENTIAL_SEPARATOR + secret;
            String apiKeyAuth = Base64.getEncoder().encodeToString(credential.getBytes(StandardCharsets.UTF_8));
            String headerValue = API_KEY_PREFIX + apiKeyAuth;
            defaultHeaders.add(new BasicHeader(CREDENTIAL_HEADER, headerValue));
        } else {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(id, secret));
        }
        SSLContext sslContext = HttpRestClient.getSslContext(sslStore);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider, sslContext){
            private final /* synthetic */ CredentialsProvider val$credentialsProvider;
            private final /* synthetic */ SSLContext val$sslContext;
            {
                this.val$credentialsProvider = credentialsProvider;
                this.val$sslContext = sSLContext;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                httpClientBuilder = useApiKey ? httpClientBuilder.setDefaultHeaders((Collection)defaultHeaders) : httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                if (this.val$sslContext != null) {
                    httpClientBuilder = httpClientBuilder.setSSLContext(this.val$sslContext);
                }
                return httpClientBuilder;
            }
        });
        if (path != null && path.length() > 0) {
            restClientBuilder.setPathPrefix(path);
        }
        return restClientBuilder;
    }

    protected static SSLContext getSslContext(SslStore sslStore) throws Exception {
        SSLContextBuilder sslBuilder = null;
        if (sslStore != null) {
            TrustStrategy trustStrategy = sslStore.isCertificateValidationEnabled() ? null : DISABLED_CERTIFICATE_VALIDATION;
            SslStore.Store trustStoreParam = sslStore.getTrustStore();
            KeyStore trustStore = trustStoreParam.getStore();
            sslBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, trustStrategy);
            SslStore.Store keyStoreParams = sslStore.getKeyStore();
            KeyStore keyStore = keyStoreParams.getStore();
            String keyStorePass = keyStoreParams.getPassword();
            if (keyStorePass != null) {
                sslBuilder = sslBuilder.loadKeyMaterial(keyStore, keyStorePass.toCharArray());
            }
        }
        SSLContext sslContext = sslBuilder != null ? sslBuilder.build() : null;
        return sslContext;
    }
}

