/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.elasticsearch.client;

import com.stambia.elasticsearch.client.IClient;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public abstract class TransportClient
implements IClient {
    protected PreBuiltTransportClient client;

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws Exception {
        return (SearchResponse)this.client.search(searchRequest).get();
    }

    @Override
    public SearchResponse scroll(SearchResponse searchResponse) throws Exception {
        String scrollId = searchResponse.getScrollId();
        if (scrollId != null) {
            searchResponse = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(timeValue).get();
        }
        return searchResponse;
    }

    @Override
    public BulkResponse bulk(BulkRequest bulkRequest) throws Exception {
        return (BulkResponse)this.client.bulk(bulkRequest).get();
    }

    @Override
    public MultiGetResponse multiGet(MultiGetRequest multiGetRequest) throws Exception {
        return (MultiGetResponse)this.client.multiGet(multiGetRequest).get();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

