/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.ValueMetaData;
import com.stambia.jdbc.common.parser.MetadataStandardVisitor;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.Insert;

public class InsertMetaData
extends MetadataStandardVisitor {
    Insert ins;
    List<String> columnNames;
    List<ValueMetaData> lstValue = new ArrayList<ValueMetaData>();
    private TableMetaData tableMetaData;

    public static void main(String[] args) {
        try {
            String statement = "INSERT INTO mytable (col1, col2, col3) VALUES (?, 'sadfsd', 234)";
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            Insert insert = (Insert)parserManager.parse((Reader)new StringReader(statement));
            InsertMetaData.assertEquals("mytable", insert.getTable().getName());
            InsertMetaData.assertEquals(3, insert.getColumns().size());
            InsertMetaData.assertEquals("col1", ((Column)insert.getColumns().get(0)).getColumnName());
            InsertMetaData.assertEquals("col2", ((Column)insert.getColumns().get(1)).getColumnName());
            InsertMetaData.assertEquals("col3", ((Column)insert.getColumns().get(2)).getColumnName());
            InsertMetaData.assertEquals(3, ((ExpressionList)insert.getItemsList()).getExpressions().size());
            InsertMetaData.assertTrue(((ExpressionList)insert.getItemsList()).getExpressions().get(0) instanceof JdbcParameter);
            InsertMetaData.assertEquals("sadfsd", ((StringValue)((ExpressionList)insert.getItemsList()).getExpressions().get(1)).getValue());
            InsertMetaData.assertEquals(234L, ((LongValue)((ExpressionList)insert.getItemsList()).getExpressions().get(2)).getValue());
            InsertMetaData.assertEquals(statement, "" + insert);
            statement = "INSERT INTO myschema.mytable VALUES (?, ?, 2.3)";
            insert = (Insert)parserManager.parse((Reader)new StringReader(statement));
            InsertMetaData.assertEquals("myschema.mytable", insert.getTable().getWholeTableName());
            InsertMetaData.assertEquals(3, ((ExpressionList)insert.getItemsList()).getExpressions().size());
            InsertMetaData.assertTrue(((ExpressionList)insert.getItemsList()).getExpressions().get(0) instanceof JdbcParameter);
            InsertMetaData.assertEquals(2.3, ((DoubleValue)((ExpressionList)insert.getItemsList()).getExpressions().get(2)).getValue(), 0.0);
            InsertMetaData.assertEquals(statement, "" + insert);
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
    }

    InsertMetaData(Insert ins) {
        ins.getItemsList().accept((ItemsListVisitor)this);
        this.tableMetaData = TableMetaData.toTableMetaData(ins.getTable());
        List cols = ins.getColumns();
        if (cols != null) {
            for (Column col : cols) {
                col.setColumnName(col.getColumnName().replace("\"", "").replace("[", "").replace("]", ""));
            }
        }
        this.ins = ins;
    }

    private static void assertEquals(double d, double value, double e) {
    }

    private static void assertEquals(long i, long value) {
        System.out.println(i);
        if (i != value) {
            System.out.println(value);
        }
    }

    private static void assertTrue(boolean b) {
        System.out.println(b);
    }

    private static void assertEquals(int i, int size) {
        System.out.println(i);
        if (i != size) {
            System.out.println(size);
        }
    }

    private static void assertEquals(String string, String name) {
        System.out.print(string);
        if (!string.equals(name)) {
            System.out.print("!=" + name);
        }
        System.out.println();
    }

    public List<String> getColumnNames() {
        List cols = this.ins.getColumns();
        if (cols != null) {
            this.columnNames = new ArrayList<String>();
            for (Column col : cols) {
                this.columnNames.add(col.getColumnName());
            }
        }
        return this.columnNames;
    }

    public int getColumnsNumber() {
        if (this.ins.getColumns() != null) {
            return this.ins.getColumns().size();
        }
        return 0;
    }

    public List<ValueMetaData> getLstValue() {
        return this.lstValue;
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.lstValue.add(new ValueMetaData());
    }

    @Override
    public void visit(StringValue stringValue) {
        this.lstValue.add(new ValueMetaData(stringValue.getValue(), 12));
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.lstValue.add(new ValueMetaData(doubleValue.getValue(), 8));
    }

    @Override
    public void visit(LongValue longValue) {
        this.lstValue.add(new ValueMetaData(longValue.getValue(), 4));
    }

    @Override
    public void visit(DateValue dateValue) {
        this.lstValue.add(new ValueMetaData(dateValue.getValue().toString(), 91));
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.lstValue.add(new ValueMetaData(timestampValue.getValue(), 93));
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.lstValue.add(new ValueMetaData(timeValue.getValue(), 92));
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }
}

