/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.excel;

import com.stambia.jdbc.common.tools.ColumnNameGeneratorUtil;
import com.stambia.jdbc.driver.excel.Messages;
import com.stambia.jdbc.driver.xls.internal.IWorkbookControler;
import com.stambia.jdbc.driver.xls.xls.XlsConnection;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.part.CustomDefinedName;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class XLSXDriver
implements Driver {
    static final String urlFormat = "jdbc:semarchy:excel://";
    static final String legacyUrlFormat = "jdbc:stambia:excel://";
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 111;
    public static final String P_COMPUTE_FORMULA = "recomputeFormula";
    public static final String P_COLUMN_NAMING_STYLE = "columnNameStyle";
    public static final String P_METADATA_SHEET_NAME = "metaSheetName";
    public static final String P_METADATA_FILE_PATH = "metaFilePath";
    public static final String P_FORCE_COLUMN_SIZE = "forceColumnSize";
    public static final String P_DEFINED_NAME = "definedNamed";
    public static final String P_FORCE_OBJECT_CASE = "forceColumnCase";
    public static final String P_USER = "user";
    public static final String P_PASSWORD = "password";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            if (((String)url).startsWith(legacyUrlFormat)) {
                url = ((String)url).replace(legacyUrlFormat, urlFormat);
            }
            if (!((String)url).startsWith(urlFormat)) {
                throw new Exception(Messages.getString("XLSXDriver.1"));
            }
            URL netUrl = new URL((String)(url = "file:" + ((String)url).replace("\\", "/").replace(urlFormat, "")));
            String pathString = netUrl.getPath();
            if (pathString == null || pathString.isEmpty()) {
                throw new Exception(Messages.getString("XLSXDriver.2") + Messages.getString("XLSXDriver.3") + Messages.getString("XLSXDriver.4") + urlFormat + Messages.getString("XLSXDriver.5") + P_COMPUTE_FORMULA + Messages.getString("XLSXDriver.6"));
            }
            String pathTypeStr = info.getProperty("pathType", null);
            IWorkbookControler.PATH_TYPE pathType = null;
            pathType = null != pathTypeStr ? IWorkbookControler.PATH_TYPE.valueOf(pathTypeStr) : (pathString.toUpperCase().endsWith(".XLSX") ? IWorkbookControler.PATH_TYPE.FILE : IWorkbookControler.PATH_TYPE.FOLDER);
            File pathFile = new File(pathString);
            if (pathFile.exists()) {
                if (pathType == IWorkbookControler.PATH_TYPE.FOLDER) {
                    if (!pathFile.isDirectory()) {
                        throw new XlsException(Messages.getString("XLSXDriver.pathError0") + pathString + Messages.getString("XLSXDriver.pathError1") + Messages.getString("XLSXDriver.pathError2.0") + Messages.getString("XLSXDriver.pathError3"));
                    }
                } else if (pathType == IWorkbookControler.PATH_TYPE.FILE && !pathFile.isFile()) {
                    throw new XlsException(Messages.getString("XLSXDriver.pathError0") + pathString + Messages.getString("XLSXDriver.pathError1") + Messages.getString("XLSXDriver.pathError2.1") + Messages.getString("XLSXDriver.pathError3"));
                }
            } else {
                throw new XlsException(Messages.getString("XLSXDriver.pathError0") + pathString + Messages.getString("XLSXDriver.pathError4"));
            }
            String catalog = null;
            File catalogsFolder = null;
            if (null != pathType) {
                switch (pathType) {
                    case FILE: {
                        catalog = pathFile.getName().toString();
                        catalogsFolder = pathFile.getParentFile();
                        break;
                    }
                    case FOLDER: {
                        catalogsFolder = pathFile;
                        break;
                    }
                    case LEGACY: {
                        boolean isFile = pathString.toUpperCase().endsWith(".XLSX");
                        catalogsFolder = isFile ? pathFile.getParentFile() : pathFile;
                        break;
                    }
                }
            }
            boolean recomputeFormula = true;
            Integer columnSize = null;
            String columnNameStyle = null;
            ColumnNameGeneratorUtil.Case forceColumnCase = null;
            boolean lockUntilConnectionIsClose = false;
            HashMap<String, Map<String, CustomDefinedName>> definedNames = new HashMap<String, Map<String, CustomDefinedName>>();
            for (String s : netUrl.getQuery().split("&")) {
                if (s.startsWith("recomputeFormula=")) {
                    recomputeFormula = Boolean.valueOf(s.replace("recomputeFormula=", ""));
                }
                if (s.startsWith("columnNameStyle=")) {
                    columnNameStyle = s.replace("columnNameStyle=", "");
                }
                if (s.startsWith("forceColumnCase=")) {
                    forceColumnCase = ColumnNameGeneratorUtil.Case.valueOf(s.replace("forceColumnCase=", ""));
                }
                if (s.startsWith("forceColumnSize=")) {
                    columnSize = Integer.parseInt(s.replace("forceColumnSize=", ""));
                }
                if (!s.startsWith("definedNamed:")) continue;
                String definedNameToParse = s.replace("definedNamed:", "");
                String sheetName = "";
                String definedName = "";
                String definedNameCatalog = "";
                Object definedNameRange = "";
                try {
                    if (definedNameToParse.startsWith("\"")) {
                        definedName = definedNameToParse.substring(1, definedNameToParse.substring(1).indexOf("\"") + 1);
                        definedNameToParse = definedNameToParse.substring(definedName.length() + 3);
                    } else {
                        definedName = definedNameToParse.substring(1, definedNameToParse.indexOf("="));
                        definedNameToParse = definedNameToParse.substring(definedName.length() + 1);
                    }
                    if (definedNameToParse.startsWith("\"")) {
                        definedNameCatalog = definedNameToParse.substring(1, definedNameToParse.substring(1).indexOf("\"") + 1);
                        definedNameToParse = definedNameToParse.substring(definedNameCatalog.length() + 3);
                    } else {
                        definedNameCatalog = definedNameToParse.substring(1, definedNameToParse.indexOf("\\."));
                        definedNameToParse = definedNameToParse.substring(definedNameCatalog.length() + 1);
                    }
                    definedNameRange = definedNameToParse.startsWith("\"") ? definedNameToParse.substring(1, definedNameToParse.length() - 1) : definedNameToParse;
                }
                catch (Exception e) {
                    throw new XlsException("Invalid defined name: " + definedNameToParse);
                }
                sheetName = ((String)definedNameRange).substring(0, ((String)definedNameRange).lastIndexOf("!"));
                if (!sheetName.endsWith("$")) {
                    throw new XlsException("Invalid table name: " + sheetName);
                }
                definedNameRange = ((String)definedNameRange).substring(0, ((String)definedNameRange).lastIndexOf("!") - 1) + ((String)definedNameRange).substring(((String)definedNameRange).lastIndexOf("!"), ((String)definedNameRange).length());
                if (definedNames.containsKey(definedNameCatalog)) {
                    ((Map)definedNames.get(definedNameCatalog)).put(definedName, new CustomDefinedName(definedName, (String)definedNameRange));
                    continue;
                }
                HashMap<String, CustomDefinedName> catalogDefinedNameMap = new HashMap<String, CustomDefinedName>();
                catalogDefinedNameMap.put(definedName, new CustomDefinedName(definedName, (String)definedNameRange));
                definedNames.put(definedNameCatalog, catalogDefinedNameMap);
            }
            ColumnNameGeneratorUtil.Style style = columnNameStyle != null ? ColumnNameGeneratorUtil.Style.valueOf(columnNameStyle) : null;
            return new XlsConnection(catalog, catalogsFolder, info, recomputeFormula, style, forceColumnCase, null, null, columnSize, lockUntilConnectionIsClose, definedNames, pathType);
        }
        catch (Exception e) {
            throw new XlsException("The url " + (String)url + " is not valid : " + e.getMessage());
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        DriverManager.println("StambiaXLSDriver.acceptURL: " + url);
        return url.startsWith(urlFormat) || url.startsWith(legacyUrlFormat);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 111;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new XLSXDriver());
        }
        catch (SQLException E) {
            throw new RuntimeException(Messages.getString("XLSXDriver.0"));
        }
    }
}

