/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xls.internal;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.tools.ColumnNameGeneratorUtil;
import com.stambia.jdbc.driver.xls.internal.Messages;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.part.CustomDefinedName;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.logging.log4j.LogManager;

public interface IWorkbookControler {
    public void truncateSheet(String var1, String var2) throws XlsException;

    public List<String> getSheetNames() throws XlsException;

    public int insertRow(XMLInputFactory var1, XMLOutputFactory var2, String var3, HashMap<Integer, Object> var4, HashMap<Integer, Integer> var5) throws XlsException;

    public Map<Integer, String> evaluatePropertyFieldsValues(String var1, Set<Integer> var2, int var3) throws XlsException;

    public String evaluateCellValue(String var1, int var2, int var3) throws XlsException;

    public HashMap<String, Integer> getColumnsPosition(String var1) throws XlsException;

    public void saveWorkbook() throws XlsException;

    public String getCatalogsFolderAbsolutePath();

    public boolean supportSaveMOreThanOnce() throws XlsException;

    public void dispose();

    public boolean createSheet(String var1, String[] var2) throws XlsException;

    public ColumnNameGeneratorUtil.Style getColumnNamingStyle();

    public ColumnType getColumnType(String var1, String var2) throws XlsException;

    public void createTable(String var1, List<ColumnMetaData> var2) throws XlsException;

    public void releaseConnectionIfNeeded();

    public void lock();

    public void unLock();

    public boolean is1904DateSystem() throws XlsException;

    public List<String> getColumnNamesFromSheet(String var1, String var2) throws XlsException;

    public List<String> getColumnNamesFromDefinedName(String var1, String var2) throws XlsException;

    public Set<String> getDefinedNames() throws XlsException;

    public void setCatalog(String var1) throws XlsException;

    public String getCatalog();

    public List<String> getCatalogs();

    public List<String> getColumnNamesFromDelimiter(String var1, Integer var2, Integer var3, Integer var4) throws XlsException;

    public Set<String> getCustomDefinedNames() throws XlsException;

    public List<String> getColumnNamesFromCustomDefinedName(String var1, String var2) throws XlsException;

    public CustomDefinedName getCustomDefinedName(String var1) throws XlsException;

    public String getColumnSize();

    public Integer[] getTableDelimiter(String var1, boolean var2) throws XlsException;

    public void insertRows(XMLInputFactory var1, XMLOutputFactory var2, String var3, String var4, LinkedList<HashMap<Integer, Object>> var5, LinkedList<HashMap<Integer, Integer>> var6) throws XlsException;

    public void changeCatalog(String var1) throws XlsException;

    public void createHeaderIfNeeded(XMLInputFactory var1, XMLOutputFactory var2, String var3, String var4, List<String> var5) throws XlsException;

    public PATH_TYPE getPathType();

    public Set<String> getDefinedTableNames() throws XlsException;

    public List<String> getColumnNamesFromDefinedTable(String var1) throws SQLException;

    public static class ColumnType {
        public static ColumnType DEFAULT = new ColumnType();
        private XLSNativeType nativeTypeName = XLSNativeType.TEXT;

        private ColumnType() {
        }

        private ColumnType(XLSNativeType nativeTypeName) {
            this.nativeTypeName = nativeTypeName == null ? XLSNativeType.TEXT : nativeTypeName;
        }

        public int getSqlTypeCode() {
            return this.nativeTypeName.getSqlTypeCode();
        }

        public String getSqlTypeName() {
            return this.nativeTypeName.getSqlTypeName();
        }

        public String getNativeTypeName() {
            return this.nativeTypeName.getSqlTypeName();
        }

        public static ColumnType get(String typeName) {
            XLSNativeType t = null;
            try {
                t = XLSNativeType.valueOf(typeName);
            }
            catch (IllegalArgumentException ex) {
                LogManager.getLogger(ColumnType.class).warn(Messages.getString("IWorkbookControler.0") + typeName + Messages.getString("IWorkbookControler.1"));
                t = XLSNativeType.TEXT;
            }
            return new ColumnType(t);
        }
    }

    public static enum XLSNativeType {
        CURRENCY(2, "NUMERIC"),
        DATETIME(93, "TIMESTAMP"),
        LOGICAL(-7, "BIT"),
        NUMBER(8, "DOUBLE"),
        TEXT(12, "VARCHAR");

        private int sqlTypeCode;
        private String sqlTypeName;

        private XLSNativeType(int sqlTypeCode, String sqlTypeName) {
            this.sqlTypeCode = sqlTypeCode;
            this.sqlTypeName = sqlTypeName;
        }

        public int getSqlTypeCode() {
            return this.sqlTypeCode;
        }

        public String getSqlTypeName() {
            return this.sqlTypeName;
        }
    }

    public static enum PATH_TYPE {
        FOLDER,
        FILE,
        LEGACY;


        public static Set<String> stringValues() {
            HashSet<String> values = new HashSet<String>();
            for (PATH_TYPE pathType : PATH_TYPE.values()) {
                values.add(pathType.toString());
            }
            return values;
        }
    }
}

