/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xls.xls;

import com.stambia.jdbc.common.ColumnMetaData;
import com.stambia.jdbc.common.CommonResultSet;
import com.stambia.jdbc.common.CommonResultSetMetaData;
import com.stambia.jdbc.common.RowData;
import com.stambia.jdbc.driver.excel.XLSXDriver;
import com.stambia.jdbc.driver.xls.internal.IWorkbookControler;
import com.stambia.jdbc.driver.xls.xls.Messages;
import com.stambia.jdbc.driver.xls.xls.XlsConnection;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.part.Sheet;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class XlsDatabaseMetaData
implements DatabaseMetaData {
    private XlsConnection connection;

    public XlsDatabaseMetaData(XlsConnection xlsConnection) {
        this.connection = xlsConnection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return null;
    }

    @Override
    public String getUserName() throws SQLException {
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return XLSXDriver.class.getSimpleName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "2.111";
    }

    @Override
    public String getDriverName() throws SQLException {
        return XLSXDriver.class.getSimpleName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 111;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return null;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "%";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "xlsx";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    public static String formatTableName(String tableName) {
        StringBuilder b = new StringBuilder();
        b.append(tableName);
        b.append("$");
        return b.toString();
    }

    public static String unformatTableName(String tableName) {
        if (tableName.startsWith("'")) {
            return tableName.substring(1, tableName.length() - 2);
        }
        if (tableName.endsWith("$")) {
            return tableName.substring(0, tableName.length() - 1);
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            RowData rd;
            CommonResultSet crs = new CommonResultSet();
            crs.setMetaData(new CommonResultSetMetaData(new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT"), new ColumnMetaData("TABLE_SCHEM"), new ColumnMetaData("TABLE_NAME"), new ColumnMetaData("TABLE_TYPE"), new ColumnMetaData("REMARKS"), new ColumnMetaData("TYPE_CAT"), new ColumnMetaData("TYPE_SCHEM"), new ColumnMetaData("TYPE_NAME")}));
            tableNamePattern = tableNamePattern != null ? tableNamePattern.replace("%", ".*?").replace("_", ".").replace("$", "\\$") : null;
            tableNamePattern = XlsxUtils.removeTableDelimiter(tableNamePattern);
            File fromFile = null;
            File catalogFile = null;
            if (catalog != null && !catalog.equals("NoCatalog") && !catalog.isEmpty()) {
                catalogFile = new File(catalog);
            } else if (this.connection.getControler().getPathType() == IWorkbookControler.PATH_TYPE.FOLDER) {
                catalogFile = new File(schemaPattern);
            }
            if (schemaPattern != null && !schemaPattern.isEmpty()) {
                fromFile = new File(schemaPattern);
                if (!fromFile.isAbsolute() && catalogFile != null) {
                    fromFile = new File(this.connection.getControler().getCatalogsFolderAbsolutePath(), fromFile.getPath());
                }
            } else {
                fromFile = catalogFile != null && !catalogFile.isAbsolute() ? new File(this.connection.getControler().getCatalogsFolderAbsolutePath(), catalogFile.getName()) : catalogFile;
            }
            if (!fromFile.getName().endsWith(".xlsx")) {
                fromFile = new File(fromFile + ".xlsx");
            }
            if (fromFile != null && !fromFile.exists()) {
                throw new XlsException(Messages.getString("XlsDatabaseMetaData.0") + fromFile.getName().replace(".xlsx", "") + Messages.getString("XlsDatabaseMetaData.1"));
            }
            this.connection.getControler().setCatalog(fromFile.getAbsolutePath());
            ArrayList<RowData> tables = new ArrayList<RowData>();
            for (String s : this.connection.getControler().getSheetNames()) {
                String formatedtableName = XlsxUtils.formatTableName(s);
                if (tableNamePattern != null && !formatedtableName.matches("(?i)" + tableNamePattern)) continue;
                RowData rd2 = new RowData(new String[]{catalog, null, formatedtableName, "TABLE", null, null, null, null});
                tables.add(rd2);
            }
            for (String s : this.connection.getControler().getDefinedNames()) {
                if (tableNamePattern != null && !s.matches("(?i)" + tableNamePattern)) continue;
                rd = new RowData(new String[]{catalog, null, s, "TABLE", null, null, null, null});
                tables.add(rd);
            }
            for (String s : this.connection.getControler().getCustomDefinedNames()) {
                if (tableNamePattern != null && !s.matches("(?i)" + tableNamePattern)) continue;
                rd = new RowData(new String[]{catalog, null, s, "TABLE", null, null, null, null});
                tables.add(rd);
            }
            for (String s : this.connection.getControler().getDefinedTableNames()) {
                if (tableNamePattern != null && !s.matches("(?i)" + tableNamePattern)) continue;
                rd = new RowData(new String[]{catalog, null, s, "TABLE", null, null, null, null});
                tables.add(rd);
            }
            crs.setData(tables.toArray(new RowData[tables.size()]));
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            this.connection.getControler().releaseConnectionIfNeeded();
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            CommonResultSet crs = new CommonResultSet();
            ColumnMetaData cmd = new ColumnMetaData("TABLE_CAT");
            crs.setMetaData(new CommonResultSetMetaData(new ColumnMetaData[]{cmd}));
            ArrayList<RowData> data = new ArrayList<RowData>();
            for (String str : this.connection.getCatalogs()) {
                data.add(new RowData(new String[]{str}));
            }
            crs.setData(data.toArray(new RowData[data.size()]));
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            this.connection.getControler().releaseConnectionIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            CommonResultSet crs = new CommonResultSet();
            ColumnMetaData cmd = new ColumnMetaData("TABLE_TYPE");
            crs.setMetaData(new CommonResultSetMetaData(new ColumnMetaData[]{cmd}));
            crs.setData(new RowData[]{new RowData(new String[]{"TABLE"})});
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            this.connection.getControler().releaseConnectionIfNeeded();
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        RowData data;
        IWorkbookControler.ColumnType t;
        ArrayList<String> colNames;
        CommonResultSet crs = new CommonResultSet();
        crs.setMetaData(new CommonResultSetMetaData(new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT"), new ColumnMetaData("TABLE_SCHEM"), new ColumnMetaData("TABLE_NAME"), new ColumnMetaData("COLUMN_NAME"), new ColumnMetaData("DATA_TYPE", null, 4, 10), new ColumnMetaData("TYPE_NAME"), new ColumnMetaData("COLUMN_SIZE", null, 4, 10), new ColumnMetaData("BUFFER_LENGTH"), new ColumnMetaData("DECIMAL_DIGITS", null, 4, 10), new ColumnMetaData("NUM_PREC_RADIX", null, 4, 10), new ColumnMetaData("NULLABLE", null, 4, 10), new ColumnMetaData("REMARKS"), new ColumnMetaData("COLUMN_DEF"), new ColumnMetaData("SQL_DATA_TYPE", null, 4, 10), new ColumnMetaData("SQL_DATETIME_SUB", null, 4, 10), new ColumnMetaData("CHAR_OCTET_LENGTH", null, 4, 10), new ColumnMetaData("ORDINAL_POSITION", null, 4, 10), new ColumnMetaData("IS_NULLABLE"), new ColumnMetaData("SCOPE_CATLOG"), new ColumnMetaData("SCOPE_SCHEMA"), new ColumnMetaData("SCOPE_TABLE"), new ColumnMetaData("SOURCE_DATA_TYPE", null, 5, 1), new ColumnMetaData("IS_AUTOINCREMENT")}));
        columnNamePattern = columnNamePattern != null ? columnNamePattern.replace("%", ".*?").replace("_", ".").replace("$", "\\$") : null;
        tableNamePattern = tableNamePattern != null ? tableNamePattern.replace("%", ".*?").replace("_", ".").replace("$", "\\$") : null;
        String delimiter = tableNamePattern.matches(".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+") ? tableNamePattern.substring(tableNamePattern.replaceAll("![a-zA-Z]+\\d+:[a-zA-Z]+\\d+", "").length() + 1) : null;
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        tableNamePattern = XlsxUtils.removeTableDelimiter(tableNamePattern);
        for (String s : this.connection.getControler().getSheetNames()) {
            if (tableNamePattern != null && !XlsxUtils.formatTableName(s).matches("(?i)" + tableNamePattern)) continue;
            colNames = new ArrayList<String>();
            for (String c : this.connection.getControler().getColumnNamesFromSheet(s, delimiter)) {
                if (columnNamePattern != null && !c.matches("(?i)" + columnNamePattern)) continue;
                colNames.add(c);
                t = this.connection.getControler().getColumnType(XlsxUtils.formatTableName(s), c);
                data = new RowData(new String[]{catalog, null, XlsxUtils.formatTableName(s), c, "" + t.getSqlTypeCode(), t.getNativeTypeName(), this.connection.getControler().getColumnSize(), null, null, null, String.valueOf(1), "", null, t.getNativeTypeName(), null, null, String.valueOf(rowDataList.size() + 1), "YES", null, null, null, null, "NO"});
                rowDataList.add(data);
            }
            this.getPropertyFieldstColumns(catalog, s, rowDataList);
        }
        for (String s : this.connection.getControler().getDefinedNames()) {
            if (tableNamePattern != null && !s.matches("(?i)" + tableNamePattern)) continue;
            colNames = new ArrayList();
            for (String c : this.connection.getControler().getColumnNamesFromDefinedName(s, delimiter)) {
                if (columnNamePattern != null && !c.matches("(?i)" + columnNamePattern)) continue;
                colNames.add(c);
                t = this.connection.getControler().getColumnType(s, c);
                data = new RowData(new String[]{catalog, null, s, c, "" + t.getSqlTypeCode(), t.getNativeTypeName(), this.connection.getControler().getColumnSize(), null, null, null, String.valueOf(1), "", null, t.getNativeTypeName(), null, null, String.valueOf(rowDataList.size() + 1), "YES", null, null, null, null, "NO"});
                rowDataList.add(data);
            }
            this.getPropertyFieldstColumns(catalog, s, rowDataList);
        }
        for (String s : this.connection.getControler().getCustomDefinedNames()) {
            if (tableNamePattern != null && !s.matches("(?i)" + tableNamePattern)) continue;
            colNames = new ArrayList();
            for (String c : this.connection.getControler().getColumnNamesFromCustomDefinedName(s, delimiter)) {
                if (columnNamePattern != null && !c.matches("(?i)" + columnNamePattern)) continue;
                colNames.add(c);
                t = this.connection.getControler().getColumnType(s, c);
                data = new RowData(new String[]{catalog, null, s, c, "" + t.getSqlTypeCode(), t.getNativeTypeName(), this.connection.getControler().getColumnSize(), null, null, null, String.valueOf(1), "", null, t.getNativeTypeName(), null, null, String.valueOf(rowDataList.size() + 1), "YES", null, null, null, null, "NO"});
                rowDataList.add(data);
            }
            this.getPropertyFieldstColumns(catalog, s, rowDataList);
        }
        for (String tableName : this.connection.getControler().getDefinedTableNames()) {
            if (tableNamePattern != null && !tableName.matches("(?i)" + tableNamePattern)) continue;
            colNames = new ArrayList();
            for (String colName : this.connection.getControler().getColumnNamesFromDefinedTable(tableName)) {
                if (columnNamePattern != null && !colName.matches("(?i)" + columnNamePattern)) continue;
                colNames.add(colName);
                IWorkbookControler.ColumnType colType = this.connection.getControler().getColumnType(XlsxUtils.formatTableName(tableName), colName);
                data = new RowData(new String[]{catalog, null, XlsxUtils.formatTableName(tableName), colName, "" + colType.getSqlTypeCode(), colType.getNativeTypeName(), this.connection.getControler().getColumnSize(), null, null, null, String.valueOf(1), "", null, colType.getNativeTypeName(), null, null, String.valueOf(rowDataList.size() + 1), "YES", null, null, null, null, "NO"});
                rowDataList.add(data);
            }
            this.getPropertyFieldstColumns(catalog, tableName, rowDataList);
        }
        crs.setData(rowDataList.toArray(new RowData[rowDataList.size()]));
        return crs;
    }

    private void getPropertyFieldstColumns(String catalog, String tableName, List<RowData> columns) throws XlsException {
        for (String propertyField : Sheet.PROPERTY_FIELDS_NAMES) {
            IWorkbookControler.ColumnType internalColType = this.connection.getControler().getColumnType(tableName, propertyField);
            int sqlTypeCode = internalColType.getSqlTypeCode();
            String nativeType = internalColType.getNativeTypeName();
            RowData internalRowData = new RowData(new String[]{catalog, null, XlsxUtils.formatTableName(tableName), propertyField, String.valueOf(sqlTypeCode), nativeType, this.connection.getControler().getColumnSize(), null, null, null, String.valueOf(1), "", null, nativeType, null, null, String.valueOf(columns.size() + 1), "YES", null, null, null, null, "NO"});
            columns.add(internalRowData);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            CommonResultSet crs = new CommonResultSet();
            ArrayList datas = new ArrayList();
            crs.setData(datas.toArray(new RowData[datas.size()]));
            this.connection.getControler().releaseConnectionIfNeeded();
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            this.connection.getControler().releaseConnectionIfNeeded();
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            CommonResultSet crs = new CommonResultSet();
            ArrayList datas = new ArrayList();
            crs.setData(datas.toArray(new RowData[datas.size()]));
            CommonResultSet commonResultSet = crs;
            return commonResultSet;
        }
        finally {
            this.connection.getControler().releaseConnectionIfNeeded();
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

