/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.cell;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class Cell {
    protected String refRow;
    protected Integer style;
    protected String formula;
    protected WorkBook workbook;
    protected Constant.CELL_TYPE cellType = Constant.CELL_TYPE.UNTYPED;
    protected String cellValue;

    public Cell(WorkBook workbook, XMLStreamReader reader, String refRow, Integer style) {
        this.refRow = refRow;
        this.style = style;
        this.workbook = workbook;
        this.parseCell(reader);
    }

    protected void parseCell(XMLStreamReader reader) {
        try {
            boolean cellParsing = true;
            while (reader.hasNext() && cellParsing) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (reader.getLocalName().equals("v")) {
                            this.cellValue = reader.getElementText();
                            break;
                        }
                        if (!reader.getLocalName().equals("f")) break;
                        this.formula = reader.getElementText();
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("c")) break;
                        cellParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public Constant.CELL_TYPE getCellType() {
        return this.cellType;
    }

    public String getRefRow() {
        return this.refRow;
    }

    public Integer getStyle() {
        return this.style;
    }

    public String getFormula() {
        return this.formula;
    }

    public Integer getColumnIndex() {
        return XlsxUtils.getExcelIndexLetterToInteger(this.refRow);
    }
}

