/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.cell;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class InlineStrCell
extends Cell {
    public InlineStrCell(WorkBook workbook, XMLStreamReader reader, String refRow, Integer style) {
        super(workbook, reader, refRow, style);
        this.cellType = Constant.CELL_TYPE.INLINE_STR;
    }

    @Override
    protected void parseCell(XMLStreamReader reader) {
        boolean is = false;
        boolean cellParsing = true;
        StringBuilder builder = new StringBuilder(100);
        try {
            while (reader.hasNext() && cellParsing) {
                int type = reader.next();
                switch (type) {
                    case 4: {
                        if (!is) break;
                        builder.append(reader.getText());
                        break;
                    }
                    case 1: {
                        if (!"is".equals(reader.getLocalName())) break;
                        builder.setLength(0);
                        is = true;
                        break;
                    }
                    case 2: {
                        if ("is".equals(reader.getLocalName())) {
                            this.cellValue = builder.toString();
                            is = false;
                            break;
                        }
                        if (!reader.getLocalName().equals("c")) break;
                        cellParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

