/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.cell;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SharedStringCell
extends Cell {
    private Integer sharedStringIndex;

    public SharedStringCell(WorkBook workbook, XMLStreamReader reader, String refRow, Integer style) {
        super(workbook, reader, refRow, style);
        this.cellType = Constant.CELL_TYPE.SHARED_STRING;
    }

    @Override
    protected void parseCell(XMLStreamReader reader) {
        try {
            boolean cellParsing = true;
            while (reader.hasNext() && cellParsing) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!reader.getLocalName().equals("v")) break;
                        this.sharedStringIndex = Integer.parseInt(reader.getElementText());
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("c")) break;
                        cellParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        this.cellValue = this.workbook.getSharedString().getValue(this.sharedStringIndex);
    }
}

