/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.part.CustomDefinedName;
import com.stambia.jdbc.driver.xlsx.part.RelationShip;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Package {
    private Map<String, RelationShip> relations;
    private Map<String, String> contentTypes;
    private WorkBook workBook;
    private String workbookPathInZip;
    private Map<String, Map<String, CustomDefinedName>> definedNames;
    private String catalog;
    private XlsFileHelper xlsFileHelper;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public Package(XlsFileHelper xlsFileHelper, String catalog, Map<String, Map<String, CustomDefinedName>> definedNames) throws Exception {
        this.relations = new HashMap<String, RelationShip>();
        this.contentTypes = new HashMap<String, String>();
        this.definedNames = definedNames;
        this.catalog = new File(catalog).getName().replace(".xlsx", "");
        this.xlsFileHelper = xlsFileHelper;
        this.computeMetaData();
    }

    public XlsFileHelper getFileHelper() {
        return this.xlsFileHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPackageParts() throws IOException {
        InputStream contentTypeInputStream = this.xlsFileHelper.getInputStreamFromZipStream("[Content_Types].xml");
        InputStream relationsInputStream = this.xlsFileHelper.getInputStreamFromZipStream("_rels/.rels");
        try {
            this.parseContentType(contentTypeInputStream);
            this.parseRelationFile(relationsInputStream);
            if (this.workbookPathInZip != null) {
                this.workBook = new WorkBook(this, this.workbookPathInZip);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (relationsInputStream != null) {
                    relationsInputStream.close();
                }
            }
            finally {
                if (contentTypeInputStream != null) {
                    contentTypeInputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> parseCalcChain() {
        HashSet<String> calcChainCellRef = new HashSet<String>();
        for (String path : this.contentTypes.keySet()) {
            if (!this.contentTypes.get(path).equals(Constant.CALC_CHAIN_CONTENT_TYPE)) continue;
            InputStream calcChainInputStream = null;
            XMLStreamReader reader = null;
            try {
                calcChainInputStream = this.xlsFileHelper.getInputStreamFromZipStream(path.substring(1));
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.supportDTD", false);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                reader = factory.createXMLStreamReader(calcChainInputStream);
                while (reader.hasNext()) {
                    int type = reader.next();
                    switch (type) {
                        case 1: {
                            if (!"c".equals(reader.getLocalName())) break;
                            int count = reader.getAttributeCount();
                            for (int i = 0; i < count; ++i) {
                                String name = reader.getAttributeLocalName(i);
                                String value = reader.getAttributeValue(i);
                                if (!name.equals("r")) continue;
                                calcChainCellRef.add(value);
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {
                        this.logger.warn("Unexpected", (Throwable)ex);
                    }
                }
                if (calcChainInputStream == null) continue;
                try {
                    calcChainInputStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
        return calcChainCellRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseContentType(InputStream inputStream) throws XMLStreamException {
        try (XMLStreamReader reader = null;){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLStreamReader(inputStream);
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!Constant.CONTENT_TYPES_OVERRIDE.equals(reader.getLocalName())) break;
                        int count = reader.getAttributeCount();
                        String partName = null;
                        String partType = null;
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (name.equals(Constant.CONTENT_TYPES_PART_NAME)) {
                                partName = value;
                            }
                            if (!name.equals(Constant.CONTENT_TYPES_TYPE)) continue;
                            partType = value;
                        }
                        this.contentTypes.put(partName, partType);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRelationFile(InputStream stream) throws XMLStreamException {
        try (XMLStreamReader reader = null;){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLStreamReader(stream);
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!Constant.RELATIONSHIP_ELEMENT_NAME.equals(reader.getLocalName())) break;
                        this.processRelationships(reader);
                    }
                }
            }
        }
    }

    private void processRelationships(XMLStreamReader reader) {
        String id = null;
        String relationType = null;
        String target = null;
        String targetMode = null;
        boolean isOfficeDocument = false;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (name.equals(Constant.RELATIONSHIP_ID)) {
                id = value;
            } else if (name.equals(Constant.RELATIONSHIP_TYPE)) {
                relationType = value;
                if (relationType.endsWith("officeDocument")) {
                    isOfficeDocument = true;
                }
            } else if (name.equals(Constant.RELATIONSHIP_TARGET)) {
                target = value;
            } else if (name.equals(Constant.RELATIONSHIP_TARGET_MODE)) {
                targetMode = value;
            }
            if (targetMode != null) continue;
            targetMode = Constant.INTERNAL_TARGET;
        }
        if (isOfficeDocument && target != null) {
            this.workbookPathInZip = target;
        }
        this.relations.put(id, new RelationShip(id, relationType, target, targetMode));
    }

    public WorkBook getWorkBook() {
        return this.workBook;
    }

    public void computeMetaData() {
        try {
            this.refreshPackageParts();
            this.workBook.computeMetaData(this.definedNames);
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCellRefFromCalcChain(Map<String, String> refCellToUpdate) throws Exception {
        for (Map.Entry<String, String> path : this.contentTypes.entrySet()) {
            if (!path.getValue().equals(Constant.CALC_CHAIN_CONTENT_TYPE)) continue;
            InputStream calcChainInputStream = null;
            XMLEventWriter writer = null;
            XMLEventReader reader = null;
            XlsFileHelper.TemporaryOutputStream outStream = null;
            XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.supportDTD", false);
            inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            try {
                calcChainInputStream = this.xlsFileHelper.getInputStreamFromZipStream(path.getKey().substring(1));
                reader = inFactory.createXMLEventReader(calcChainInputStream);
                outStream = this.xlsFileHelper.getEntryTemporaryOutputStream(path.getKey().substring(1));
                writer = outFactory.createXMLEventWriter(outStream);
                ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
                ArrayDeque<XMLEvent> newLineEvents = new ArrayDeque<XMLEvent>();
                boolean write = true;
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    switch (event.getEventType()) {
                        case 1: {
                            if ("c".equals(event.asStartElement().getName().getLocalPart())) {
                                StartElement newLine = eventFactory.createStartElement(event.asStartElement().getName(), null, null);
                                newLineEvents.push(newLine);
                                write = false;
                                Iterator<Attribute> calcChainAttr = event.asStartElement().getAttributes();
                                while (calcChainAttr.hasNext()) {
                                    Attribute attribute = calcChainAttr.next();
                                    String name = attribute.getName().getLocalPart();
                                    String value = attribute.getValue();
                                    if (name.equals("r")) {
                                        if (refCellToUpdate.keySet().contains(value)) {
                                            newLineEvents.push(eventFactory.createAttribute(name, refCellToUpdate.get(value)));
                                            continue;
                                        }
                                        newLineEvents.push(eventFactory.createAttribute(name, value));
                                        continue;
                                    }
                                    newLineEvents.push(eventFactory.createAttribute(name, value));
                                }
                                break;
                            }
                            eventStack.push(event);
                            break;
                        }
                        case 2: {
                            write = true;
                            if ("c".equals(event.asEndElement().getName().getLocalPart())) {
                                newLineEvents.push(event);
                                break;
                            }
                            eventStack.push(event);
                            break;
                        }
                        default: {
                            eventStack.push(event);
                        }
                    }
                    if (!write) continue;
                    Iterator iteratorNewLine = newLineEvents.descendingIterator();
                    while (iteratorNewLine.hasNext()) {
                        eventStack.push((XMLEvent)iteratorNewLine.next());
                    }
                    Iterator iterator = eventStack.descendingIterator();
                    while (iterator.hasNext()) {
                        writer.add((XMLEvent)iterator.next());
                    }
                    eventStack.clear();
                    newLineEvents.clear();
                }
                writer.flush();
                outStream.save();
                outStream = null;
            }
            catch (Exception e) {
                this.logger.warn("Unexpected", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (calcChainInputStream != null) {
                    try {
                        calcChainInputStream.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                    continue;
                }
                if (outStream == null) continue;
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellRefFromCalcChain(XMLInputFactory inFactory, XMLOutputFactory outFactory, Set<String> refCellToDelete) throws Exception {
        for (Map.Entry<String, String> path : this.contentTypes.entrySet()) {
            if (!path.getValue().equals(Constant.CALC_CHAIN_CONTENT_TYPE)) continue;
            if (refCellToDelete.size() == this.parseCalcChain().size()) {
                this.xlsFileHelper.deleteEntryInsideZip(path.getKey().substring(1));
                continue;
            }
            InputStream calcChainInputStream = null;
            XMLEventWriter writer = null;
            XMLEventReader reader = null;
            XlsFileHelper.TemporaryOutputStream outStream = null;
            try {
                calcChainInputStream = this.xlsFileHelper.getInputStreamFromZipStream(path.getKey().substring(1));
                reader = inFactory.createXMLEventReader(calcChainInputStream);
                outStream = this.xlsFileHelper.getEntryTemporaryOutputStream(path.getKey().substring(1));
                writer = outFactory.createXMLEventWriter(outStream);
                boolean deleteRef = false;
                ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
                boolean write = true;
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    eventStack.push(event);
                    switch (event.getEventType()) {
                        case 1: {
                            if (!"c".equals(event.asStartElement().getName().getLocalPart())) break;
                            write = false;
                            deleteRef = false;
                            Iterator<Attribute> calcChainAttr = event.asStartElement().getAttributes();
                            while (calcChainAttr.hasNext()) {
                                Attribute attribute = calcChainAttr.next();
                                String name = attribute.getName().getLocalPart();
                                String value = attribute.getValue();
                                if (!name.equals("r") || !refCellToDelete.contains(value)) continue;
                                deleteRef = true;
                            }
                            break;
                        }
                        case 2: {
                            write = true;
                            if (!event.asEndElement().getName().getLocalPart().equals("c")) break;
                            if (deleteRef) {
                                eventStack.clear();
                                break;
                            }
                            deleteRef = false;
                        }
                    }
                    if (!write) continue;
                    Iterator iterator = eventStack.descendingIterator();
                    while (iterator.hasNext()) {
                        writer.add((XMLEvent)iterator.next());
                    }
                    eventStack.clear();
                }
                writer.flush();
                outStream.save();
                outStream = null;
                break;
            }
            catch (Exception e) {
                this.logger.warn("Unexpected", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (calcChainInputStream != null) {
                    try {
                        calcChainInputStream.close();
                    }
                    catch (IOException e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                    continue;
                }
                if (outStream == null) continue;
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }
}

