/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.cell.CellFactory;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;

public class Row {
    private Map<Integer, Cell> cells;
    private int rowIndex;
    private WorkBook workbook;
    private int nbCells;
    private boolean isAnEmptyRow = true;

    public Row(int rowIndex) {
        this.cells = new HashMap<Integer, Cell>();
        this.rowIndex = rowIndex;
    }

    public Row(WorkBook workbook, XMLStreamReader reader, int rowIndex, int startColumn, int endColumn, boolean parseRow, int propertyFieldsNumber) {
        this.workbook = workbook;
        this.cells = new HashMap<Integer, Cell>();
        this.rowIndex = rowIndex;
        if (parseRow) {
            this.parseRow(reader, startColumn, endColumn);
        }
    }

    public int getNbCells() {
        return this.nbCells;
    }

    public static boolean isAnEmptyRow(XMLEventReader eventReader, int startColumn, int endColumn) {
        boolean isAnEmptyRow = true;
        try {
            boolean rowParsing = true;
            while (eventReader.hasNext() && rowParsing) {
                XMLEvent event = eventReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        if (event.asStartElement().getName().getLocalPart().equals("v")) {
                            isAnEmptyRow = false;
                            break;
                        }
                        if (!event.asStartElement().getName().getLocalPart().equals("if")) break;
                        isAnEmptyRow = false;
                        break;
                    }
                    case 2: {
                        if (!event.asEndElement().getName().getLocalPart().equals("c")) break;
                        rowParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return isAnEmptyRow;
    }

    private void parseRow(XMLStreamReader reader, int startColumn, int endColumn) {
        try {
            boolean rowParsing = true;
            block7: while (reader.hasNext() && rowParsing) {
                int type = reader.next();
                switch (type) {
                    case 10: {
                        break;
                    }
                    case 1: {
                        if (!reader.getLocalName().equals("c")) break;
                        String refRow = null;
                        Integer style = null;
                        String t = null;
                        int count = reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (name.equals("r")) {
                                refRow = value;
                                continue;
                            }
                            if (name.equals("s")) {
                                style = Integer.parseInt(value);
                                continue;
                            }
                            if (!name.equals("t")) continue;
                            t = value;
                        }
                        int columnIndex = XlsxUtils.getExcelIndexLetterToInteger(refRow);
                        if (startColumn <= columnIndex) {
                            if (endColumn != -1 && columnIndex > endColumn) continue block7;
                            Cell cell = CellFactory.createCellFromXml(this.workbook, reader, refRow, style, t);
                            this.cells.put(columnIndex, cell);
                            if (cell.getCellValue() != null) {
                                this.isAnEmptyRow = false;
                            }
                            if (this.nbCells >= columnIndex) continue block7;
                            this.nbCells = columnIndex;
                            break;
                        }
                        if (endColumn == -1 || columnIndex <= endColumn) continue block7;
                        rowParsing = false;
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("row")) break;
                        rowParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Cell getCell(int columnIndex) {
        return this.cells.get(columnIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void clear() {
        this.cells.clear();
    }

    public Collection<Cell> getCells() {
        return this.cells.values();
    }

    public boolean isAnEmptyRow() {
        return this.cells.isEmpty() ? true : this.isAnEmptyRow;
    }

    public Cell getFirstCell() {
        ArrayList<Integer> cellIdx = new ArrayList<Integer>(this.cells.keySet());
        Collections.sort(cellIdx);
        return this.cells.get(cellIdx.get(0));
    }

    public void addCell() {
    }
}

