/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class SharedString {
    private int count;
    private int uniqueCount;
    private Set<String> knownValues = new HashSet<String>();
    private Map<Integer, String> sharedStringIndexToValue = new LinkedHashMap<Integer, String>();
    private Map<String, Integer> sharedStringValueToIndex = new LinkedHashMap<String, Integer>();
    public static final String ROOT_TAG = "sst";
    public static final String ENTRY_TAG = "si";
    public static final String COUNT_TAG = "count";
    public static final String UNIQUE_COUNT_TAG = "uniqueCount";
    private static final String PATH_INSIDE_ZIP = "xl/sharedStrings.xml";
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
    private static final QName ROOT_QNAME = new QName("sst");
    private static final QName ENTRY_QNAME = new QName("si");
    private static final QName VALUE_QNAME = new QName("t");
    private static final StartElement ROOT_START = eventFactory.createStartElement(ROOT_QNAME, null, null);
    private static final Namespace NAMESPACE = eventFactory.createNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
    private static final StartElement ENTRY_START = eventFactory.createStartElement(ENTRY_QNAME, null, null);
    private static final StartElement VALUE_START = eventFactory.createStartElement(VALUE_QNAME, null, null);
    private static final EndElement ROOT_END = eventFactory.createEndElement(ROOT_QNAME, null);
    private static final EndElement ENTRY_END = eventFactory.createEndElement(ENTRY_QNAME, null);
    private static final EndElement VALUE_END = eventFactory.createEndElement(VALUE_QNAME, null);

    SharedString(int count, int uniqueCount, Map<Integer, String> sharedString) {
        this.count = count;
        this.uniqueCount = uniqueCount;
        this.sharedStringIndexToValue.putAll(sharedString);
        this.knownValues.addAll(sharedString.values());
        for (Map.Entry<Integer, String> entry : sharedString.entrySet()) {
            Integer index = entry.getKey();
            String value = entry.getValue();
            this.sharedStringValueToIndex.putIfAbsent(value, index);
        }
    }

    public String getValue(Integer index) {
        return this.sharedStringIndexToValue.get(index);
    }

    public int addValue(String value) {
        int index;
        ++this.count;
        if (!this.knownValues.contains(value)) {
            this.knownValues.add(value);
            this.sharedStringIndexToValue.put(this.uniqueCount, value);
            this.sharedStringValueToIndex.put(value, this.uniqueCount);
            index = this.uniqueCount++;
        } else {
            index = this.sharedStringValueToIndex.get(value);
        }
        return index;
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(XlsFileHelper fileHelper) throws XlsException {
        try (XlsFileHelper.TemporaryOutputStream outStream = fileHelper.getEntryTemporaryOutputStream(PATH_INSIDE_ZIP);){
            try (XMLEventWriter writer = xmlFactory.createXMLEventWriter(outStream);){
                writer.add(ROOT_START);
                writer.add(NAMESPACE);
                writer.add(eventFactory.createAttribute(COUNT_TAG, String.valueOf(this.count)));
                writer.add(eventFactory.createAttribute(UNIQUE_COUNT_TAG, String.valueOf(this.uniqueCount)));
                for (int index = 0; index < this.uniqueCount; ++index) {
                    writer.add(ENTRY_START);
                    writer.add(VALUE_START);
                    writer.add(eventFactory.createCharacters(this.getValue(index)));
                    writer.add(VALUE_END);
                    writer.add(ENTRY_END);
                }
                writer.add(ROOT_END);
                writer.flush();
            }
            outStream.flush();
            outStream.save();
        }
        catch (Exception e) {
            throw new XlsException(e);
        }
    }
}

