/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.XlsxUtils;
import com.stambia.jdbc.driver.xlsx.cell.Cell;
import com.stambia.jdbc.driver.xlsx.cell.CellFactory;
import com.stambia.jdbc.driver.xlsx.part.Messages;
import com.stambia.jdbc.driver.xlsx.part.Row;
import com.stambia.jdbc.driver.xlsx.part.SharedString;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import com.stambia.jdbc.jdbc.drive.xlsx.parser.FunctionReferenceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sheet {
    private String name;
    private String pathInsideZip;
    private TreeMap<Integer, Row> rows;
    private WorkBook workbook;
    private String rowSpan;
    private String x14AcdyDescentValue;
    private HashMap<Integer, Integer> colsStyle;
    private Integer lastRowIdx;
    private String relationId;
    public static final String ROW_NUMBER = "row_number";
    public static final String ROW_COUNT = "row_count";
    public static final Set<String> PROPERTY_FIELDS_NAMES = new HashSet<String>();
    public static final Map<String, Integer> PROPERTY_FIELDS = new HashMap<String, Integer>();
    private static final int PROPERTY_FIELDS_NUMBER;
    private boolean propertyFieldsIndicesSet;
    private int rowCount;
    private boolean dimensionMarkupRead;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public Sheet(WorkBook workbook, String name, String relationId, String pathInsideZip) {
        this.rows = new TreeMap();
        this.pathInsideZip = pathInsideZip;
        this.workbook = workbook;
        this.name = name;
        this.relationId = relationId;
        this.colsStyle = new HashMap();
    }

    public String getRelationId() {
        return this.relationId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCols(XMLStreamReader reader) {
        boolean colsParsing = true;
        try {
            block6: while (reader.hasNext() && colsParsing) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        int i;
                        if (!reader.getLocalName().equals("col")) break;
                        int count = reader.getAttributeCount();
                        Integer style = null;
                        int min = 0;
                        int max = 0;
                        for (i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (name.equals("style")) {
                                style = Integer.parseInt(value);
                                continue;
                            }
                            if (name.equals("min")) {
                                min = Integer.parseInt(value);
                                continue;
                            }
                            if (!name.equals("max")) continue;
                            max = Integer.parseInt(value);
                        }
                        if (style == null) continue block6;
                        for (i = min; i <= max; ++i) {
                            this.colsStyle.put(i, style);
                        }
                        continue block6;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("cols")) break;
                        colsParsing = false;
                        continue block6;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    private void processSheetData(XMLStreamReader reader, boolean parseOnlyColumnName, boolean parseRowStyle, boolean stopAtFirstEmptyRow, int startRow, Integer startColumn, Integer endColumn, boolean loadRow) {
        try {
            boolean sheetDataParsing = true;
            boolean headerParsed = false;
            int rowIndex = -1;
            block6: while (reader.hasNext() && sheetDataParsing) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!reader.getLocalName().equals("row")) break;
                        int count = reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String localName = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            String attributePrefix = reader.getAttributePrefix(i);
                            if (localName.equals("r")) {
                                rowIndex = Integer.parseInt(value);
                                continue;
                            }
                            if (parseRowStyle && localName.equals("spans")) {
                                this.rowSpan = value;
                                continue;
                            }
                            if (!parseRowStyle || !localName.equals("dyDescent") || !attributePrefix.equals("x14ac")) continue;
                            this.x14AcdyDescentValue = value;
                        }
                        if (headerParsed && parseRowStyle) {
                            sheetDataParsing = false;
                        } else if (rowIndex >= startRow) {
                            Row row = new Row(this.workbook, reader, rowIndex, startColumn, endColumn, true, PROPERTY_FIELDS_NUMBER);
                            if (row.isAnEmptyRow() && stopAtFirstEmptyRow && !parseRowStyle) {
                                sheetDataParsing = false;
                            } else {
                                if (loadRow || this.rows.size() < 2) {
                                    this.rows.put(rowIndex, row);
                                    if (!this.propertyFieldsIndicesSet) {
                                        this.setPropertyFieldsIndices();
                                    }
                                }
                                this.lastRowIdx = rowIndex;
                            }
                            if (parseOnlyColumnName && !row.isAnEmptyRow()) {
                                if (parseRowStyle) {
                                    headerParsed = true;
                                } else {
                                    sheetDataParsing = false;
                                }
                            }
                        }
                        if (this.dimensionMarkupRead || rowIndex <= this.rowCount) continue block6;
                        this.rowCount = rowIndex;
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("sheetData")) break;
                        sheetDataParsing = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }

    private void setPropertyFieldsIndices() {
        int index = this.getFirstRow().getNbCells();
        for (String propertyField : PROPERTY_FIELDS_NAMES) {
            PROPERTY_FIELDS.put(propertyField, ++index);
        }
        this.propertyFieldsIndicesSet = true;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseSheet(boolean parseOnlyColumnName, boolean parseRowStyle, boolean stopAtFirstEmptyRow, int startRow, Integer startColumn, Integer endColumn, boolean loadRow) {
        XMLStreamReader reader = null;
        InputStream relsStream = null;
        try {
            relsStream = this.workbook.getPackage().getFileHelper().getInputStreamFromZipStream(this.pathInsideZip);
            if (relsStream != null) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.supportDTD", false);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                reader = factory.createXMLStreamReader(relsStream);
                while (reader.hasNext()) {
                    int type = reader.next();
                    switch (type) {
                        case 1: {
                            String localName = reader.getLocalName();
                            if (localName.equals(Constant.SHEET_COLS)) {
                                this.processCols(reader);
                                break;
                            }
                            if (localName.equals(Constant.SHEET_DIMENSION)) {
                                this.processDimension(reader);
                                break;
                            }
                            if (!localName.equals(Constant.SHEET_DATA)) break;
                            this.processSheetData(reader, parseOnlyColumnName, parseRowStyle, stopAtFirstEmptyRow, startRow, startColumn, endColumn, loadRow);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            try {
                if (relsStream != null) {
                    relsStream.close();
                }
            }
            catch (IOException e) {
                this.logger.warn("Unexpected", (Throwable)e);
            }
        }
    }

    private void processDimension(XMLStreamReader reader) {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            if (!Constant.REF.equals(attributeName)) continue;
            String value = reader.getAttributeValue(i);
            Integer firstLine = XlsxUtils.getRowStartFromTableDelimiter(value);
            Integer lastLine = XlsxUtils.getRowEndFromTableDelimiter(value);
            if (null == firstLine || null == lastLine) break;
            this.rowCount = 1 + lastLine - firstLine;
            break;
        }
        this.dimensionMarkupRead = true;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Row getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public void clear() {
        for (Row row : this.rows.values()) {
            row.clear();
        }
        this.rows.clear();
    }

    public Row getFirstRow() {
        if (this.rows.keySet().isEmpty()) {
            return null;
        }
        ArrayList<Integer> rowIdxs = new ArrayList<Integer>(this.rows.keySet());
        Collections.sort(rowIdxs);
        return this.rows.get(rowIdxs.get(0));
    }

    public Row getLastRow() {
        if (this.rows.keySet().isEmpty()) {
            return null;
        }
        ArrayList<Integer> rowIdxs = new ArrayList<Integer>(this.rows.keySet());
        Collections.sort(rowIdxs);
        return this.rows.get(rowIdxs.get(rowIdxs.size() - 1));
    }

    public int getNbRows() {
        return this.rows.size();
    }

    public Cell getCell(int rowIndex, Integer columnIndex) {
        Cell cell = null;
        Row row = this.getRow(rowIndex);
        if (row != null) {
            cell = row.getCell(columnIndex);
        }
        return cell;
    }

    public void parseSheet(boolean parseOnlyColumnName, boolean parseRowStyle, boolean loadRow) {
        this.parseSheet(parseOnlyColumnName, parseRowStyle, false, 1, 1, -1, loadRow);
    }

    public int insertRows(XMLInputFactory inFactory, XMLOutputFactory outFactory, LinkedList<HashMap<Integer, Object>> cellValues, LinkedList<HashMap<Integer, Integer>> sqlTypes, Integer rowStart, Integer startColumn, Integer endColumn, Integer rowEnd) throws Exception {
        if (cellValues.getLast().size() > endColumn + 1 - startColumn) {
            throw new RuntimeException(Messages.getString("Sheet.0"));
        }
        int rowOffset = cellValues.size();
        int firstRowInsertedIdx = 0;
        int updatedRowRef = 0;
        XMLEventWriter writer = null;
        XlsFileHelper.TemporaryOutputStream outStream = null;
        InputStream inStream = null;
        int emptyRowOffset = 0;
        int nbDataColumn = 0;
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        XMLEventReader reader = null;
        boolean doSave = false;
        try {
            HashMap<String, String> refCellToUpdate = new HashMap<String, String>();
            inStream = this.workbook.getPackage().getFileHelper().getInputStreamFromZipStream(this.pathInsideZip);
            reader = inFactory.createXMLEventReader(inStream);
            outStream = this.workbook.getPackage().getFileHelper().getEntryTemporaryOutputStream(this.pathInsideZip);
            writer = outFactory.createXMLEventWriter(outStream);
            boolean insertStartSheetData = false;
            boolean insertEndSheetData = false;
            boolean rowProccesing = false;
            boolean rowParsing = false;
            boolean cellParsing = false;
            int currentRowParsing = 0;
            int currentCellParsing = 0;
            int lastRowParsed = 0;
            boolean writeRows = false;
            boolean parsedRowIsEmpty = true;
            boolean updateRow = false;
            boolean updateCell = false;
            boolean rowsHasBeenInserted = false;
            boolean cellRangeEmpty = false;
            ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
            HashMap<Integer, Deque<XMLEvent>> rowsEvents = new HashMap<Integer, Deque<XMLEvent>>();
            HashMap<Integer, HashMap<Integer, Deque<XMLEvent>>> cellsEvents = new HashMap<Integer, HashMap<Integer, Deque<XMLEvent>>>();
            while (reader.hasNext()) {
                boolean isDimensionEvent = false;
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        if (event.asStartElement().getName().getLocalPart().equals("f") && updateRow && currentCellParsing >= startColumn && currentCellParsing <= endColumn) {
                            refCellToUpdate.put(XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(currentRowParsing, currentCellParsing), XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(updatedRowRef, currentCellParsing));
                        }
                        if (event.asStartElement().getName().getLocalPart().equals("v") && currentCellParsing >= startColumn && currentCellParsing <= endColumn) {
                            cellRangeEmpty = false;
                        }
                        if (event.asStartElement().getName().getLocalPart().equals(Constant.SHEET_DIMENSION)) {
                            isDimensionEvent = true;
                        }
                        if (event.asStartElement().getName().getLocalPart().equals(Constant.SHEET_DATA)) {
                            rowProccesing = true;
                            eventStack.push(event);
                            insertStartSheetData = true;
                            break;
                        }
                        if (event.asStartElement().getName().getLocalPart().equals("row")) {
                            rowParsing = true;
                            parsedRowIsEmpty = true;
                            cellRangeEmpty = true;
                            Iterator<Attribute> rowAttributes = event.asStartElement().getAttributes();
                            while (rowAttributes.hasNext()) {
                                Attribute attribute = rowAttributes.next();
                                QName qname = attribute.getName();
                                String value = attribute.getValue();
                                if (!qname.getLocalPart().equals("r")) continue;
                                lastRowParsed = currentRowParsing;
                                currentRowParsing = Integer.valueOf(value);
                                break;
                            }
                            ArrayDeque<XMLEvent> rowEvents = new ArrayDeque<XMLEvent>();
                            if (firstRowInsertedIdx != 0 && rowOffset > 1 && rowOffset > emptyRowOffset) {
                                updatedRowRef = currentRowParsing + rowOffset - emptyRowOffset;
                                updateRow = true;
                                Iterator<XMLEvent> iterator = this.updateRowReference(event, eventFactory, updatedRowRef).descendingIterator();
                                while (iterator.hasNext()) {
                                    rowEvents.push(iterator.next());
                                }
                                rowsEvents.put(updatedRowRef, rowEvents);
                                break;
                            }
                            rowEvents.push(event);
                            rowsEvents.put(currentRowParsing, rowEvents);
                            break;
                        }
                        if (event.asStartElement().getName().getLocalPart().equals("c")) {
                            ArrayDeque<XMLEvent> cellColumns;
                            HashMap cellEvents;
                            cellParsing = true;
                            Iterator<Attribute> cellAttributes = event.asStartElement().getAttributes();
                            while (cellAttributes.hasNext()) {
                                Attribute attribute = cellAttributes.next();
                                QName qname = attribute.getName();
                                String value = attribute.getValue();
                                if (!qname.getLocalPart().equals("r")) continue;
                                currentCellParsing = XlsxUtils.getExcelIndexLetterToInteger(value.replaceFirst("\\d+", ""));
                                break;
                            }
                            if (updateRow) {
                                if (currentCellParsing >= startColumn && currentCellParsing <= endColumn) {
                                    updateCell = true;
                                    Deque<XMLEvent> cellColumns2 = this.updateCellReference(event, eventFactory, updatedRowRef);
                                    HashMap<Integer, Deque<XMLEvent>> cellEvents2 = cellsEvents.get(updatedRowRef) == null ? new HashMap<Integer, Deque<XMLEvent>>() : cellsEvents.get(updatedRowRef);
                                    cellEvents2.put(currentCellParsing, cellColumns2);
                                    cellsEvents.put(updatedRowRef, cellEvents2);
                                    break;
                                }
                                cellEvents = cellsEvents.get(currentRowParsing) == null ? new HashMap() : cellsEvents.get(currentRowParsing);
                                cellColumns = new ArrayDeque();
                                cellColumns.push(event);
                                cellEvents.put(currentCellParsing, cellColumns);
                                cellsEvents.put(currentRowParsing, cellEvents);
                                if (rowsEvents.containsKey(currentRowParsing)) break;
                                ArrayDeque<XMLEvent> rowEvent = new ArrayDeque<XMLEvent>();
                                rowEvent.push(this.createRowStartElement(eventFactory, currentRowParsing));
                                rowEvent.push(eventFactory.createEndElement(new QName("row"), null));
                                rowsEvents.put(currentRowParsing, rowEvent);
                                break;
                            }
                            cellEvents = cellsEvents.get(currentRowParsing) == null ? new HashMap() : cellsEvents.get(currentRowParsing);
                            cellColumns = new ArrayDeque<XMLEvent>();
                            cellColumns.push(event);
                            cellEvents.put(currentCellParsing, cellColumns);
                            cellsEvents.put(currentRowParsing, cellEvents);
                            break;
                        }
                        if (!rowParsing || !cellParsing) break;
                        if (currentCellParsing >= startColumn && currentCellParsing <= endColumn) {
                            if (updateRow && updateCell) {
                                cellsEvents.get(updatedRowRef).get(currentCellParsing).push(event);
                                break;
                            }
                            cellsEvents.get(currentRowParsing).get(currentCellParsing).push(event);
                            parsedRowIsEmpty = false;
                            break;
                        }
                        cellsEvents.get(currentRowParsing).get(currentCellParsing).push(event);
                        break;
                    }
                    case 2: {
                        if (event.asEndElement().getName().getLocalPart().equals(Constant.SHEET_DIMENSION)) {
                            isDimensionEvent = true;
                        }
                        if (event.asEndElement().getName().getLocalPart().equals("row")) {
                            rowParsing = false;
                            rowProccesing = false;
                            writeRows = true;
                            if (!cellRangeEmpty && currentRowParsing >= rowStart && currentRowParsing <= rowEnd) {
                                ++nbDataColumn;
                            }
                            if (updateRow) {
                                rowsEvents.get(updatedRowRef).push(event);
                                updateRow = false;
                            } else {
                                rowsEvents.get(currentRowParsing).push(event);
                            }
                            if (currentRowParsing > rowStart && currentRowParsing > lastRowParsed + 1) {
                                ArrayDeque<XMLEvent> rowToUpdate = null;
                                HashMap cellsToUpdate = new HashMap();
                                if (!rowsHasBeenInserted && rowsEvents.containsKey(currentRowParsing) && cellsEvents.containsKey(currentRowParsing)) {
                                    rowToUpdate = new ArrayDeque<XMLEvent>();
                                    rowToUpdate.addAll((Collection)rowsEvents.get(currentRowParsing));
                                    int newRowIdx = lastRowParsed + 1 + rowOffset;
                                    for (int i = startColumn.intValue(); i <= endColumn; ++i) {
                                        if (!cellsEvents.get(currentRowParsing).containsKey(i)) continue;
                                        ArrayDeque<XMLEvent> cellEventsStack = new ArrayDeque<XMLEvent>();
                                        for (XMLEvent cellEvent : cellsEvents.get(currentRowParsing).get(i)) {
                                            if (cellEvent.isStartElement()) {
                                                Iterator<XMLEvent> iterator = this.updateCellReference(cellEvent, eventFactory, newRowIdx).descendingIterator();
                                                while (iterator.hasNext()) {
                                                    cellEventsStack.push(iterator.next());
                                                }
                                            } else {
                                                cellEventsStack.push(cellEvent);
                                            }
                                            cellsToUpdate.put(i, cellEventsStack);
                                        }
                                    }
                                }
                                if (rowsHasBeenInserted) break;
                                if (currentRowParsing > lastRowParsed + 1) {
                                    int nbRowToInsert = currentRowParsing - lastRowParsed;
                                    if (nbRowToInsert > cellValues.size()) {
                                        nbRowToInsert = cellValues.size();
                                    }
                                    this.insertRows(eventFactory, rowsEvents, cellsEvents, rowStart, lastRowParsed + 1, startColumn, cellValues, sqlTypes, refCellToUpdate, nbRowToInsert);
                                } else {
                                    this.insertRow(eventFactory, rowsEvents, cellsEvents, rowStart, lastRowParsed + 1, startColumn, cellValues.poll(), sqlTypes.poll(), refCellToUpdate);
                                    if (cellRangeEmpty) {
                                        ++emptyRowOffset;
                                    }
                                }
                                int n = firstRowInsertedIdx = firstRowInsertedIdx == 0 ? lastRowParsed + 1 : firstRowInsertedIdx;
                                if (rowToUpdate != null && lastRowParsed + 1 + rowOffset > currentRowParsing) {
                                    int newRowIdx = lastRowParsed + 1 + rowOffset;
                                    XMLEvent lastEvent = (XMLEvent)rowToUpdate.removeLast();
                                    Iterator<XMLEvent> iterator = this.updateRowReference(lastEvent, eventFactory, newRowIdx).descendingIterator();
                                    while (iterator.hasNext()) {
                                        rowToUpdate.push(iterator.next());
                                    }
                                    rowsEvents.put(newRowIdx, rowToUpdate);
                                    cellsEvents.put(newRowIdx, cellsToUpdate);
                                }
                                rowsHasBeenInserted = cellValues.isEmpty();
                                break;
                            }
                            if (currentRowParsing < rowStart || !parsedRowIsEmpty || rowsHasBeenInserted) break;
                            int rowToInsertIdx = lastRowParsed + 1;
                            this.insertRow(eventFactory, rowsEvents, cellsEvents, rowStart, rowToInsertIdx, startColumn, cellValues.poll(), sqlTypes.poll(), refCellToUpdate);
                            firstRowInsertedIdx = firstRowInsertedIdx == 0 ? currentRowParsing : firstRowInsertedIdx;
                            rowsHasBeenInserted = cellValues.isEmpty();
                            if (!cellRangeEmpty) break;
                            ++emptyRowOffset;
                            break;
                        }
                        if (event.asEndElement().getName().getLocalPart().equals("c")) {
                            cellParsing = false;
                            if (updateCell) {
                                cellsEvents.get(updatedRowRef).get(currentCellParsing).push(event);
                                updateCell = false;
                                break;
                            }
                            cellsEvents.get(currentRowParsing).get(currentCellParsing).push(event);
                            break;
                        }
                        if (event.asEndElement().getName().getLocalPart().equals(Constant.SHEET_DATA)) {
                            if (!rowsHasBeenInserted) {
                                firstRowInsertedIdx = rowStart > currentRowParsing ? rowStart : currentRowParsing + 1;
                                this.insertRows(eventFactory, rowsEvents, cellsEvents, rowStart, firstRowInsertedIdx, startColumn, cellValues, sqlTypes, refCellToUpdate, cellValues.size());
                                currentRowParsing = firstRowInsertedIdx;
                                if (cellRangeEmpty) {
                                    ++emptyRowOffset;
                                }
                            }
                            eventStack.push(event);
                            rowProccesing = false;
                            writeRows = true;
                            insertEndSheetData = true;
                            break;
                        }
                        if (!rowParsing || !cellParsing) break;
                        if (startColumn <= currentCellParsing && endColumn >= currentCellParsing) {
                            if (updateRow && updateCell) {
                                cellsEvents.get(updatedRowRef).get(currentCellParsing).push(event);
                                break;
                            }
                            cellsEvents.get(currentRowParsing).get(currentCellParsing).push(event);
                            break;
                        }
                        cellsEvents.get(currentRowParsing).get(currentCellParsing).push(event);
                        break;
                    }
                    default: {
                        if (!rowParsing || !cellParsing) break;
                        if (updateRow && updateCell) {
                            ((Deque)((HashMap)cellsEvents.get(updatedRowRef)).get(currentCellParsing)).push(event);
                            break;
                        }
                        ((Deque)((HashMap)cellsEvents.get(currentRowParsing)).get(currentCellParsing)).push(event);
                    }
                }
                if (rowProccesing) continue;
                if (writeRows) {
                    if (insertStartSheetData) {
                        writer.add((XMLEvent)eventStack.getLast());
                        insertStartSheetData = false;
                    }
                    ArrayList<Integer> rowIdx = new ArrayList<Integer>();
                    for (int i = lastRowParsed + 1; i <= currentRowParsing; ++i) {
                        rowIdx.add(i);
                    }
                    this.writeRowEvents(rowIdx, rowsEvents, cellsEvents, writer);
                    writeRows = false;
                    if (insertEndSheetData) {
                        if (!rowsEvents.isEmpty()) {
                            rowIdx = new ArrayList<Integer>(rowsEvents.keySet());
                            this.writeRowEvents(rowIdx, rowsEvents, cellsEvents, writer);
                        }
                        writer.add((XMLEvent)eventStack.getFirst());
                        insertEndSheetData = false;
                    }
                    eventStack.clear();
                    continue;
                }
                if (rowParsing || isDimensionEvent) continue;
                eventStack.push(event);
                Iterator iterator = eventStack.descendingIterator();
                while (iterator.hasNext()) {
                    writer.add((XMLEvent)iterator.next());
                }
                eventStack.clear();
            }
            writer.flush();
            doSave = true;
            if (!refCellToUpdate.isEmpty()) {
                this.workbook.getPackage().updateCellRefFromCalcChain(refCellToUpdate);
                this.workbook.unsetcalcCompleted();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (writer != null) {
                if (doSave) {
                    outStream.save();
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            } else if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
        return (nbDataColumn += rowOffset) > rowEnd - rowStart + 1 ? nbDataColumn - (rowEnd - rowStart + 1) : 0;
    }

    private void writeRowEvents(List<Integer> rowIdx, HashMap<Integer, Deque<XMLEvent>> rowsEvents, HashMap<Integer, HashMap<Integer, Deque<XMLEvent>>> cellsEvents, XMLEventWriter writer) throws XMLStreamException {
        Collections.sort(rowIdx);
        try {
            for (Integer row : rowIdx) {
                if (rowsEvents.containsKey(row)) {
                    ArrayDeque deque = new ArrayDeque(rowsEvents.get(row));
                    deque.removeFirst();
                    Iterator iterator = deque.descendingIterator();
                    while (iterator.hasNext()) {
                        writer.add((XMLEvent)iterator.next());
                    }
                    if (cellsEvents.containsKey(row)) {
                        ArrayList<Integer> cellIdx = new ArrayList<Integer>(cellsEvents.get(row).keySet());
                        Collections.sort(cellIdx);
                        for (Integer cell : cellIdx) {
                            Deque<XMLEvent> cellEvents = cellsEvents.get(row).get(cell);
                            Iterator<XMLEvent> iterator2 = cellEvents.descendingIterator();
                            while (iterator2.hasNext()) {
                                writer.add(iterator2.next());
                            }
                        }
                    }
                    writer.add(rowsEvents.get(row).getFirst());
                }
                rowsEvents.remove(row);
                cellsEvents.remove(row);
            }
        }
        catch (XMLStreamException ex) {
            this.logger.warn("unexpected", (Throwable)ex);
        }
    }

    private XMLEvent createRowStartElement(XMLEventFactory eventFactory, int currentRowParsing) {
        HashSet<Attribute> rowAttributes = new HashSet<Attribute>();
        rowAttributes.add(eventFactory.createAttribute(new QName("r"), String.valueOf(currentRowParsing)));
        if (this.rowSpan != null) {
            rowAttributes.add(eventFactory.createAttribute(new QName("spans"), this.rowSpan));
        }
        if (this.x14AcdyDescentValue != null) {
            rowAttributes.add(eventFactory.createAttribute(new QName("x14ac:dyDescent"), this.x14AcdyDescentValue));
        }
        return eventFactory.createStartElement(new QName("row"), rowAttributes.iterator(), null);
    }

    private Deque<XMLEvent> updateRowReference(XMLEvent rowToUpdate, XMLEventFactory eventFactory, int newRowIndex) {
        ArrayDeque<XMLEvent> newRowEvents = new ArrayDeque<XMLEvent>();
        StartElement newRow = eventFactory.createStartElement(rowToUpdate.asStartElement().getName(), null, null);
        newRowEvents.push(newRow);
        Iterator<Attribute> rowAttributes = rowToUpdate.asStartElement().getAttributes();
        while (rowAttributes.hasNext()) {
            Attribute attribute = rowAttributes.next();
            QName qname = attribute.getName();
            String value = attribute.getValue();
            if (qname.getLocalPart().equals("r")) {
                value = String.valueOf(newRowIndex);
            }
            newRowEvents.push(eventFactory.createAttribute(qname, value));
        }
        return newRowEvents;
    }

    private Deque<XMLEvent> updateCellReference(XMLEvent cellToUpdate, XMLEventFactory eventFactory, int newCellIndex) {
        ArrayDeque<XMLEvent> newCellEvents = new ArrayDeque<XMLEvent>();
        StartElement newRow = eventFactory.createStartElement(cellToUpdate.asStartElement().getName(), null, null);
        newCellEvents.push(newRow);
        Iterator<Attribute> rowAttributes = cellToUpdate.asStartElement().getAttributes();
        while (rowAttributes.hasNext()) {
            Attribute attribute = rowAttributes.next();
            QName qname = attribute.getName();
            String value = attribute.getValue();
            if (qname.getLocalPart().equals("r")) {
                value = value.replaceFirst("\\d+", String.valueOf(newCellIndex));
            }
            newCellEvents.push(eventFactory.createAttribute(qname, value));
        }
        return newCellEvents;
    }

    public int insertRow(XMLInputFactory inFactory, XMLOutputFactory outFactory, HashMap<Integer, Object> cellValues, HashMap<Integer, Integer> sqlTypes, Integer rowStart, Integer startColumn, Integer endColumn, int rowEnd) throws Exception {
        LinkedList<HashMap<Integer, Object>> rowsCellValues = new LinkedList<HashMap<Integer, Object>>();
        rowsCellValues.add(cellValues);
        LinkedList<HashMap<Integer, Integer>> rowsSqlTypes = new LinkedList<HashMap<Integer, Integer>>();
        rowsSqlTypes.add(sqlTypes);
        return this.insertRows(inFactory, outFactory, rowsCellValues, rowsSqlTypes, rowStart, startColumn, endColumn, rowEnd);
    }

    private void insertRow(XMLEventFactory eventFactory, HashMap<Integer, Deque<XMLEvent>> rowsEvents, HashMap<Integer, HashMap<Integer, Deque<XMLEvent>>> cellsEvents, int rowWithStyleIdx, int rowIndex, int startColumn, HashMap<Integer, Object> cellValues, HashMap<Integer, Integer> sqlTypes, Map<String, String> refCellToUpdate) throws XMLStreamException {
        ArrayDeque<XMLEvent> rowEvents = new ArrayDeque<XMLEvent>();
        ArrayList<Integer> sortedCellValues = new ArrayList<Integer>();
        sortedCellValues.addAll(cellValues.keySet());
        Collections.sort(sortedCellValues);
        StartElement newRow = eventFactory.createStartElement(new QName("row"), null, null);
        rowEvents.push(newRow);
        rowEvents.push(eventFactory.createAttribute(new QName("r"), String.valueOf(rowIndex)));
        if (this.rowSpan != null) {
            rowEvents.push(eventFactory.createAttribute(new QName("spans"), this.rowSpan));
        }
        if (this.x14AcdyDescentValue != null) {
            rowEvents.push(eventFactory.createAttribute(new QName("x14ac:dyDescent"), this.x14AcdyDescentValue));
        }
        HashMap<Integer, List<FunctionReferenceUpdater.Bloc>> formulasToAdd = new HashMap<Integer, List<FunctionReferenceUpdater.Bloc>>();
        if (this.rows.containsKey(rowWithStyleIdx) && this.rows.get(rowWithStyleIdx).getNbCells() > sortedCellValues.size()) {
            for (Cell cell : this.rows.get(rowWithStyleIdx).getCells()) {
                if (sortedCellValues.contains(cell.getColumnIndex() - startColumn + 1) || cell.getFormula() == null || cell.getFormula().isEmpty()) continue;
                sortedCellValues.add(cell.getColumnIndex());
                formulasToAdd.put(cell.getColumnIndex(), FunctionReferenceUpdater.INSTANCE.parse(cell.getFormula(), rowWithStyleIdx));
                refCellToUpdate.put(XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(rowIndex, cell.getColumnIndex()), XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(cell.getColumnIndex(), rowIndex));
            }
        }
        SharedString sharedString = this.workbook.getSharedString();
        for (Integer columnIdx : sortedCellValues) {
            boolean is1904DateSystem = this.workbook.is1904DateSystem();
            ArrayDeque<XMLEvent> cellEvents = new ArrayDeque<XMLEvent>();
            Integer cellStyle = this.colsStyle.get(columnIdx);
            Cell cell = null;
            if (this.rows.containsKey(rowWithStyleIdx)) {
                cell = this.rows.get(rowWithStyleIdx).getCell(columnIdx);
                cellStyle = cell != null ? cell.getStyle() : null;
            }
            String refCell = XlsxUtils.getExcelIndexStrFromRowNumberAndCellIdx(rowIndex, columnIdx);
            Object cellValue = cellValues.get(columnIdx);
            if (formulasToAdd.containsKey(columnIdx)) {
                for (XMLEvent event : CellFactory.createFormulaCell(eventFactory, cellStyle, refCell, null, (List)formulasToAdd.get(columnIdx))) {
                    cellEvents.push(event);
                }
            } else {
                Object sqlType;
                if (sqlTypes != null && null != (sqlType = sqlTypes.get(columnIdx))) {
                    switch ((Integer)sqlType) {
                        case -1: 
                        case 1: 
                        case 12: {
                            int index = sharedString.addValue(cellValue.toString());
                            cellValue = index;
                            break;
                        }
                    }
                }
                sqlType = CellFactory.createCell(eventFactory, sqlTypes != null ? sqlTypes.get(columnIdx) : null, cellStyle, refCell, cellValue, is1904DateSystem).iterator();
                while (sqlType.hasNext()) {
                    XMLEvent event = (XMLEvent)sqlType.next();
                    cellEvents.push(event);
                }
            }
            HashMap<Integer, ArrayDeque<XMLEvent>> cellMap = cellsEvents.get(rowIndex) != null ? cellsEvents.get(rowIndex) : new HashMap<Integer, ArrayDeque<XMLEvent>>();
            cellMap.put(columnIdx, cellEvents);
            cellsEvents.put(rowIndex, cellMap);
        }
        rowEvents.push(eventFactory.createEndElement(new QName("row"), null));
        rowsEvents.put(rowIndex, rowEvents);
    }

    private Integer insertRows(XMLEventFactory eventFactory, HashMap<Integer, Deque<XMLEvent>> rowsEvents, HashMap<Integer, HashMap<Integer, Deque<XMLEvent>>> cellsEvents, int rowWithStyleIdx, int rowIndex, int startColumn, LinkedList<HashMap<Integer, Object>> rowsCellValues, LinkedList<HashMap<Integer, Integer>> rowsCellSqlTypes, Map<String, String> refCellToUpdate, int nbRowsToInsert) throws XMLStreamException {
        int lastInsertedRow = rowIndex + nbRowsToInsert - 1;
        for (int i = 0; i < nbRowsToInsert; ++i) {
            this.insertRow(eventFactory, rowsEvents, cellsEvents, rowWithStyleIdx, rowIndex++, startColumn, rowsCellValues.poll(), rowsCellSqlTypes.poll(), refCellToUpdate);
        }
        return lastInsertedRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(Integer rowStart, Integer columnStart, Integer columnEnd, Integer rowEnd) throws Exception {
        XMLEventWriter writer = null;
        XlsFileHelper.TemporaryOutputStream outStream = null;
        InputStream inStream = null;
        XMLEventReader reader = null;
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.supportDTD", false);
        inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            inStream = this.workbook.getPackage().getFileHelper().getInputStreamFromZipStream(this.pathInsideZip);
            outStream = this.workbook.getPackage().getFileHelper().getEntryTemporaryOutputStream(this.pathInsideZip);
            Set<String> calcChainCellRef = this.workbook.getPackage().parseCalcChain();
            HashSet<String> refCellToDelete = new HashSet<String>();
            if (inStream != null && outStream != null) {
                reader = inFactory.createXMLEventReader(inStream);
                writer = outFactory.createXMLEventWriter(outStream);
                boolean writeStack = true;
                ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
                boolean deleteCell = false;
                Integer parsedRowIndex = 0;
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    switch (event.getEventType()) {
                        case 1: {
                            String value;
                            String localName;
                            Attribute attribute;
                            if (event.asStartElement().getName().getLocalPart().equals("row")) {
                                writeStack = false;
                                Iterator<Attribute> rowAttributes = event.asStartElement().getAttributes();
                                while (rowAttributes.hasNext()) {
                                    attribute = rowAttributes.next();
                                    localName = attribute.getName().getLocalPart();
                                    value = attribute.getValue();
                                    if (!localName.equals("r")) continue;
                                    parsedRowIndex = Integer.parseInt(value);
                                }
                                eventStack.push(event);
                                break;
                            }
                            if (event.asStartElement().getName().getLocalPart().equals("c")) {
                                deleteCell = false;
                                Iterator<Attribute> cellAttributes = event.asStartElement().getAttributes();
                                while (cellAttributes.hasNext()) {
                                    int columnIdx;
                                    attribute = cellAttributes.next();
                                    localName = attribute.getName().getLocalPart();
                                    value = attribute.getValue();
                                    if (!localName.equals("r") || (columnIdx = XlsxUtils.getExcelIndexLetterToInteger(value)) < columnStart || columnIdx > columnEnd || parsedRowIndex <= rowStart || parsedRowIndex > rowEnd) continue;
                                    deleteCell = true;
                                    if (!calcChainCellRef.contains(value)) continue;
                                    refCellToDelete.add(value);
                                }
                                eventStack.push(event);
                                break;
                            }
                            if (deleteCell) break;
                            eventStack.push(event);
                            break;
                        }
                        case 2: {
                            if (deleteCell && !event.asEndElement().getName().getLocalPart().equals("c")) break;
                            if (event.asEndElement().getName().getLocalPart().equals("c")) {
                                eventStack.push(event);
                                deleteCell = false;
                                break;
                            }
                            if (event.asEndElement().getName().getLocalPart().equals("row")) {
                                writeStack = true;
                                eventStack.push(event);
                                break;
                            }
                            eventStack.push(event);
                            break;
                        }
                        default: {
                            if (deleteCell) break;
                            eventStack.push(event);
                        }
                    }
                    if (!writeStack) continue;
                    Iterator iterator = eventStack.descendingIterator();
                    while (iterator.hasNext()) {
                        writer.add((XMLEvent)iterator.next());
                    }
                    eventStack.clear();
                }
            }
            writer.flush();
            outStream.save();
            if (!refCellToDelete.isEmpty()) {
                this.workbook.getPackage().removeCellRefFromCalcChain(inFactory, outFactory, refCellToDelete);
            }
            outStream = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    this.logger.warn("unexpected", (Throwable)ex);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception ex) {
                    this.logger.warn("unexpected", (Throwable)ex);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    this.logger.warn("unexpected", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllRows() throws Exception {
        XMLEventWriter writer = null;
        XlsFileHelper.TemporaryOutputStream outStream = null;
        InputStream inStream = null;
        XMLEventReader reader = null;
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.supportDTD", false);
        inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            inStream = this.workbook.getPackage().getFileHelper().getInputStreamFromZipStream(this.pathInsideZip);
            reader = inFactory.createXMLEventReader(inStream);
            outStream = this.workbook.getPackage().getFileHelper().getEntryTemporaryOutputStream(this.pathInsideZip);
            writer = outFactory.createXMLEventWriter(outStream);
            boolean writeStack = true;
            ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                eventStack.push(event);
                switch (event.getEventType()) {
                    case 1: {
                        if (!event.asStartElement().getName().getLocalPart().equals("row")) break;
                        writeStack = false;
                        break;
                    }
                    case 2: {
                        if (!event.asEndElement().getName().getLocalPart().equals("row")) break;
                        eventStack.clear();
                        writeStack = true;
                    }
                }
                if (!writeStack) continue;
                Iterator iterator = eventStack.descendingIterator();
                while (iterator.hasNext()) {
                    writer.add((XMLEvent)iterator.next());
                }
                eventStack.clear();
            }
            writer.flush();
            outStream.save();
            outStream = null;
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            } else if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    public Row getFirstRowWithData() {
        for (Row row : this.rows.values()) {
            if (row.isAnEmptyRow()) continue;
            return row;
        }
        return null;
    }

    public Integer getCachedLastRowIndex() {
        return this.lastRowIdx;
    }

    public String getPathInsideZip() {
        return this.pathInsideZip;
    }

    static {
        PROPERTY_FIELDS_NAMES.add(ROW_NUMBER);
        PROPERTY_FIELDS_NAMES.add(ROW_COUNT);
        for (String propertyField : PROPERTY_FIELDS_NAMES) {
            PROPERTY_FIELDS.put(propertyField, -1);
        }
        PROPERTY_FIELDS_NUMBER = PROPERTY_FIELDS_NAMES.size();
    }
}

