/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.microsoft.excel.wizard;

import com.indy.addons.microsoft.excel.Messages;
import com.indy.addons.microsoft.excel.wizard.Constant;
import com.indy.addons.microsoft.excel.wizard.ExcelWizardBean;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import java.io.File;
import java.util.List;

public class ExcelWizardControler {
    private ExcelWizardBean bean;
    private MdNode reversedMdNode;

    protected void parseUrl() {
        try {
            String[] splittedUrl;
            int splittedUrlLength;
            String url = MdAttributeReader.readAttribute((String)"url", (MdNode)this.reversedMdNode);
            if (url != null && (splittedUrlLength = (splittedUrl = url.split("://|\\?")).length) >= 2) {
                String path = splittedUrl[1];
                this.bean.setFileFolderPath(path);
                ExcelWizardBean.PATH_TYPE pathType = path.toUpperCase().endsWith(Constant.UPPER_EXCEL_EXTENSION) ? ExcelWizardBean.PATH_TYPE.FILE : ExcelWizardBean.PATH_TYPE.FOLDER;
                this.bean.setPathType(pathType);
                this.checkPath();
                if (splittedUrlLength >= 3) {
                    String parameters = splittedUrl[2];
                    String[] splittedParameters = parameters.split("&");
                    int splittedParametersNumber = splittedParameters.length;
                    int splittedParametersIndex = 0;
                    while (splittedParametersIndex < splittedParametersNumber) {
                        String parameterNameValue = splittedParameters[splittedParametersIndex];
                        String[] splittedParameter = parameterNameValue.split("=");
                        int splittedParameterLength = splittedParameter.length;
                        String parameterName = "";
                        String parameterValue = "";
                        if (splittedParameterLength >= 1) {
                            parameterName = splittedParameter[0];
                            if (splittedParameterLength >= 2) {
                                parameterValue = splittedParameter[1];
                            }
                        }
                        if ("columnNameStyle".equalsIgnoreCase(parameterName)) {
                            this.bean.setColumnNameStyle(parameterValue);
                        } else if (parameterName.toUpperCase().startsWith(Constant.UPPER_DEFINED_NAME_MARKUP)) {
                            ExcelWizardBean.DefinedName definedName = new ExcelWizardBean.DefinedName();
                            this.bean.addDefinedName(definedName);
                            String definedame = parameterName.substring(Constant.DEFINED_NAME_MARKUP_LENGTH, parameterName.length() - 1);
                            definedName.setName(definedame);
                            String[] splittedDefinedName = parameterValue.split("\"\\.\"|\"|\\$!");
                            int splittedDefinedNameLength = splittedDefinedName.length;
                            if (splittedDefinedNameLength >= 2) {
                                String fileName = splittedDefinedName[1];
                                definedName.setFile(fileName);
                                if (splittedDefinedNameLength >= 3) {
                                    String sheetName = splittedDefinedName[2];
                                    definedName.setSheet(sheetName);
                                    if (splittedDefinedNameLength >= 4) {
                                        String area = splittedDefinedName[3];
                                        definedName.setArea(area);
                                    }
                                }
                            }
                        }
                        ++splittedParametersIndex;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getUrl() {
        StringBuffer url = new StringBuffer("jdbc:semarchy:excel://" + this.bean.getFileFolderPath() + "?" + "columnNameStyle" + "=" + this.bean.getColumnNameStyle().toString());
        List<ExcelWizardBean.DefinedName> definedNames = this.bean.getDefinedNames();
        if (definedNames != null) {
            for (ExcelWizardBean.DefinedName definedName : definedNames) {
                url = url.append("&").append("definedNamed:\"").append(definedName.getName()).append("\"=\"").append(definedName.getFile()).append("\".\"").append(definedName.getSheet()).append("$!").append(definedName.getArea()).append("\"");
            }
        }
        return url.toString();
    }

    protected String checkPath() {
        String errorMessage;
        block7: {
            block8: {
                block9: {
                    String evaluatedpath;
                    block6: {
                        errorMessage = null;
                        String rawPath = this.bean.getFileFolderPath();
                        evaluatedpath = MdAttributeNativeEvaluator.evaluate((String)rawPath, (Configuration)this.reversedMdNode, null);
                        if (evaluatedpath != null && !evaluatedpath.trim().isEmpty()) break block6;
                        errorMessage = Messages.error_noPath;
                        break block7;
                    }
                    File file = new File(evaluatedpath);
                    if (file == null || !file.exists()) break block8;
                    ExcelWizardBean.PATH_TYPE pathType = this.bean.getPathType();
                    if (pathType == null) break block9;
                    switch (pathType) {
                        case FOLDER: {
                            if (!file.isDirectory()) {
                                errorMessage = Messages.error_directory;
                                break;
                            }
                            break block7;
                        }
                        case FILE: {
                            if (!file.isFile()) {
                                errorMessage = Messages.error_file;
                                break;
                            }
                            break block7;
                        }
                    }
                    break block7;
                }
                errorMessage = Messages.error_undifined;
                break block7;
            }
            errorMessage = Messages.error_noTarget;
        }
        return errorMessage;
    }

    protected void setBean(ExcelWizardBean bean) {
        this.bean = bean;
    }

    protected void setNode(MdNode reversedMdNode) {
        this.reversedMdNode = reversedMdNode;
    }
}

