/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindType implements Enumerator
{
    _(0, "_", ""),
    DIRECT_BIND(1, "DirectBind", "DirectBind"),
    MEMORY_BIND(2, "MemoryBind", "MemoryBind");

    public static final int __VALUE = 0;
    public static final int DIRECT_BIND_VALUE = 1;
    public static final int MEMORY_BIND_VALUE = 2;
    private static final BindType[] VALUES_ARRAY;
    public static final List<BindType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindType[]{_, DIRECT_BIND, MEMORY_BIND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindType get(int value) {
        switch (value) {
            case 0: {
                return _;
            }
            case 1: {
                return DIRECT_BIND;
            }
            case 2: {
                return MEMORY_BIND;
            }
        }
        return null;
    }

    private BindType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

