/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConnectionType implements Enumerator
{
    RDBMS(0, "RDBMS", "RDBMS"),
    FILE(1, "FILE", "FILE"),
    OLAP(2, "OLAP", "OLAP");

    public static final int RDBMS_VALUE = 0;
    public static final int FILE_VALUE = 1;
    public static final int OLAP_VALUE = 2;
    private static final ConnectionType[] VALUES_ARRAY;
    public static final List<ConnectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConnectionType[]{RDBMS, FILE, OLAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConnectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectionType get(int value) {
        switch (value) {
            case 0: {
                return RDBMS;
            }
            case 1: {
                return FILE;
            }
            case 2: {
                return OLAP;
            }
        }
        return null;
    }

    private ConnectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

