/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterType implements Enumerator
{
    INTEGER(0, "Integer", "Integer"),
    STRING(1, "String", "String"),
    BOOLEAN(2, "Boolean", "Boolean");

    public static final int INTEGER_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int BOOLEAN_VALUE = 2;
    private static final ParameterType[] VALUES_ARRAY;
    public static final List<ParameterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterType[]{INTEGER, STRING, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType get(int value) {
        switch (value) {
            case 0: {
                return INTEGER;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private ParameterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

