/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.custom;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.ParameterType;
import com.indy.gmf.proc.impl.ProcFactoryImpl;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.tech.Level;
import com.stambia.tech.MetaDataLinkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class ActionDefinitionHelper
implements IRegistryService.IRegistryItemEventListener {
    private static Map<IRegistryService.IRegistryKey, ActionDefinition> allActions = new HashMap<IRegistryService.IRegistryKey, ActionDefinition>();
    public static ActionDefinitionHelper INSTANCE = new ActionDefinitionHelper();
    private IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);

    private ActionDefinitionHelper() {
        IRegistryService.IRegistry reg = this.registryService.getRegistry(ProcessToolDescriptor.class);
        for (ProcessToolDescriptor desc : reg.getAll()) {
            if (!(desc instanceof ProcessToolDescriptor.ActionDefinition)) continue;
            allActions.put(desc.getRegistrationKey(), new ActionDefinition((ProcessToolDescriptor.ActionDefinition)desc));
        }
        reg.addRegistryItemEventListener((IRegistryService.IRegistryItemEventListener)this);
    }

    public static ActionDefinition getActionDefinition(String technology) {
        for (ActionDefinition ad : ActionDefinitionHelper.getAllAction()) {
            if (ad.getClassName() == null || !ad.getClassName().equals(technology)) continue;
            return ad;
        }
        return null;
    }

    public static ActionDefinition getActionDefinition(ActionCode action) {
        ArrayList<ActionDefinition> potentialActions = new ArrayList<ActionDefinition>();
        ActionDefinition base = null;
        for (ActionDefinition ad : ActionDefinitionHelper.getAllAction()) {
            if (ad.desc.getClass() == ProcessToolDescriptor.ActionDefinitionExtension.class) {
                potentialActions.add(ad);
                continue;
            }
            if (ad.getClassName() == null || !ad.getClassName().equals(action.getTechnology())) continue;
            base = ad;
        }
        for (ActionDefinition ad : potentialActions) {
            ProcessToolDescriptor.ActionDefinitionExtension desc = (ProcessToolDescriptor.ActionDefinitionExtension)ad.desc;
            for (MetaDataLink mdl : action.getMetaDataLink()) {
                URI o = mdl.getTargetAsURI();
                if (!desc.getDefinitionMdNodeURI().equals(o) || !desc.getClassName().equals(action.getTechnology())) continue;
                return ad;
            }
        }
        return base;
    }

    public static Collection<ActionDefinition> getAllAction() {
        return allActions.values();
    }

    public static List<ActionDefinition> getAllAction(String paletteCategory) {
        ArrayList<ActionDefinition> retour = new ArrayList<ActionDefinition>();
        for (ActionDefinition ad : ActionDefinitionHelper.getAllAction()) {
            if (ad.isHidden()) continue;
            if (ad.getPaletteCategory() != null && ad.getPaletteCategory().equals(paletteCategory)) {
                retour.add(ad);
                continue;
            }
            if (paletteCategory != null || ad.getPaletteCategory() != null) continue;
            retour.add(ad);
        }
        Collections.sort(retour, new Comparator<ActionDefinition>(){

            @Override
            public int compare(ActionDefinition o1, ActionDefinition o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return retour;
    }

    public static Set<String> getAllPaletteCategory() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ActionDefinition ad : ActionDefinitionHelper.getAllAction()) {
            if (ad.isHidden() || ad.getPaletteCategory() == null) continue;
            map.put(ad.getPaletteCategory(), "true");
        }
        return map.keySet();
    }

    public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
        if (item instanceof ProcessToolDescriptor.ActionDefinition) {
            allActions.put(key, new ActionDefinition((ProcessToolDescriptor.ActionDefinition)item));
        }
    }

    public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
        allActions.remove(key);
    }

    public void handleItemUpdated(IRegistryService.IRegistryKey registrationKey, Object item) {
        if (item instanceof ProcessToolDescriptor.ActionDefinition) {
            allActions.put(registrationKey, new ActionDefinition((ProcessToolDescriptor.ActionDefinition)item));
        }
    }

    public List<EObject> createAllRequiredParameter(ActionCode code) {
        ArrayList<EObject> l = new ArrayList<EObject>();
        if (code.getActionDefinition() != null) {
            for (ParameterDefinition def : code.getActionDefinition().getParameters()) {
                if (!def.isRequired(code)) continue;
                Parameter p = ProcFactoryImpl.eINSTANCE.createParameter();
                p.setName(def.getName());
                p.setType(ParameterType.get(def.getType()));
                if (def.getForcedValue() != null) {
                    p.setValue(def.getForcedValue());
                } else {
                    p.setValue(def.getDefaultValue());
                }
                l.add(p);
            }
        }
        return l;
    }

    public static MetaDataLink getMdLinkContainingParameterByName(Object object, String parameterName) {
        ActionCode actionCode = (ActionCode)object;
        for (MetaDataLink m : actionCode.getMetaDataLink()) {
            Level level;
            if (!m.isPublishParameters() && m.isSetPublishParameters() || !(m.getTarget() instanceof MetaDataLinkCapability) || (level = (Level)((MetaDataLinkCapability)m.getTarget()).getLevelTech()) == null) continue;
            for (MetaDataLinkType mdlt : level.getMetaDataLinkType(actionCode.getTechnology())) {
                for (String tech : mdlt.getTechnology()) {
                    if (!actionCode.getTechnology().equals(tech)) continue;
                    for (com.stambia.tech.Parameter p : mdlt.getActionCoreProperty()) {
                        if (!p.getName().equals(parameterName)) continue;
                        return m;
                    }
                }
            }
        }
        return null;
    }

    public static class ActionDefinition {
        protected ProcessToolDescriptor.ActionDefinition desc;
        private List<ParameterDefinition> params = new ArrayList<ParameterDefinition>();
        private boolean hasParamWithMdLinkInitializer = false;

        public ActionDefinition(ProcessToolDescriptor.ActionDefinition desc) {
            this.desc = desc;
            for (ProcessToolDescriptor.ParameterDescriptor d : desc.getParameters()) {
                this.params.add(new ParameterDefinition(d));
                if (!d.hasInitializer()) continue;
                this.hasParamWithMdLinkInitializer = true;
            }
        }

        public boolean hasParamatersWithMdLinkInitializer() {
            return this.hasParamWithMdLinkInitializer;
        }

        public ProcessToolDescriptor.ActionDefinition getToolDescriptor() {
            return this.desc;
        }

        public List<ProcessToolDescriptor.BindVariableDescriptor> getBindableVariable() {
            return this.desc.getBindVariables();
        }

        public List<Parameter> createAllParameter() {
            ArrayList<Parameter> retour = new ArrayList<Parameter>();
            for (ParameterDefinition pd : this.params) {
                retour.add(pd.createParameter());
            }
            return retour;
        }

        public String getName() {
            return this.desc.getName();
        }

        public String getDisplayName() {
            if (this.desc.getDisplayName() == null || this.desc.getDisplayName().isEmpty()) {
                return this.desc.getName();
            }
            return this.desc.getDisplayName();
        }

        public String getClassName() {
            return this.desc.getClassName();
        }

        public String getLongDescription() {
            if (this.desc.getLongDescription() == null || this.desc.getLongDescription().trim().isEmpty()) {
                return this.desc.getDescription();
            }
            return this.desc.getLongDescription();
        }

        public String getShortDescription() {
            return this.desc.getDescription();
        }

        public boolean isBindableAsSource() {
            return this.desc.isBindableAsSrc();
        }

        public boolean isBindableAsTarget() {
            return this.desc.isBindableAsTrg();
        }

        public List<ParameterDefinition> getParameters() {
            return this.params;
        }

        public ParameterDefinition getParameter(String name) {
            for (ParameterDefinition p : this.getParameters()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }

        public String getPaletteCategory() {
            return this.desc.getPaletteCategory();
        }

        public boolean isHidden() {
            return this.desc.isHidden();
        }

        public ProcessToolDescriptor.IconDescriptor getLargeImageDescriptor() {
            return this.desc.getLargeIcon();
        }

        public ProcessToolDescriptor.IconDescriptor getImageDescriptor() {
            return this.desc.getSmallIcon();
        }

        public boolean isCustomTool() {
            return this.desc instanceof ProcessToolDescriptor.ActionDefinitionExtension;
        }
    }

    public static class ParameterDefinition {
        private ProcessToolDescriptor.ParameterDescriptor desc;

        public ParameterDefinition(ProcessToolDescriptor.ParameterDescriptor desc) {
            this.desc = desc;
        }

        public String getLongDescription() {
            if (this.desc.getLongDescription() != null) {
                return this.desc.getLongDescription();
            }
            return this.desc.getDescription();
        }

        public String getShortDescription() {
            return this.desc.getDescription();
        }

        public String toString() {
            return this.getName();
        }

        public String getForcedValue() {
            return this.desc.getForcedValue();
        }

        public Parameter createParameter() {
            Parameter p = ProcFactoryImpl.eINSTANCE.createParameter();
            p.setName(this.getName());
            p.setType(ParameterType.get(this.getType()));
            if (this.getForcedValue() != null) {
                p.setValue(this.getForcedValue());
            } else {
                p.setValue(this.getDefaultValue());
            }
            return p;
        }

        public String getName() {
            return this.desc.getName();
        }

        public boolean isEnabled(Map<String, String> context) {
            if (this.desc.getEnablementExpression() == null) {
                return true;
            }
            ParameterEvaluation p = new ParameterEvaluation(this.desc.getEnablementExpression(), context);
            return p.eval();
        }

        public boolean isEnabled(ActionCode a) {
            Map map = a.getParameterMap();
            for (com.stambia.tech.Parameter p : this.getAllMetaDataLinkParameters(a)) {
                if (map.get(p.getName()) != null) continue;
                map.put(p.getName(), "");
            }
            return this.isEnabled(map);
        }

        public String getDisplayName() {
            return this.desc.getDiplayName();
        }

        public String getType() {
            return this.desc.getType();
        }

        public boolean isAlreadyDefineByMetaDataLink(ActionCode a) {
            for (com.stambia.tech.Parameter p : this.getAllMetaDataLinkParameters(a)) {
                String name = this.getName();
                String name2 = p.getName();
                if (!p.getName().equals(this.getName())) continue;
                return true;
            }
            if (this.desc.hasInitializer()) {
                for (MetaDataLink m : a.getMetaDataLink()) {
                    Level level;
                    if (!m.isPublishParameters() && m.isSetPublishParameters() || !(m.getTarget() instanceof MetaDataLinkCapability) || (level = (Level)((MetaDataLinkCapability)m.getTarget()).getLevelTech()) == null || !this.desc.defineInitializer4(level.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        private List<com.stambia.tech.Parameter> getAllMetaDataLinkParameters(ActionCode a) {
            ArrayList<com.stambia.tech.Parameter> retour = new ArrayList<com.stambia.tech.Parameter>();
            EList<MetaDataLink> list = a.getMetaDataLink();
            for (MetaDataLink m : list) {
                Level level;
                if (!m.isPublishParameters() && m.isSetPublishParameters() || !(m.getTarget() instanceof MetaDataLinkCapability) || (level = (Level)((MetaDataLinkCapability)m.getTarget()).getLevelTech()) == null) continue;
                for (MetaDataLinkType mdlt : level.getMetaDataLinkType(a.getTechnology())) {
                    for (com.stambia.tech.Parameter p : mdlt.getParameter()) {
                        retour.add(p);
                    }
                }
            }
            return retour;
        }

        public boolean isRequired(Action a) {
            if (this.desc.getForcedValue() != null) {
                return true;
            }
            if (a instanceof ActionCode && this.isAlreadyDefineByMetaDataLink((ActionCode)a)) {
                return false;
            }
            return this.desc.isMandatory();
        }

        public boolean isHidden() {
            return this.desc.isHidden();
        }

        public String getDefaultValue() {
            return this.desc.getDefaultValue();
        }

        public List<String> getRestriction() {
            return this.desc.getRestrictedValues();
        }
    }

    public static class ParameterEvaluation {
        boolean enabled;
        Map<String, String> map;
        ProcessToolDescriptor.EnablementExpression expr;

        public ParameterEvaluation(ProcessToolDescriptor.EnablementExpression expr, Map<String, String> map) {
            this.expr = expr;
            this.map = map;
        }

        public boolean eval() {
            boolean retour = false;
            block0 : switch (this.expr.getType()) {
                case 1: {
                    for (ProcessToolDescriptor.EnablementExpression child : this.expr.getChildren()) {
                        ParameterEvaluation _child = new ParameterEvaluation(child, this.map);
                        if (_child.eval()) continue;
                        retour = true;
                    }
                    break;
                }
                case 2: {
                    for (ProcessToolDescriptor.EnablementExpression child : this.expr.getChildren()) {
                        ParameterEvaluation _child = new ParameterEvaluation(child, this.map);
                        if (!_child.eval()) continue;
                        retour = true;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    boolean tmp = false;
                    for (ProcessToolDescriptor.EnablementExpression child : this.expr.getChildren()) {
                        ParameterEvaluation _child = new ParameterEvaluation(child, this.map);
                        if (_child.eval()) continue;
                        tmp = true;
                        break;
                    }
                    retour = !tmp;
                    break;
                }
                case 4: {
                    retour = this.map.get(this.expr.getParameterName()) != null && this.expr.getParameterValue() != null && !this.expr.getParameterValue().equals("") && !this.map.get(this.expr.getParameterName()).equals("") ? this.map.get(this.expr.getParameterName()).equals(this.expr.getParameterValue()) : false;
                    break;
                }
                case 5: {
                    String name2 = this.expr.getParameterName();
                    retour = this.map.containsKey(name2);
                }
            }
            return retour;
        }
    }
}

