/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.impl.custom;

import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.custom.ActionDefinitionHelper;
import com.indy.gmf.proc.impl.ParameterImpl;
import com.indy.gmf.proc.impl.custom.CommonHelper;
import com.indy.gmf.proc.impl.custom.Messages;
import com.semarchy.xdi.designer.core.utils.MetaInfParserUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomParameter
extends ParameterImpl {
    private static final String META_INF_CATEGORY_OVERRIDE = "process-parameter-support";
    private static final String META_INF_FORCE_DEFAULT_VALUE = "forceDefaultParameterValue";
    private static final String ATTRIBUTE_NAME = "name";
    private CommonHelper commonHelper = new CommonHelper(this);
    private TreeMap<String, String> parameterValues = null;
    private Boolean editable = null;
    String deprecatedMessage = null;
    boolean hasCheckedDeprecatedMetaInf = false;

    @Override
    public ActionDefinitionHelper.ParameterDefinition getParameterDefinition() {
        ActionDefinitionHelper.ActionDefinition ad;
        if (this.eContainer != null && this.eContainer() instanceof ActionCode && this.getName() != null && (ad = ((ActionCode)this.eContainer()).getActionDefinition()) != null) {
            return ad.getParameter(this.getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDefaultValueForced() {
        if (this.getMetaInf() == null) return false;
        if (this.getMetaInf().trim().isEmpty()) return false;
        String s = this.getMetaInf().trim();
        try {
            if (!s.startsWith("<process-parameter-support")) return false;
            NodeList nodeList = MetaInfParserUtil.parseMetaInf((String)this.metaInf, (String)META_INF_CATEGORY_OVERRIDE);
            int i = 0;
            while (true) {
                if (i >= nodeList.getLength()) {
                    return false;
                }
                Node node = nodeList.item(i);
                if (node instanceof Element && META_INF_FORCE_DEFAULT_VALUE.equals(((Element)node).getAttribute(ATTRIBUTE_NAME))) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getTooltip() {
        if (this.getDescription() == null && this.getParameterDefinition() != null) {
            return this.getParameterDefinition().getLongDescription();
        }
        return this.getDescription();
    }

    @Override
    public void setMetaInf(String newMetaInf) {
        super.setMetaInf(newMetaInf);
        this.parameterValues = null;
        this.deprecatedMessage = null;
        this.hasCheckedDeprecatedMetaInf = false;
    }

    private void refreshValues() {
        if (this.parameterValues == null) {
            if (this.getParameterDefinition() != null && this.getParameterDefinition().getRestriction() != null && !this.getParameterDefinition().getRestriction().isEmpty()) {
                this.parameterValues = new TreeMap();
                for (String s : this.getParameterDefinition().getRestriction()) {
                    this.parameterValues.put(s, s);
                }
                return;
            }
            if (this.getMetaInf() != null && !this.getMetaInf().trim().isEmpty()) {
                try {
                    NodeList nl = MetaInfParserUtil.parseMetaInf((String)this.getMetaInf());
                    if (nl != null) {
                        int i = 0;
                        while (i < nl.getLength()) {
                            Node node = nl.item(i);
                            Node attr = node.getAttributes().getNamedItem("id");
                            if (attr != null) {
                                if (attr.getNodeValue().equals("value")) {
                                    if (this.parameterValues == null) {
                                        this.parameterValues = new TreeMap();
                                    }
                                    String value = node.getAttributes().getNamedItem("value").getNodeValue();
                                    Node n = node.getAttributes().getNamedItem("label");
                                    if (n != null) {
                                        this.parameterValues.put(n.getNodeValue(), value);
                                    } else {
                                        this.parameterValues.put(value, value);
                                    }
                                } else if (attr.getNodeValue().equals("editable") && node.getAttributes().getNamedItem("value").getNodeValue().equals("false")) {
                                    this.editable = false;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    this.parameterValues = null;
                }
            }
        }
    }

    @Override
    public List<String> getPossibleValuesLabels() {
        this.refreshValues();
        if (this.parameterValues == null || this.parameterValues.size() <= 1) {
            return null;
        }
        return new ArrayList<String>(this.parameterValues.keySet());
    }

    @Override
    public String getValueForLabel(String label) throws Exception {
        this.refreshValues();
        if (this.parameterValues == null || this.parameterValues.size() <= 1) {
            return label;
        }
        String s = this.parameterValues.get(label);
        if (s != null) {
            return s;
        }
        if (s == null && this.isEditable()) {
            return label;
        }
        throw new Exception(String.format(Messages.CustomParameter_parameterNotEditable, label));
    }

    @Override
    public boolean isEditable() {
        if (this.editable != null) {
            return this.editable;
        }
        return true;
    }

    @Override
    public String getLabelForValue(String value) throws Exception {
        this.refreshValues();
        if (this.parameterValues == null || this.parameterValues.size() <= 1) {
            return value;
        }
        for (String k : this.parameterValues.keySet()) {
            if (value == null || !value.equals(this.parameterValues.get(k))) continue;
            return k;
        }
        if (this.isEditable()) {
            return value;
        }
        throw new Exception(String.format(Messages.CustomParameter_parameterNotEditable, this.label));
    }

    @Override
    public String getDeprecatedMessage() {
        block6: {
            if (this.hasCheckedDeprecatedMetaInf) {
                return this.deprecatedMessage;
            }
            if (this.getMetaInf() != null && !this.getMetaInf().trim().isEmpty()) {
                try {
                    NodeList nl = MetaInfParserUtil.parseMetaInf((String)this.getMetaInf());
                    if (nl == null) break block6;
                    int i = 0;
                    while (i < nl.getLength()) {
                        Node n = nl.item(i);
                        Node metaInfName = n.getAttributes().getNamedItem(ATTRIBUTE_NAME);
                        if (metaInfName != null && metaInfName.getNodeValue().equals("deprecated")) {
                            this.deprecatedMessage = n.getTextContent();
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.hasCheckedDeprecatedMetaInf = true;
        return this.deprecatedMessage;
    }

    @Override
    public String getFullPath() {
        return this.commonHelper.getFullPath();
    }

    @Override
    public List<Parameter> getAllParentParameter() {
        return this.commonHelper.getAllParentParameter();
    }
}

