/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.Messages;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModuleRequirmentService;
import com.semarchy.xdi.designer.core.services.IRegistryContributionHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.ModuleRequirment;
import com.semarchy.xdi.designer.core.utils.MemoryMonitor;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IModuleRequirmentService.class})
public class ModuleRequirmentComponent
implements IModuleRequirmentService {
    Set<String> requiredModules = new HashSet<String>();
    Map<String, Collection<String>> modelPerRequiredModule = new HashMap<String, Collection<String>>();
    Set<String> requiredBaseModules = new HashSet<String>();
    Map<String, Collection<String>> modelPerRequiredBaseModule = new HashMap<String, Collection<String>>();
    @Reference
    IModuleService moduleService;
    @Reference
    ICacheService cacheService;
    @Reference
    IRegistryContributionHelper registryContributionHelper;

    public Job createRefresh() throws Exception {
        WkspExtractJob job = new WkspExtractJob();
        job.setUser(true);
        return job;
    }

    public Collection<String> getMissingModules() {
        HashSet<String> missing = new HashSet<String>();
        for (String m : this.requiredModules) {
            IModuleService.IModule module = this.moduleService.getModule(m);
            if (module != null) continue;
            missing.add(m);
        }
        return missing;
    }

    public IModuleRequirmentService.ModelModuleState getState(URI modelURI) {
        String modelId = this.cacheService.getSourceId(modelURI);
        HashSet<String> expectedBaseModule = new HashSet<String>();
        String modelModuleName = null;
        if (modelId != null) {
            Collection<String> ids;
            for (String s : this.requiredBaseModules) {
                ids = this.modelPerRequiredBaseModule.get(s);
                if (ids == null || !ids.contains(modelId)) continue;
                expectedBaseModule.add(s);
            }
            for (String s : this.requiredModules) {
                ids = this.modelPerRequiredModule.get(s);
                if (ids == null || !ids.contains(modelId)) continue;
                modelModuleName = s;
                break;
            }
        }
        if (modelModuleName != null) {
            IModuleService.IModule module = this.moduleService.getModule(modelModuleName);
            if (module != null) {
                if (expectedBaseModule.contains(module.getDescriptor().getBaseModuleInfo().getId())) {
                    return IModuleRequirmentService.ModelModuleState.MATCH_BASE_MODULE;
                }
                return IModuleRequirmentService.ModelModuleState.SPECIFIED;
            }
            return IModuleRequirmentService.ModelModuleState.INEXISTANT;
        }
        return IModuleRequirmentService.ModelModuleState.UNSPECIFIED;
    }

    public Map<String, Collection<URI>> getModelsWithModuleRequirment() {
        HashMap<String, Collection<URI>> c = new HashMap<String, Collection<URI>>();
        try {
            for (String basemodule : this.requiredBaseModules) {
                Collection<String> l = this.modelPerRequiredBaseModule.get(basemodule);
                if (l == null) continue;
                for (String id : l) {
                    if (c.get(basemodule) == null) {
                        c.put(basemodule, new HashSet());
                    }
                    ((Collection)c.get(basemodule)).add(this.cacheService.findResourceURIByFileId(id));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public String getSpecifiedModuleName(URI uri) {
        String modelId = this.cacheService.getSourceId(uri);
        for (String k : this.modelPerRequiredModule.keySet()) {
            if (!this.modelPerRequiredModule.get(k).contains(modelId)) continue;
            return k;
        }
        return null;
    }

    public Job createRefresh(final Collection<URI> modelsURI) throws Exception {
        return new AbstractExtractJob(this){

            @Override
            Collection<URI> getMdModelToAnalyze(IProgressMonitor monitor) {
                return modelsURI;
            }
        };
    }

    abstract class AbstractExtractJob
    extends Job {
        private TransactionalEditingDomain editingDomain;

        public AbstractExtractJob() {
            super(Messages.ModuleRequirmentComponent_job_moduleRequirement_name);
            this.createEditingDomain();
            this.setUser(true);
        }

        private void createEditingDomain() {
            this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
            ResourceSet rs = this.editingDomain.getResourceSet();
            ((ResourceSetImpl)rs).setURIResourceMap(new WeakHashMap());
            rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
            rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }

        private void freeMemory() {
            if (MemoryMonitor.isMemoryLow((int)40)) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Available Heap Size is getting thin, trying to release EMF resources ...");
                this.editingDomain.getCommandStack().flush();
                ((ResourceSetImpl)this.editingDomain.getResourceSet()).getURIResourceMap().clear();
                for (Resource r : this.editingDomain.getResourceSet().getResources()) {
                    try {
                        r.unload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.editingDomain.getResourceSet().getResources().clear();
                System.gc();
            }
        }

        abstract Collection<URI> getMdModelToAnalyze(IProgressMonitor var1);

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            res = new ArrayList<E>();
            ms = new MultiStatus("com.indy.libraries.managemenr", 0, this.getName(), null);
            try {
                sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                modelsURI = this.getMdModelToAnalyze(monitor);
                monitor.beginTask(Messages.ModuleRequirmentComponent_extractingModuleRequirement, modelsURI.size());
                for (URI uri : modelsURI) {
                    block17: {
                        monitor.subTask(uri.toString());
                        if (monitor.isCanceled()) {
                            var12_12 = Status.CANCEL_STATUS;
                            return var12_12;
                        }
                        try {
                            try {
                                r = this.editingDomain.getResourceSet().getResource(uri, true);
                                if (!(r instanceof IRegistryService.IRegistrationContribution)) break block17;
                                try {
                                    newItems = ((IRegistryService.IRegistrationContribution)r).createRegistryItemsFor(ModuleRequirment.class);
                                    if (newItems != null) {
                                        res.addAll(newItems);
                                    }
                                }
                                catch (Exception ex) {
                                    ms.add((IStatus)new Status(4, "com.indy.ui.custom.out", String.valueOf(Messages.ModuleRequirmentComponent_7) + r, (Throwable)ex));
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.freeMemory();
                                monitor.worked(1);
                                continue;
                            }
                        }
                        catch (Throwable var10_22) {
                            this.freeMemory();
                            monitor.worked(1);
                            throw var10_22;
                        }
                    }
                    this.freeMemory();
                    monitor.worked(1);
                }
            }
            finally {
                this.editingDomain.dispose();
                ModuleRequirmentComponent.this.requiredModules.clear();
                ModuleRequirmentComponent.this.modelPerRequiredModule.clear();
                ModuleRequirmentComponent.this.requiredBaseModules.clear();
                ModuleRequirmentComponent.this.modelPerRequiredBaseModule.clear();
                ** for (o : res)
            }
lbl-1000:
            // 1 sources

            {
                if (!(o instanceof ModuleRequirment)) continue;
                r = (ModuleRequirment)o;
                if (r.getRequiredModuleName() != null) {
                    if (ModuleRequirmentComponent.this.requiredModules.add(r.getRequiredModuleName())) {
                        ModuleRequirmentComponent.this.modelPerRequiredModule.put(r.getRequiredModuleName(), new HashSet<E>());
                    }
                    ModuleRequirmentComponent.this.modelPerRequiredModule.get(r.getRequiredModuleName()).add(r.getRegistrationKey().getProviderFileID());
                }
                if (r.getRequiredBaseModule() == null) continue;
                if (ModuleRequirmentComponent.this.requiredBaseModules.add(r.getRequiredBaseModule())) {
                    ModuleRequirmentComponent.this.modelPerRequiredBaseModule.put(r.getRequiredBaseModule(), new HashSet<E>());
                }
                ModuleRequirmentComponent.this.modelPerRequiredBaseModule.get(r.getRequiredBaseModule()).add(r.getRegistrationKey().getProviderFileID());
                continue;
            }
lbl62:
            // 1 sources

            monitor.done();
            return var12_12;
        }
    }

    private class Visitor
    implements IResourceVisitor {
        HashMap<URI, IFile> modelsToAnalyze = new HashMap();
        Set<String> handledModelIds = new HashSet<String>();

        private Visitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return resource.getProject().exists() && resource.getProject().isOpen();
                }
                case 2: {
                    return resource.getParent().getType() != 4 || !resource.getName().equals("indy.build") && !resource.getName().equals("indy.diagram");
                }
                case 1: {
                    URI activeModelURI;
                    URI uri;
                    String srcId;
                    if (!"md".equals(resource.getFileExtension()) || (srcId = ModuleRequirmentComponent.this.cacheService.getSourceId(uri = URIUtils.convertIPathToEMFURI2((IPath)((IFile)resource).getFullPath()))) == null || !this.handledModelIds.add(srcId) || !ModuleRequirmentComponent.this.registryContributionHelper.isContributingToRegistry(srcId, ModuleRequirment.class) || (activeModelURI = ModuleRequirmentComponent.this.cacheService.findResourceURIByFileId(srcId)) == null) break;
                    this.modelsToAnalyze.put(activeModelURI, (IFile)resource);
                }
            }
            return false;
        }
    }

    class WkspExtractJob
    extends AbstractExtractJob {
        WkspExtractJob() {
        }

        @Override
        Collection<URI> getMdModelToAnalyze(IProgressMonitor monitor) {
            Visitor visitor = new Visitor();
            try {
                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            monitor.beginTask(Messages.ModuleRequirmentComponent_extractingModuleRequirement, visitor.modelsToAnalyze.size());
            return visitor.modelsToAnalyze.keySet();
        }
    }
}

