/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler.impl.jobs;

import com.indy.engine.core.common.GlobalVarI;
import com.indy.engine.scheduler.impl.jobs.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class CommandLineDeliveryExecutionJob
implements StatefulJob {
    Logger log = LogManager.getLogger((String)"org.quartz");

    protected String getModuleFolderPath() {
        String folder = System.getProperty("xdi.designer.module.path.v1");
        if (folder == null) {
            folder = System.getProperty("stambia.module.path.v1");
        }
        return folder;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobName = null;
        try {
            String str;
            Map variables;
            String deliveryName;
            Process proc = null;
            jobName = context.getJobDetail().getKey().getName();
            this.log.info("Job: " + jobName + " fired");
            JobDataMap data = context.getJobDetail().getJobDataMap();
            Map parameters = (Map)data.get((Object)context.getTrigger().getKey().getName());
            String sessName = null;
            String configuration = null;
            if (parameters != null) {
                sessName = (String)parameters.get("sessName");
                configuration = (String)parameters.get("configuration");
            }
            if ((deliveryName = (String)parameters.get("deliveryName")) == null) {
                deliveryName = data.getString("deliveryName");
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java");
            String str1 = System.getProperty("java.system.class.loader");
            if (str1 != null && str1.equals("com.indy.engine.StambiaSystemClassLoader")) {
                command.add("-Djava.system.class.loader=com.indy.engine.StambiaSystemClassLoader");
            }
            if ((str1 = System.getProperty("stambia.classpath.v1.core")) != null && !str1.isEmpty()) {
                command.add("-Dstambia.classpath.v1.core=" + str1);
            }
            if ((str1 = System.getProperty("stambia.classpath.v1.internal")) != null && !str1.isEmpty()) {
                command.add("-Dstambia.classpath.v1.internal=" + str1);
            }
            if ((str1 = this.getModuleFolderPath()) != null && !str1.isEmpty()) {
                command.add("-Dxdi.designer.module.path.v1=" + str1);
            }
            if ((str1 = System.getProperty("stambia.default.classpath.name")) != null && !str1.isEmpty()) {
                command.add("-Dstambia.default.classpath.name=" + str1);
            }
            command.add("-classpath");
            command.add(System.getProperty("java.class.path"));
            command.add("com.indy.engine.launcher.MainLauncher");
            command.add("-mainclass");
            command.add("com.indy.engine.StartDelivery");
            command.add("-name");
            command.add(deliveryName);
            command.add("-launchMode");
            command.add("SCHEDULE");
            command.add("-jobName");
            command.add(context.getJobDetail().getKey().getName());
            if (sessName != null && !sessName.isEmpty()) {
                command.add("-sessionname");
                command.add(sessName);
            }
            if (configuration != null && !configuration.isEmpty()) {
                command.add("-configuration");
                command.add(configuration);
            }
            if (GlobalVarI.getGlobalProperties() != null && GlobalVarI.getGlobalProperties().geConfFilePath() != null) {
                command.add("-conf");
                command.add(GlobalVarI.getGlobalProperties().geConfFilePath());
            }
            if ((variables = (Map)parameters.get("variables")) != null) {
                for (Map.Entry var : variables.entrySet()) {
                    command.add("-var");
                    command.add((String)var.getKey());
                    command.add((String)var.getValue());
                }
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            proc = pb.start();
            BufferedReader outputReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));
            StringBuilder builder = new StringBuilder();
            while ((str = outputReader.readLine()) != null) {
                builder.append(str);
                builder.append('\n');
            }
            System.out.println(builder.toString());
            proc.waitFor();
            this.log.debug(String.valueOf(Messages.getString("CommandLineDeliveryExecutionJob.0")) + jobName + Messages.getString("CommandLineDeliveryExecutionJob.1"));
        }
        catch (Exception e) {
            this.log.error(String.valueOf(Messages.getString("CommandLineDeliveryExecutionJob.2")) + jobName + Messages.getString("CommandLineDeliveryExecutionJob.3"), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

